/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.comm.socket;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.jppf.comm.socket.SocketWrapper;
import org.jppf.utils.JPPFBuffer;
import org.jppf.utils.ObjectSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketChannelClient
implements SocketWrapper {
    private static Logger log = LoggerFactory.getLogger(SocketChannelClient.class);
    private SocketChannel channel = null;
    private String host = null;
    private int port = -1;
    private ObjectSerializer serializer = null;
    private boolean opened = false;
    private boolean blocking = false;

    public SocketChannelClient(boolean blocking) throws IOException {
        this.blocking = blocking;
    }

    public SocketChannelClient(String host, int port, boolean blocking) throws IOException {
        this(blocking);
        this.host = host;
        this.port = port;
    }

    public void send(Object o) throws Exception {
        JPPFBuffer buf = this.getSerializer().serialize(o);
        this.sendBytes(buf);
    }

    public void sendBytes(JPPFBuffer buf) throws Exception {
        int length = buf.getLength();
        this.writeInt(length);
        this.write(buf.getBuffer(), 0, length);
    }

    public void write(byte[] data, int offset, int len) throws Exception {
        ByteBuffer buffer = ByteBuffer.wrap(data, offset, len);
        for (int count = 0; count < len; count += this.channel.write(buffer)) {
        }
    }

    public void writeInt(int n) throws Exception {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(n);
        buffer.flip();
        for (int count = 0; count < 4; count += this.channel.write(buffer)) {
        }
    }

    public void flush() throws IOException {
    }

    public Object receive() throws Exception {
        return this.receive(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object receive(int timeout) throws Exception {
        Object o = null;
        try {
            if (timeout > 0) {
                this.channel.socket().setSoTimeout(timeout);
            }
            JPPFBuffer buf = this.receiveBytes(timeout);
            o = this.getSerializer().deserialize(buf);
        }
        finally {
            if (timeout > 0) {
                this.channel.socket().setSoTimeout(0);
            }
        }
        return o;
    }

    public JPPFBuffer receiveBytes(int timeout) throws Exception {
        int length = this.readInt();
        byte[] data = new byte[length];
        this.read(data, 0, length);
        return new JPPFBuffer(data, length);
    }

    public int read(byte[] data, int offset, int len) throws Exception {
        int count;
        ByteBuffer byteBuffer = ByteBuffer.wrap(data, offset, len);
        for (count = 0; count < len; count += this.channel.read(byteBuffer)) {
        }
        return count;
    }

    public int readInt() throws Exception {
        ByteBuffer buf = ByteBuffer.allocate(4);
        for (int count = 0; count < 4; count += this.channel.read(buf)) {
        }
        buf.flip();
        return buf.getInt();
    }

    public void open() throws ConnectException, IOException {
        this.channel = SocketChannel.open();
        this.channel.socket().setReceiveBufferSize(65536);
        this.channel.socket().setSendBufferSize(65536);
        this.channel.socket().setTcpNoDelay(true);
        this.channel.configureBlocking(this.blocking);
        InetSocketAddress address = new InetSocketAddress(this.host, this.port);
        this.channel.connect(address);
        while (!this.channel.finishConnect()) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.opened = true;
        if (log.isDebugEnabled()) {
            log.debug("getReceiveBufferSize() = " + this.channel.socket().getReceiveBufferSize());
        }
    }

    public void close() throws ConnectException, IOException {
        if (this.opened) {
            this.opened = false;
            this.channel.close();
        }
    }

    public boolean isOpened() {
        return this.opened;
    }

    public ObjectSerializer getSerializer() {
        if (this.serializer == null) {
            String name = "org.jppf.utils.ObjectSerializerImpl";
            try {
                this.serializer = (ObjectSerializer)Class.forName(name).newInstance();
            }
            catch (InstantiationException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.serializer;
    }

    public void setSerializer(ObjectSerializer serializer) {
        this.serializer = serializer;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Socket getSocket() {
        return this.channel.socket();
    }

    public void setSocket(Socket socket) {
    }

    public SocketChannel getChannel() {
        return this.channel;
    }

    public void setChannel(SocketChannel channel) {
        this.channel = channel;
    }

    public int skip(int n) throws Exception {
        int r;
        if (n < 0) {
            throw new IllegalArgumentException("number of bytes to skip must be >= 0");
        }
        if (n == 0) {
            return 0;
        }
        ByteBuffer buf = ByteBuffer.allocate(n);
        while (buf.hasRemaining() && ((r = this.channel.read(buf)) != 0 || !this.blocking) && r >= 0) {
        }
        return buf.position();
    }

    public void write(byte[] data) throws Exception {
        this.write(data, 0, data.length);
    }

    public long getSocketTimestamp() {
        return System.currentTimeMillis();
    }
}

