/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.taskwrapper;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import org.jppf.JPPFException;
import org.jppf.client.taskwrapper.AbstractPrivilegedAction;
import org.jppf.client.taskwrapper.AbstractTaskObjectWrapper;
import org.jppf.client.taskwrapper.PrivilegedConstructorAction;
import org.jppf.client.taskwrapper.PrivilegedMethodAction;
import org.jppf.client.taskwrapper.TaskObjectWrapper;
import org.jppf.utils.ReflectionUtils;

class AnnotatedTaskWrapper
extends AbstractTaskObjectWrapper {
    private static final long serialVersionUID = 1L;
    private Object taskObject = null;
    private Object[] args = null;
    private String className = null;

    public AnnotatedTaskWrapper(Object taskObject, Object ... args) throws JPPFException {
        boolean isClass = taskObject instanceof Class;
        Class<?> clazz = isClass ? (Class<?>)taskObject : taskObject.getClass();
        AnnotatedElement elt = ReflectionUtils.getJPPFAnnotatedElement(clazz);
        if (elt == null) {
            throw new JPPFException("object '" + taskObject + "' is not a JPPFTask nor JPPF-annotated");
        }
        if (elt instanceof Method) {
            if (isClass) {
                this.methodType = TaskObjectWrapper.MethodType.STATIC;
                this.className = clazz.getName();
            } else {
                this.methodType = TaskObjectWrapper.MethodType.INSTANCE;
                this.taskObject = taskObject;
            }
        } else {
            this.methodType = TaskObjectWrapper.MethodType.CONSTRUCTOR;
            this.className = clazz.getName();
        }
        this.args = args;
    }

    @Override
    public Object execute() throws Exception {
        Class<?> clazz = TaskObjectWrapper.MethodType.INSTANCE.equals((Object)this.methodType) ? this.taskObject.getClass() : Class.forName(this.className);
        Object result = null;
        AbstractPrivilegedAction action = null;
        switch (this.methodType) {
            case CONSTRUCTOR: {
                Constructor c = (Constructor)ReflectionUtils.getJPPFAnnotatedElement(clazz);
                action = new PrivilegedConstructorAction(c, this.args);
                break;
            }
            default: {
                Method m = (Method)ReflectionUtils.getJPPFAnnotatedElement(clazz);
                action = new PrivilegedMethodAction(m, this.taskObject, this.args);
            }
        }
        result = AccessController.doPrivileged(action);
        if (action.getException() != null) {
            throw action.getException();
        }
        return result;
    }

    @Override
    public Object getTaskObject() {
        return this.taskObject;
    }
}

