/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.classify.BinaryExceptionClassifier;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.exception.ExceptionHandler;
import org.springframework.batch.repeat.support.RepeatSynchronizationManager;
import org.springframework.batch.retry.RetryCallback;
import org.springframework.batch.retry.RetryContext;
import org.springframework.batch.retry.RetryPolicy;
import org.springframework.batch.retry.listener.RetryListenerSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleRetryExceptionHandler
extends RetryListenerSupport
implements ExceptionHandler {
    private static final String EXHAUSTED = SimpleRetryExceptionHandler.class.getName() + ".RETRY_EXHAUSTED";
    private static final Log logger = LogFactory.getLog(SimpleRetryExceptionHandler.class);
    private final RetryPolicy retryPolicy;
    private final ExceptionHandler exceptionHandler;
    private final BinaryExceptionClassifier fatalExceptionClassifier;

    public SimpleRetryExceptionHandler(RetryPolicy retryPolicy, ExceptionHandler exceptionHandler, Collection<Class<? extends Throwable>> fatalExceptionClasses) {
        this.retryPolicy = retryPolicy;
        this.exceptionHandler = exceptionHandler;
        this.fatalExceptionClassifier = new BinaryExceptionClassifier();
        this.fatalExceptionClassifier.setTypes(fatalExceptionClasses);
    }

    public void handleException(RepeatContext context, Throwable throwable) throws Throwable {
        if (((Boolean)this.fatalExceptionClassifier.classify((Object)throwable)).booleanValue() || context.hasAttribute(EXHAUSTED)) {
            this.exceptionHandler.handleException(context, throwable);
        } else {
            logger.debug((Object)"handled non-fatal exception", throwable);
        }
    }

    public <T> void close(RetryContext context, RetryCallback<T> callback, Throwable throwable) {
        if (!this.retryPolicy.canRetry(context)) {
            this.getRepeatContext().setAttribute(EXHAUSTED, (Object)"true");
        }
    }

    private RepeatContext getRepeatContext() {
        RepeatContext context = RepeatSynchronizationManager.getContext();
        if (context.getParent() != null) {
            return context.getParent();
        }
        return context;
    }
}

