/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.scope.util;

import java.beans.PropertyEditor;
import java.util.Date;
import org.springframework.aop.target.SimpleBeanTargetSource;
import org.springframework.batch.core.scope.util.ContextFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyEditorRegistrySupport;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionVisitor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.core.AttributeAccessor;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;
import org.springframework.util.StringValueResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlaceholderTargetSource
extends SimpleBeanTargetSource
implements InitializingBean {
    private static final String PLACEHOLDER_PREFIX = "#{";
    private static final String PLACEHOLDER_SUFFIX = "}";
    private ContextFactory contextFactory;
    private String beanName;

    public void setContextFactory(ContextFactory contextFactory) {
        this.contextFactory = contextFactory;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.contextFactory, (String)"The ContextFactory must be set.");
        this.beanName = this.getTargetBeanName() + "#" + this.contextFactory.getContextId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object getTarget() throws BeansException {
        Object target = this.getTargetFromContext();
        if (target != null) {
            return target;
        }
        DefaultListableBeanFactory listableBeanFactory = (DefaultListableBeanFactory)this.getBeanFactory();
        final TypeConverter typeConverter = listableBeanFactory.getTypeConverter();
        DefaultListableBeanFactory beanFactory = new DefaultListableBeanFactory((BeanFactory)listableBeanFactory);
        beanFactory.copyConfigurationFrom((ConfigurableBeanFactory)listableBeanFactory);
        final TypeConverter contextTypeConverter = new TypeConverter(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Object convertIfNecessary(Object value, Class requiredType, MethodParameter methodParam) throws TypeMismatchException {
                Object result = null;
                if (value instanceof String) {
                    String key = (String)value;
                    if (!key.startsWith(PlaceholderTargetSource.PLACEHOLDER_PREFIX) || !key.endsWith(PlaceholderTargetSource.PLACEHOLDER_SUFFIX) || (result = PlaceholderTargetSource.this.convertFromContext(key = PlaceholderTargetSource.this.extractKey(key), requiredType, typeConverter)) != null) return result != null ? result : typeConverter.convertIfNecessary(value, requiredType, methodParam);
                    Object property = PlaceholderTargetSource.this.getPropertyFromContext(key);
                    if (property == null) throw new IllegalStateException("Cannot bind to placeholder: " + key);
                    if ((property = PlaceholderTargetSource.this.convertToString(property, typeConverter)) == null) return result != null ? result : typeConverter.convertIfNecessary(value, requiredType, methodParam);
                    value = property;
                    return result != null ? result : typeConverter.convertIfNecessary(value, requiredType, methodParam);
                } else if (requiredType.isAssignableFrom(value.getClass())) {
                    result = value;
                    return result != null ? result : typeConverter.convertIfNecessary(value, requiredType, methodParam);
                } else {
                    if (!requiredType.isAssignableFrom(String.class) || (result = PlaceholderTargetSource.this.convertToString(value, typeConverter)) != null) return result != null ? result : typeConverter.convertIfNecessary(value, requiredType, methodParam);
                    PlaceholderTargetSource.this.logger.debug((Object)("Falling back on toString for conversion of : [" + value.getClass() + "]"));
                    result = value.toString();
                }
                return result != null ? result : typeConverter.convertIfNecessary(value, requiredType, methodParam);
            }

            public Object convertIfNecessary(Object value, Class requiredType) throws TypeMismatchException {
                return this.convertIfNecessary(value, requiredType, null);
            }
        };
        beanFactory.setTypeConverter(contextTypeConverter);
        try {
            String targetBeanName = this.getTargetBeanName();
            GenericBeanDefinition beanDefinition = new GenericBeanDefinition(listableBeanFactory.getMergedBeanDefinition(targetBeanName));
            this.logger.debug((Object)("Rehydrating scoped target: [" + targetBeanName + "]"));
            BeanDefinitionVisitor visitor = new BeanDefinitionVisitor(new StringValueResolver(){

                public String resolveStringValue(String strVal) {
                    if (!strVal.contains(PlaceholderTargetSource.PLACEHOLDER_PREFIX)) {
                        return strVal;
                    }
                    if (strVal.startsWith(PlaceholderTargetSource.PLACEHOLDER_PREFIX) && strVal.endsWith(PlaceholderTargetSource.PLACEHOLDER_SUFFIX)) {
                        StringBuilder result = new StringBuilder(strVal);
                        String key = PlaceholderTargetSource.this.extractKey(strVal);
                        PlaceholderTargetSource.this.replaceIfTypeMatches(result, 0, strVal.length() - 1, key, String.class, typeConverter);
                        return result.toString();
                    }
                    return PlaceholderTargetSource.this.replacePlaceholders(strVal, contextTypeConverter);
                }
            }){

                protected Object resolveValue(Object value) {
                    if (value instanceof TypedStringValue) {
                        TypedStringValue typedStringValue = (TypedStringValue)value;
                        String stringValue = typedStringValue.getValue();
                        if (stringValue != null) {
                            String visitedString = this.resolveStringValue(stringValue);
                            value = new TypedStringValue(visitedString);
                        }
                    } else {
                        value = super.resolveValue(value);
                    }
                    return value;
                }
            };
            beanFactory.registerBeanDefinition(this.beanName, (BeanDefinition)beanDefinition);
            visitor.visitBeanDefinition((BeanDefinition)beanDefinition);
            target = beanFactory.getBean(this.beanName);
            this.putTargetInContext(target);
            Object object = target;
            return object;
        }
        finally {
            beanFactory.removeBeanDefinition(this.beanName);
            beanFactory = null;
        }
    }

    private void putTargetInContext(Object target) {
        Object context = this.contextFactory.getContext();
        if (context instanceof AttributeAccessor) {
            ((AttributeAccessor)context).setAttribute(this.beanName, target);
        }
    }

    private Object getTargetFromContext() {
        Object context = this.contextFactory.getContext();
        if (context instanceof AttributeAccessor) {
            return ((AttributeAccessor)context).getAttribute(this.beanName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String convertToString(Object value, TypeConverter typeConverter) {
        PropertyEditorRegistrySupport registry;
        PropertyEditor editor;
        String result = null;
        try {
            result = (String)typeConverter.convertIfNecessary(value, String.class);
        }
        catch (TypeMismatchException e) {
            // empty catch block
        }
        if (result == null && typeConverter instanceof PropertyEditorRegistrySupport && (editor = (registry = (PropertyEditorRegistrySupport)typeConverter).findCustomEditor(value.getClass(), null)) != null) {
            if (registry.isSharedEditor(editor)) {
                PropertyEditor propertyEditor = editor;
                synchronized (propertyEditor) {
                    editor.setValue(value);
                    result = editor.getAsText();
                }
            } else {
                editor.setValue(value);
                result = editor.getAsText();
            }
        }
        return result;
    }

    private Object convertFromContext(String key, Class<?> requiredType, TypeConverter typeConverter) {
        Object result = null;
        Object property = this.getPropertyFromContext(key);
        if (property == null || requiredType.isAssignableFrom(property.getClass())) {
            result = property;
        }
        return result;
    }

    private Object getPropertyFromContext(String key) {
        BeanWrapperImpl wrapper = new BeanWrapperImpl(this.contextFactory.getContext());
        if (wrapper.isReadableProperty(key)) {
            return wrapper.getPropertyValue(key);
        }
        return null;
    }

    private String extractKey(String value) {
        if (value.startsWith(PLACEHOLDER_PREFIX)) {
            value = value.substring(PLACEHOLDER_PREFIX.length());
            value = value.substring(0, value.length() - PLACEHOLDER_SUFFIX.length());
        }
        return value;
    }

    private String replacePlaceholders(String value, TypeConverter typeConverter) {
        StringBuilder result = new StringBuilder(value);
        int first = result.indexOf(PLACEHOLDER_PREFIX);
        int next = result.indexOf(PLACEHOLDER_SUFFIX, first + 1);
        while (first >= 0) {
            Assert.state((next > 0 ? 1 : 0) != 0, (String)String.format("Placeholder key incorrectly specified: use %skey%s (in %s)", PLACEHOLDER_PREFIX, PLACEHOLDER_SUFFIX, value));
            String key = result.substring(first + PLACEHOLDER_PREFIX.length(), next);
            boolean replaced = this.replaceIfTypeMatches(result, first, next, key, String.class, typeConverter);
            replaced |= this.replaceIfTypeMatches(result, first, next, key, Long.class, typeConverter);
            replaced |= this.replaceIfTypeMatches(result, first, next, key, Integer.class, typeConverter);
            if (!(replaced |= this.replaceIfTypeMatches(result, first, next, key, Date.class, typeConverter))) {
                throw new IllegalStateException("Cannot bind to placeholder: " + key);
            }
            first = result.indexOf(PLACEHOLDER_PREFIX, first + 1);
            next = result.indexOf(PLACEHOLDER_SUFFIX, first + 1);
        }
        this.logger.debug((Object)String.format("Replaced [%s] with [%s]", value, result));
        return result.toString();
    }

    private boolean replaceIfTypeMatches(StringBuilder result, int first, int next, String key, Class<?> requiredType, TypeConverter typeConverter) {
        Object property = this.convertFromContext(key, requiredType, typeConverter);
        if (property != null) {
            result.replace(first, next + 1, (String)typeConverter.convertIfNecessary(property, String.class));
            return true;
        }
        return false;
    }
}

