/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.dao;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.apache.commons.lang.SerializationUtils;
import org.springframework.batch.core.Entity;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.repository.dao.StepExecutionDao;
import org.springframework.batch.support.transaction.TransactionAwareProxyFactory;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.util.Assert;

public class MapStepExecutionDao
implements StepExecutionDao {
    private static Map<Long, Map<Long, StepExecution>> executionsByJobExecutionId = TransactionAwareProxyFactory.createTransactionalMap();
    private static Map<Long, StepExecution> executionsByStepExecutionId = TransactionAwareProxyFactory.createTransactionalMap();
    private static long currentId = 0L;

    public static void clear() {
        executionsByJobExecutionId.clear();
        executionsByStepExecutionId.clear();
    }

    private static StepExecution copy(StepExecution original) {
        return (StepExecution)SerializationUtils.deserialize((byte[])SerializationUtils.serialize((Serializable)original));
    }

    public void saveStepExecution(StepExecution stepExecution) {
        Assert.isTrue((stepExecution.getId() == null ? 1 : 0) != 0);
        Assert.isTrue((stepExecution.getVersion() == null ? 1 : 0) != 0);
        Assert.notNull((Object)stepExecution.getJobExecutionId(), (String)"JobExecution must be saved already.");
        Map executions = executionsByJobExecutionId.get(stepExecution.getJobExecutionId());
        if (executions == null) {
            executions = TransactionAwareProxyFactory.createTransactionalMap();
            executionsByJobExecutionId.put(stepExecution.getJobExecutionId(), executions);
        }
        stepExecution.setId(currentId++);
        stepExecution.incrementVersion();
        StepExecution copy = MapStepExecutionDao.copy(stepExecution);
        executions.put(stepExecution.getId(), copy);
        executionsByStepExecutionId.put(stepExecution.getId(), copy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStepExecution(StepExecution stepExecution) {
        Assert.notNull((Object)stepExecution.getJobExecutionId());
        Map<Long, StepExecution> executions = executionsByJobExecutionId.get(stepExecution.getJobExecutionId());
        Assert.notNull(executions, (String)"step executions for given job execution are expected to be already saved");
        StepExecution persistedExecution = executionsByStepExecutionId.get(stepExecution.getId());
        Assert.notNull((Object)persistedExecution, (String)"step execution is expected to be already saved");
        StepExecution stepExecution2 = stepExecution;
        synchronized (stepExecution2) {
            if (!persistedExecution.getVersion().equals(stepExecution.getVersion())) {
                throw new OptimisticLockingFailureException("Attempt to update step execution id=" + stepExecution.getId() + " with wrong version (" + stepExecution.getVersion() + "), where current version is " + persistedExecution.getVersion());
            }
            stepExecution.incrementVersion();
            StepExecution copy = MapStepExecutionDao.copy(stepExecution);
            executions.put(stepExecution.getId(), copy);
            executionsByStepExecutionId.put(stepExecution.getId(), copy);
        }
    }

    public StepExecution getStepExecution(JobExecution jobExecution, Long stepExecutionId) {
        return executionsByStepExecutionId.get(stepExecutionId);
    }

    public void addStepExecutions(JobExecution jobExecution) {
        Map<Long, StepExecution> executions = executionsByJobExecutionId.get(jobExecution.getId());
        if (executions == null || executions.isEmpty()) {
            return;
        }
        ArrayList<StepExecution> result = new ArrayList<StepExecution>(executions.values());
        Collections.sort(result, new Comparator<Entity>(){

            @Override
            public int compare(Entity o1, Entity o2) {
                return Long.signum(o2.getId() - o1.getId());
            }
        });
        ArrayList<StepExecution> copy = new ArrayList<StepExecution>(result.size());
        for (StepExecution exec : result) {
            copy.add(MapStepExecutionDao.copy(exec));
        }
        jobExecution.addStepExecutions(copy);
    }
}

