/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import java.util.Map;
import org.springframework.batch.item.file.transform.RangeArrayPropertyEditor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class CoreNamespaceUtils {
    private static final String STEP_SCOPE_PROCESSOR_BEAN_NAME = "org.springframework.batch.core.scope.internalStepScope";
    private static final String STEP_SCOPE_PROCESSOR_CLASS_NAME = "org.springframework.batch.core.scope.StepScope";
    private static final String CUSTOM_EDITOR_CONFIGURER_CLASS_NAME = "org.springframework.beans.factory.config.CustomEditorConfigurer";
    private static final String RANGE_ARRAY_CLASS_NAME = "org.springframework.batch.item.file.transform.Range[]";

    protected static void checkForStepScope(ParserContext parserContext, Object source) {
        String[] beanNames;
        boolean foundStepScope = false;
        for (String beanName : beanNames = parserContext.getRegistry().getBeanDefinitionNames()) {
            BeanDefinition bd = parserContext.getRegistry().getBeanDefinition(beanName);
            if (!STEP_SCOPE_PROCESSOR_CLASS_NAME.equals(bd.getBeanClassName())) continue;
            foundStepScope = true;
            break;
        }
        if (!foundStepScope) {
            BeanDefinitionBuilder stepScopeBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)STEP_SCOPE_PROCESSOR_CLASS_NAME);
            AbstractBeanDefinition abd = stepScopeBuilder.getBeanDefinition();
            abd.setRole(2);
            abd.setSource(source);
            parserContext.getRegistry().registerBeanDefinition(STEP_SCOPE_PROCESSOR_BEAN_NAME, (BeanDefinition)abd);
        }
    }

    protected static void addRangePropertyEditor(ParserContext parserContext) {
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        if (!CoreNamespaceUtils.rangeArrayEditorAlreadyDefined(registry)) {
            BeanDefinitionBuilder stepScopeBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)CUSTOM_EDITOR_CONFIGURER_CLASS_NAME);
            AbstractBeanDefinition abd = stepScopeBuilder.getBeanDefinition();
            abd.setRole(2);
            ManagedMap editors = new ManagedMap();
            editors.put((Object)RANGE_ARRAY_CLASS_NAME, RangeArrayPropertyEditor.class);
            abd.getPropertyValues().addPropertyValue("customEditors", (Object)editors);
            registry.registerBeanDefinition(CUSTOM_EDITOR_CONFIGURER_CLASS_NAME, (BeanDefinition)abd);
        }
    }

    private static boolean rangeArrayEditorAlreadyDefined(BeanDefinitionRegistry registry) {
        for (String beanName : registry.getBeanDefinitionNames()) {
            BeanDefinition bd = registry.getBeanDefinition(beanName);
            if (!CUSTOM_EDITOR_CONFIGURER_CLASS_NAME.equals(bd.getBeanClassName())) continue;
            Map editors = (Map)bd.getPropertyValues().getPropertyValue("customEditors").getValue();
            for (Map.Entry entry : editors.entrySet()) {
                if (!(entry.getKey() instanceof TypedStringValue ? RANGE_ARRAY_CLASS_NAME.equals(((TypedStringValue)entry.getKey()).getValue()) : entry.getKey() instanceof String && RANGE_ARRAY_CLASS_NAME.equals((String)entry.getKey()))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isUnderspecified(Element element) {
        return Boolean.valueOf(element.getAttribute("abstract")) != false || StringUtils.hasText((String)element.getAttribute("parent"));
    }
}

