/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.support;

import org.springframework.batch.core.configuration.support.ApplicationContextFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class ClassPathXmlApplicationContextFactory
implements ApplicationContextFactory,
ApplicationContextAware {
    private ConfigurableApplicationContext parent;
    private Resource path;

    public void setPath(Resource path) {
        this.path = path;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Assert.isInstanceOf(ConfigurableApplicationContext.class, (Object)applicationContext);
        this.parent = (ConfigurableApplicationContext)applicationContext;
    }

    public ConfigurableApplicationContext createApplicationContext() {
        if (this.path == null) {
            return this.parent;
        }
        return new ResourceXmlApplicationContext((ApplicationContext)this.parent);
    }

    private final class ResourceXmlApplicationContext
    extends AbstractXmlApplicationContext {
        private ResourceXmlApplicationContext(ApplicationContext parent) {
            super(parent);
            this.refresh();
        }

        protected Resource[] getConfigResources() {
            return new Resource[]{ClassPathXmlApplicationContextFactory.this.path};
        }
    }
}

