/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.util;

import groovyx.gpars.scheduler.Pool;
import groovyx.gpars.util.DefaultMessageQueue;
import groovyx.gpars.util.MessageQueue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.codehaus.groovy.runtime.NullObject;

public abstract class AsyncMessagingCore
implements Runnable {
    private Pool threadPool;
    private volatile boolean fair = false;
    private final MessageQueue queue = new DefaultMessageQueue();
    private volatile int active = 0;
    private static final AtomicIntegerFieldUpdater<AsyncMessagingCore> activeUpdater = AtomicIntegerFieldUpdater.newUpdater(AsyncMessagingCore.class, "active");
    private static final int PASSIVE = 0;
    private static final int ACTIVE = 1;

    protected AsyncMessagingCore(Pool threadPool) {
        this.threadPool = threadPool;
    }

    public final void attachToThreadPool(Pool threadPool) {
        this.threadPool = threadPool;
    }

    Pool getThreadPool() {
        return this.threadPool;
    }

    public boolean isFair() {
        return this.fair;
    }

    public void makeFair() {
        this.fair = true;
    }

    public void store(Object message) {
        this.queue.add(message != null ? message : NullObject.getNullObject());
        if (activeUpdater.compareAndSet(this, 0, 1)) {
            this.threadPool.execute(this);
        }
    }

    void schedule() {
        if (!this.queue.isEmpty() && activeUpdater.compareAndSet(this, 0, 1)) {
            this.threadPool.execute(this);
        }
    }

    public Object sweepNextMessage() {
        return this.queue.poll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        try {
            this.threadAssigned();
            if (!this.continueProcessingMessages()) {
                return;
            }
            Object message = this.queue.poll();
            while (message != null) {
                this.handleMessage(message);
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                if (this.fair) break;
                if (!this.continueProcessingMessages()) {
                    break;
                }
                message = this.queue.poll();
            }
        }
        catch (InvokerInvocationException e) {
            this.registerError(e.getCause());
        }
        catch (Exception e) {
            this.registerError(e);
        }
        finally {
            this.threadUnassigned();
            activeUpdater.set(this, 0);
            if (this.continueProcessingMessages()) {
                this.schedule();
            }
        }
    }

    protected boolean continueProcessingMessages() {
        return true;
    }

    protected void threadUnassigned() {
    }

    protected void threadAssigned() {
    }

    protected abstract void registerError(Throwable var1);

    protected abstract void handleMessage(Object var1);
}

