/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.stm;

import groovy.lang.Closure;
import groovyx.gpars.stm.GParsAtomicBlock;
import groovyx.gpars.stm.GParsAtomicBooleanBlock;
import groovyx.gpars.stm.GParsAtomicDoubleBlock;
import groovyx.gpars.stm.GParsAtomicIntBlock;
import groovyx.gpars.stm.GParsAtomicLongBlock;
import groovyx.gpars.stm.GParsAtomicVoidBlock;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.multiverse.api.AtomicBlock;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.TransactionFactoryBuilder;
import org.multiverse.api.closures.AtomicBooleanClosure;
import org.multiverse.api.closures.AtomicDoubleClosure;
import org.multiverse.api.closures.AtomicIntClosure;
import org.multiverse.api.closures.AtomicLongClosure;
import org.multiverse.api.closures.AtomicVoidClosure;
import org.multiverse.api.exceptions.ControlFlowError;

public abstract class GParsStm {
    static final String THE_CODE_FOR_AN_ATOMIC_BLOCK_MUST_NOT_BE_NULL = "The code for an atomic block must not be null.";
    static final String AN_EXCEPTION_WAS_EXPECTED_TO_BE_THROWN_FROM_UNWRAP_STM_CONTROL_ERROR_FOR = "An exception was expected to be thrown from unwrapStmControlError for ";
    private static final String CANNOT_CREATE_AN_ATOMIC_BLOCK_SOME_OF_THE_SPECIFIED_PARAMETERS_ARE_NOT_SUPPORTED = "Cannot create an atomic block. Some of the specified parameters are not supported. ";
    public static final TransactionFactoryBuilder transactionFactory = GlobalStmInstance.getGlobalStmInstance().createTransactionFactoryBuilder();
    private static final AtomicBlock defaultAtomicBlock = transactionFactory.setFamilyName("GPars.Stm").buildAtomicBlock();

    public static AtomicBlock createAtomicBlock() {
        return GParsStm.createAtomicBlock(Collections.<String, Object>emptyMap());
    }

    public static AtomicBlock createAtomicBlock(Map<String, Object> params) {
        TransactionFactoryBuilder localFactory = transactionFactory;
        Set<Map.Entry<String, Object>> entries = params.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            if (entry.getValue() == null) {
                throw new IllegalArgumentException("Cannot create an atomic block. The value for " + entry.getKey() + " is null.");
            }
            if (entry.getKey() == null || "".equals(entry.getKey().trim())) {
                throw new IllegalArgumentException("Cannot create an atomic block. Found an empty key.");
            }
            String key = "set" + Character.toUpperCase(entry.getKey().charAt(0)) + entry.getKey().substring(1);
            try {
                Method method = entry.getValue().getClass().equals(Long.class) ? TransactionFactoryBuilder.class.getDeclaredMethod(key, Long.TYPE) : (entry.getValue().getClass().equals(Integer.class) ? TransactionFactoryBuilder.class.getDeclaredMethod(key, Integer.TYPE) : (entry.getValue().getClass().equals(Boolean.class) ? TransactionFactoryBuilder.class.getDeclaredMethod(key, Boolean.TYPE) : TransactionFactoryBuilder.class.getDeclaredMethod(key, entry.getValue().getClass())));
                localFactory = (TransactionFactoryBuilder)method.invoke((Object)localFactory, entry.getValue());
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException(CANNOT_CREATE_AN_ATOMIC_BLOCK_SOME_OF_THE_SPECIFIED_PARAMETERS_ARE_NOT_SUPPORTED + entry.getKey(), e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException(CANNOT_CREATE_AN_ATOMIC_BLOCK_SOME_OF_THE_SPECIFIED_PARAMETERS_ARE_NOT_SUPPORTED + entry.getKey(), e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(CANNOT_CREATE_AN_ATOMIC_BLOCK_SOME_OF_THE_SPECIFIED_PARAMETERS_ARE_NOT_SUPPORTED + entry.getKey(), e);
            }
        }
        return localFactory.buildAtomicBlock();
    }

    public static <T> T atomic(Closure code) {
        return (T)defaultAtomicBlock.execute(new GParsAtomicBlock(code));
    }

    public static <T> T atomic(AtomicBlock block, Closure code) {
        return (T)block.execute(new GParsAtomicBlock(code));
    }

    public static int atomicWithInt(Closure code) {
        return defaultAtomicBlock.execute((AtomicIntClosure)new GParsAtomicIntBlock(code));
    }

    public static int atomicWithInt(AtomicBlock block, Closure code) {
        return block.execute((AtomicIntClosure)new GParsAtomicIntBlock(code));
    }

    public static long atomicWithLong(Closure code) {
        return defaultAtomicBlock.execute((AtomicLongClosure)new GParsAtomicLongBlock(code));
    }

    public static long atomicWithLong(AtomicBlock block, Closure code) {
        return block.execute((AtomicLongClosure)new GParsAtomicLongBlock(code));
    }

    public static boolean atomicWithBoolean(Closure code) {
        return defaultAtomicBlock.execute((AtomicBooleanClosure)new GParsAtomicBooleanBlock(code));
    }

    public static boolean atomicWithBoolean(AtomicBlock block, Closure code) {
        return block.execute((AtomicBooleanClosure)new GParsAtomicBooleanBlock(code));
    }

    public static double atomicWithDouble(Closure code) {
        return defaultAtomicBlock.execute((AtomicDoubleClosure)new GParsAtomicDoubleBlock(code));
    }

    public static double atomicWithDouble(AtomicBlock block, Closure code) {
        return block.execute((AtomicDoubleClosure)new GParsAtomicDoubleBlock(code));
    }

    public static void atomicWithVoid(Closure code) {
        defaultAtomicBlock.execute((AtomicVoidClosure)new GParsAtomicVoidBlock(code));
    }

    public static void atomicWithVoid(AtomicBlock block, Closure code) {
        block.execute((AtomicVoidClosure)new GParsAtomicVoidBlock(code));
    }

    static void unwrapStmControlError(InvokerInvocationException e) {
        Throwable cause = e.getCause();
        if (cause instanceof ControlFlowError) {
            throw (Error)cause;
        }
        throw e;
    }
}

