/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow.operator.component;

import groovyx.gpars.dataflow.DataflowVariable;
import groovyx.gpars.dataflow.Promise;
import groovyx.gpars.dataflow.operator.component.GracefulShutdownListener;
import groovyx.gpars.dataflow.operator.component.OperatorStateMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;

public final class GracefulShutdownMonitor
implements OperatorStateMonitor {
    private static final long DEFAULT_DELAY = 500L;
    private final long delay;
    private boolean shutdownFlag = false;
    private final AtomicBoolean notificationArrivedFlag = new AtomicBoolean(false);
    private final DataflowVariable<Boolean> result = new DataflowVariable();
    private final Collection<GracefulShutdownListener> listeners = new ArrayList<GracefulShutdownListener>();
    private final Timer timer = new Timer(true);

    public GracefulShutdownMonitor() {
        this(500L);
    }

    public GracefulShutdownMonitor(long delay) {
        this.delay = delay;
    }

    @Override
    public void stateChanged() {
        this.notificationArrivedFlag.set(true);
    }

    @Override
    public synchronized void registerProcessorListener(GracefulShutdownListener listener) {
        if (this.shutdownFlag) {
            throw new IllegalStateException("Cannot register processors while performing graceful shutdown.");
        }
        this.listeners.add(listener);
    }

    public synchronized Promise<Boolean> shutdownNetwork() {
        if (!this.shutdownFlag) {
            this.shutdownFlag = true;
            for (GracefulShutdownListener listener : this.listeners) {
                listener.initiateShutdown();
            }
            this.schedule();
        }
        return this.result;
    }

    void onTimer() {
        if (this.checkWhetherAnyEventsHaveArrived()) {
            return;
        }
        for (GracefulShutdownListener listener : this.listeners) {
            if (listener.isIdle()) continue;
            this.schedule();
            return;
        }
        for (GracefulShutdownListener listener : this.listeners) {
            if (listener.isIdleAndNoIncomingMessages()) continue;
            this.schedule();
            return;
        }
        if (this.checkWhetherAnyEventsHaveArrived()) {
            return;
        }
        this.result.bind(true);
        for (GracefulShutdownListener listener : this.listeners) {
            listener.terminateProcessor();
        }
    }

    private boolean checkWhetherAnyEventsHaveArrived() {
        if (this.notificationArrivedFlag.get()) {
            this.schedule();
            return true;
        }
        return false;
    }

    private void schedule() {
        this.notificationArrivedFlag.set(false);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                GracefulShutdownMonitor.this.onTimer();
            }
        }, this.delay);
    }
}

