/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow.operator;

import groovy.lang.Closure;
import groovyx.gpars.dataflow.DataflowReadChannel;
import groovyx.gpars.dataflow.DataflowWriteChannel;
import groovyx.gpars.dataflow.Select;
import groovyx.gpars.dataflow.operator.DataflowEventListener;
import groovyx.gpars.dataflow.operator.DataflowProcessor;
import groovyx.gpars.dataflow.operator.DataflowSelectorActor;
import groovyx.gpars.dataflow.operator.ForkingDataflowSelectorActor;
import groovyx.gpars.group.PGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DataflowSelector
extends DataflowProcessor {
    protected final Select select;
    protected final List<Boolean> guards;

    public DataflowSelector(PGroup group, Map channels, Closure code) {
        super(channels, code);
        int parameters = code.getMaximumNumberOfParameters();
        if (DataflowSelector.verifyChannelParameters(channels, parameters)) {
            throw new IllegalArgumentException("The selector's body must accept one or two parameters, while it currently requests " + parameters + " unique parameters.");
        }
        List inputs = DataflowSelector.extractInputs(channels);
        List<DataflowWriteChannel> outputs = DataflowSelector.extractOutputs(channels);
        if (DataflowSelector.shouldBeMultiThreaded(channels)) {
            DataflowSelector.checkMaxForks(channels);
            this.actor = new ForkingDataflowSelectorActor(this, group, outputs, inputs, (Closure)code.clone(), (Integer)channels.get("maxForks"));
        } else {
            this.actor = new DataflowSelectorActor(this, group, outputs, inputs, (Closure)code.clone());
        }
        this.select = new Select(group, inputs);
        this.guards = Collections.synchronizedList(new ArrayList(inputs.size()));
        List gs = (List)channels.get("guards");
        if (gs != null) {
            for (int i = 0; i < inputs.size(); ++i) {
                this.guards.add(i, (Boolean)gs.get(i));
            }
        } else {
            for (DataflowReadChannel dataflowReadChannel : inputs) {
                this.guards.add(Boolean.TRUE);
            }
        }
        for (DataflowEventListener dataflowEventListener : this.listeners) {
            dataflowEventListener.registered(this);
        }
    }

    private static boolean verifyChannelParameters(Map channels, int parameters) {
        if (channels == null) {
            return true;
        }
        Collection inputs = (Collection)channels.get("inputs");
        return inputs == null || inputs.isEmpty() || parameters < 1 || parameters > 2;
    }

    private static String countInputChannels(Map channels) {
        if (channels == null) {
            return "Null";
        }
        Collection inputs = (Collection)channels.get("inputs");
        return String.valueOf(inputs.size());
    }

    public final void setGuard(int index, boolean flag) {
        this.guards.set(index, flag);
    }

    public final void setGuards(List<Boolean> flags) {
        for (int i = 0; i < flags.size(); ++i) {
            this.guards.set(i, flags.get(i));
        }
    }

    protected void doSelect() {
        try {
            this.select.select(this.actor, this.guards);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Cannot select a value.", e);
        }
    }

    final boolean allGuardsClosed() {
        for (Boolean guard : this.guards) {
            if (guard != Boolean.TRUE) continue;
            return false;
        }
        return true;
    }
}

