/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow.operator;

import groovy.lang.Closure;
import groovyx.gpars.dataflow.DataflowChannelListener;
import groovyx.gpars.dataflow.DataflowReadChannel;
import groovyx.gpars.dataflow.DataflowWriteChannel;
import groovyx.gpars.dataflow.operator.DataflowEventListener;
import groovyx.gpars.dataflow.operator.DataflowProcessorActor;
import groovyx.gpars.dataflow.operator.StopGently;
import groovyx.gpars.group.PGroup;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class DataflowProcessor {
    public static final String INPUTS = "inputs";
    public static final String OUTPUTS = "outputs";
    public static final String MAX_FORKS = "maxForks";
    public static final String STATE_OBJECT = "stateObject";
    private static final String LISTENERS = "listeners";
    protected DataflowProcessorActor actor;
    protected final Object stateObject;
    final Collection<DataflowEventListener> listeners = new CopyOnWriteArrayList<DataflowEventListener>();

    protected DataflowProcessor(Map<String, Object> channels, Closure code) {
        code.setDelegate((Object)this);
        this.stateObject = DataflowProcessor.extractState(channels);
        this.listeners.addAll(DataflowProcessor.extractListeners(channels));
        if (channels == null) {
            return;
        }
        Collection inputs = (Collection)channels.get(INPUTS);
        if (inputs == null || inputs.isEmpty()) {
            throw new IllegalArgumentException("The processor body must take some inputs. The provided list of input channels is empty.");
        }
    }

    static boolean shouldBeMultiThreaded(Map<String, Object> channels) {
        Integer maxForks = (Integer)channels.get(MAX_FORKS);
        return maxForks != null && maxForks != 1;
    }

    static List<DataflowReadChannel> extractInputs(Map<String, Object> channels) {
        List inputs = (List)channels.get(INPUTS);
        return Collections.unmodifiableList(inputs);
    }

    static List<DataflowWriteChannel> extractOutputs(Map<String, Object> channels) {
        List outputs = (List)channels.get(OUTPUTS);
        if (outputs != null) {
            return Collections.unmodifiableList(outputs);
        }
        return null;
    }

    private static Object extractState(Map<String, Object> channels) {
        if (channels == null) {
            return null;
        }
        return channels.get(STATE_OBJECT);
    }

    private static Collection<DataflowEventListener> extractListeners(Map<String, Object> channels) {
        if (channels == null) {
            return null;
        }
        List<DataflowEventListener> listeners = (List<DataflowEventListener>)channels.get(LISTENERS);
        return listeners != null ? listeners : Collections.emptyList();
    }

    protected static void checkMaxForks(Map channels) {
        if ((Integer)channels.get(MAX_FORKS) < 1) {
            throw new IllegalArgumentException("The maxForks argument must be a positive value. " + channels.get(MAX_FORKS) + " was provided.");
        }
    }

    public final DataflowProcessor start(PGroup group) {
        this.actor.setParallelGroup(group);
        this.actor.start();
        return this;
    }

    public final DataflowProcessor start() {
        this.actor.start();
        return this;
    }

    public final void terminate() {
        this.actor.terminate();
    }

    public final void terminateAfterNextRun() {
        this.actor.send(StopGently.getInstance());
    }

    public final void join() throws InterruptedException {
        this.actor.join();
    }

    public final void bindOutput(int idx, Object value) {
        DataflowWriteChannel channel = (DataflowWriteChannel)this.actor.outputs.get(idx);
        channel.bind(this.fireMessageSentOut(channel, idx, value));
    }

    public final void bindOutput(Object value) {
        this.bindOutput(0, value);
    }

    public final void bindAllOutputs(Object value) {
        List<DataflowWriteChannel> outputs = this.getOutputs();
        for (int i = 0; i < outputs.size(); ++i) {
            DataflowWriteChannel channel = outputs.get(i);
            channel.bind(this.fireMessageSentOut(channel, i, value));
        }
    }

    public final void bindAllOutputValues(Object ... values) {
        List<DataflowWriteChannel> outputs = this.getOutputs();
        for (int i = 0; i < outputs.size(); ++i) {
            DataflowWriteChannel channel = outputs.get(i);
            channel.bind(this.fireMessageSentOut(channel, i, values[i]));
        }
    }

    public final synchronized void bindAllOutputsAtomically(Object value) {
        this.bindAllOutputs(value);
    }

    public final synchronized void bindAllOutputValuesAtomically(Object ... values) {
        this.bindAllOutputValues(values);
    }

    public final DataflowWriteChannel getOutputs(int idx) {
        if (this.actor.outputs.isEmpty()) {
            return null;
        }
        return (DataflowWriteChannel)this.actor.outputs.get(idx);
    }

    public final List<DataflowWriteChannel> getOutputs() {
        return this.actor.outputs;
    }

    public final DataflowWriteChannel getOutput() {
        if (this.actor.outputs.isEmpty()) {
            return null;
        }
        return (DataflowWriteChannel)this.actor.outputs.get(0);
    }

    public final Object getStateObject() {
        return this.stateObject;
    }

    final synchronized void reportError(Throwable e) {
        if (this.listeners.isEmpty()) {
            System.err.println("The dataflow processor experienced an unhandled exception and is about to terminate. " + e);
            this.terminate();
        }
        if (this.fireOnException(e)) {
            this.terminate();
        }
    }

    public final void addDataflowEventListener(DataflowEventListener listener) {
        this.listeners.add(listener);
        listener.registered(this);
    }

    public final void removeDataflowEventListener(DataflowEventListener listener) {
        this.listeners.remove(listener);
    }

    public final void registerChannelListenersToAllInputs(DataflowChannelListener<Object> handler) {
        this.actor.registerChannelListenersToAllInputs(handler);
    }

    protected final void fireAfterStart() {
        for (DataflowEventListener listener : this.listeners) {
            listener.afterStart(this);
        }
    }

    protected final void fireAfterStop() {
        for (DataflowEventListener listener : this.listeners) {
            listener.afterStop(this);
        }
    }

    protected final boolean fireOnException(Throwable e) {
        boolean terminate = false;
        for (DataflowEventListener listener : this.listeners) {
            terminate = terminate || listener.onException(this, e);
        }
        return terminate;
    }

    public final Object fireCustomEvent(Object data) {
        Object result = data;
        for (DataflowEventListener listener : this.listeners) {
            result = listener.customEvent(this, result);
        }
        return result;
    }

    protected final Object fireMessageArrived(DataflowReadChannel channel, int index, Object message) {
        Object result = message;
        for (DataflowEventListener listener : this.listeners) {
            result = listener.messageArrived(this, channel, index, result);
        }
        return result;
    }

    protected final Object fireControlMessageArrived(DataflowReadChannel channel, int index, Object message) {
        Object result = message;
        for (DataflowEventListener listener : this.listeners) {
            result = listener.controlMessageArrived(this, channel, index, result);
        }
        return result;
    }

    protected final Object fireMessageSentOut(DataflowWriteChannel channel, int index, Object message) {
        Object result = message;
        for (DataflowEventListener listener : this.listeners) {
            result = listener.messageSentOut(this, channel, index, result);
        }
        return result;
    }

    protected final List<Object> fireBeforeRun(List<Object> messages) {
        List<Object> result = messages;
        for (DataflowEventListener listener : this.listeners) {
            result = listener.beforeRun(this, result);
        }
        return result;
    }

    protected final void fireAfterRun(List<Object> messages) {
        for (DataflowEventListener listener : this.listeners) {
            listener.afterRun(this, messages);
        }
    }
}

