/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow.impl;

import groovyx.gpars.dataflow.Dataflow;
import groovyx.gpars.dataflow.DataflowReadChannel;
import groovyx.gpars.dataflow.DataflowVariable;
import groovyx.gpars.dataflow.expression.DataflowExpression;
import groovyx.gpars.dataflow.impl.SelectCallback;
import groovyx.gpars.dataflow.impl.SelectRequest;
import groovyx.gpars.group.PGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public final class SelectBase<T> {
    private final List<DataflowReadChannel<? extends T>> channels;
    private final int numberOfChannels;
    private final boolean[] disabledDFVs;
    private final Collection<SelectRequest<T>> pendingRequests = new ArrayList<SelectRequest<T>>();
    private final Random position = new Random();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SelectBase(PGroup pGroup, List<DataflowReadChannel<? extends T>> channels) {
        this.channels = Collections.unmodifiableList(channels);
        this.numberOfChannels = channels.size();
        this.disabledDFVs = new boolean[this.numberOfChannels];
        Arrays.fill(this.disabledDFVs, false);
        for (int i = 0; i < this.numberOfChannels; ++i) {
            DataflowReadChannel<T> channel = channels.get(i);
            PGroup originalGroup = Dataflow.retrieveCurrentDFPGroup();
            try {
                Dataflow.activeParallelGroup.set(pGroup);
                channel.wheneverBound(new SelectCallback<T>(this, i, channel));
                continue;
            }
            finally {
                Dataflow.activeParallelGroup.set(originalGroup);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void boundNotification(int index, DataflowReadChannel<? extends T> channel) throws InterruptedException {
        List<DataflowReadChannel<? extends T>> list = this.channels;
        synchronized (list) {
            for (SelectRequest<T> selectRequest : this.pendingRequests) {
                DataflowExpression<T> value;
                if (!selectRequest.matchesMask(index) || this.disabledDFVs[index] || (value = channel.poll()) == null) continue;
                this.pendingRequests.remove(selectRequest);
                this.disableDFV(index, channel);
                selectRequest.valueFound(index, value.getVal());
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSelect(int startIndex, SelectRequest<T> selectRequest) throws InterruptedException {
        int startPosition = startIndex == -1 ? this.position.nextInt(this.numberOfChannels) : startIndex;
        List<DataflowReadChannel<? extends T>> list = this.channels;
        synchronized (list) {
            for (int i = 0; i < this.numberOfChannels; ++i) {
                DataflowReadChannel<T> channel;
                DataflowExpression<T> value;
                int currentPosition = (startPosition + i) % this.numberOfChannels;
                if (!selectRequest.matchesMask(currentPosition) || this.disabledDFVs[currentPosition] || (value = (channel = this.channels.get(currentPosition)).poll()) == null) continue;
                this.disableDFV(currentPosition, channel);
                selectRequest.valueFound(currentPosition, value.getVal());
                return;
            }
            this.pendingRequests.add(selectRequest);
        }
    }

    private void disableDFV(int currentPosition, DataflowReadChannel<? extends T> channel) {
        if (channel instanceof DataflowVariable) {
            this.disabledDFVs[currentPosition] = true;
        }
    }
}

