/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow;

import groovyx.gpars.actor.impl.MessageStream;
import groovyx.gpars.dataflow.DataflowReadChannel;
import groovyx.gpars.dataflow.SelectResult;
import groovyx.gpars.dataflow.impl.GuardedSelectRequest;
import groovyx.gpars.dataflow.impl.SelectBase;
import groovyx.gpars.group.PGroup;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;

public class Select<T> {
    private final SelectBase<T> selectBase;

    public Select(PGroup pGroup, DataflowReadChannel<? extends T> ... channels) {
        this.selectBase = new SelectBase<T>(pGroup, Arrays.asList(channels));
    }

    public Select(PGroup pGroup, List<DataflowReadChannel<? extends T>> channels) {
        this.selectBase = new SelectBase<T>(pGroup, channels);
    }

    public SelectResult<T> select() throws InterruptedException {
        return this.select(-1, null);
    }

    public SelectResult<T> select(List<Boolean> mask) throws InterruptedException {
        return this.select(-1, mask);
    }

    public void select(MessageStream messageStream) throws InterruptedException {
        this.select(messageStream, -1, null);
    }

    public void select(MessageStream messageStream, List<Boolean> mask) throws InterruptedException {
        this.select(messageStream, -1, mask);
    }

    public SelectResult<T> prioritySelect() throws InterruptedException {
        return this.select(0, null);
    }

    public SelectResult<T> prioritySelect(List<Boolean> mask) throws InterruptedException {
        return this.select(0, mask);
    }

    public void prioritySelect(MessageStream messageStream) throws InterruptedException {
        this.select(messageStream, 0, null);
    }

    public void prioritySelect(MessageStream messageStream, List<Boolean> mask) throws InterruptedException {
        this.select(messageStream, 0, mask);
    }

    public final SelectResult<T> call() throws InterruptedException {
        return this.select();
    }

    public final SelectResult<T> call(List<Boolean> mask) throws InterruptedException {
        return this.select(mask);
    }

    public final void call(MessageStream messageStream) throws InterruptedException {
        this.select(messageStream);
    }

    public final void call(MessageStream messageStream, List<Boolean> mask) throws InterruptedException {
        this.select(messageStream, mask);
    }

    private void select(final MessageStream messageStream, int startIndex, List<Boolean> mask) throws InterruptedException {
        this.selectBase.doSelect(startIndex, new GuardedSelectRequest<T>(mask){

            @Override
            public void valueFound(int index, T value) {
                messageStream.send(new SelectResult(index, value));
            }
        });
    }

    private SelectResult<T> select(int startIndex, List<Boolean> mask) throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        final int[] foundIndex = new int[1];
        final Object[] foundValue = new Object[1];
        this.selectBase.doSelect(startIndex, new GuardedSelectRequest<T>(mask){

            @Override
            public void valueFound(int index, T value) {
                foundIndex[0] = index;
                foundValue[0] = value;
                latch.countDown();
            }
        });
        latch.await();
        return new SelectResult<Object>(foundIndex[0], foundValue[0]);
    }
}

