/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow;

import groovy.lang.Closure;
import groovyx.gpars.actor.impl.MessageStream;
import groovyx.gpars.dataflow.DataflowChannel;
import groovyx.gpars.dataflow.DataflowReadChannel;
import groovyx.gpars.dataflow.DataflowWriteChannel;
import groovyx.gpars.dataflow.Promise;
import groovyx.gpars.dataflow.expression.DataflowExpression;
import groovyx.gpars.dataflow.impl.ThenMessagingRunnable;
import groovyx.gpars.group.PGroup;
import groovyx.gpars.remote.RemoteHost;
import groovyx.gpars.scheduler.Pool;
import groovyx.gpars.serial.RemoteSerialized;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class DataflowVariable<T>
extends DataflowExpression<T>
implements DataflowChannel<T>,
Promise<T> {
    private static final long serialVersionUID = 1340439210749936258L;

    @Override
    public DataflowWriteChannel<T> leftShift(T value) {
        if (value instanceof DataflowReadChannel) {
            this.bindDFV((DataflowReadChannel)value);
        } else {
            this.bind(value);
        }
        return this;
    }

    @Override
    public DataflowWriteChannel<T> leftShift(DataflowReadChannel<T> ref) {
        return this.bindDFV(ref);
    }

    private DataflowWriteChannel<T> bindDFV(DataflowReadChannel<T> ref) {
        ref.getValAsync(new MessageStream(){
            private static final long serialVersionUID = -458384302762038543L;

            @Override
            public MessageStream send(Object message) {
                DataflowVariable.this.bind(message);
                return this;
            }
        });
        return this;
    }

    @Override
    public T get() throws Throwable {
        Object result = this.getVal();
        if (this.error != null) {
            throw this.error;
        }
        return result;
    }

    @Override
    public final T get(long timeout, TimeUnit units) throws Throwable {
        Object result = this.getVal(timeout, units);
        if (result instanceof Throwable) {
            throw (Throwable)result;
        }
        if (result == null) {
            if (this.shouldThrowTimeout()) {
                throw new TimeoutException("Timeout expired in DataflowVariable.get().");
            }
            return this.get();
        }
        return result;
    }

    boolean shouldThrowTimeout() {
        return !this.isBound();
    }

    @Override
    public final boolean isError() {
        return this.isBound() && this.error != null;
    }

    @Override
    public final Throwable getError() {
        if (this.isError()) {
            return this.error;
        }
        throw new IllegalStateException("No error has been bound to the dataflow variable.");
    }

    @Override
    public final <V> Promise<V> then(Closure<V> closure, Closure<V> errorHandler) {
        DataflowVariable<T> result = new DataflowVariable<T>();
        this.whenBound(new ThenMessagingRunnable(result, closure, errorHandler));
        return result;
    }

    @Override
    public final <V> Promise<V> then(Pool pool, Closure<V> closure, Closure<V> errorHandler) {
        DataflowVariable<T> result = new DataflowVariable<T>();
        this.whenBound(pool, new ThenMessagingRunnable(result, closure, errorHandler));
        return result;
    }

    @Override
    public final <V> Promise<V> then(PGroup group, Closure<V> closure, Closure<V> errorHandler) {
        DataflowVariable<T> result = new DataflowVariable<T>();
        this.whenBound(group, new ThenMessagingRunnable(result, closure, errorHandler));
        return result;
    }

    public Class<RemoteDataflowVariable> getRemoteClass() {
        return RemoteDataflowVariable.class;
    }

    public static final class RemoteDataflowVariable<T>
    extends DataflowVariable<T>
    implements RemoteSerialized {
        private static final long serialVersionUID = -420013188758006693L;
        private final RemoteHost remoteHost;
        private boolean disconnected;

        public RemoteDataflowVariable(RemoteHost host) {
            this.remoteHost = host;
            this.getValAsync(new MessageStream(){
                private static final long serialVersionUID = 7968302123667353660L;

                @Override
                public MessageStream send(Object message) {
                    if (!RemoteDataflowVariable.this.disconnected) {
                        RemoteDataflowVariable.this.remoteHost.write(new DataflowExpression.BindDataflow<Object>(RemoteDataflowVariable.this, message, RemoteDataflowVariable.this.remoteHost.getHostId()));
                    }
                    return this;
                }
            });
        }
    }
}

