/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.actor;

import groovy.lang.Closure;
import groovy.time.Duration;
import groovyx.gpars.actor.AbstractLoopingActor;
import groovyx.gpars.actor.Actor;
import groovyx.gpars.actor.DefaultActorClosure;
import groovyx.gpars.actor.ForwardingDelegate;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class DefaultActor
extends AbstractLoopingActor {
    private Closure nextContinuation;
    private Closure loopClosure;
    private Runnable loopCode;
    private Callable<Boolean> loopCondition;
    private Closure afterLoopCode;
    private boolean started = false;
    private static final long serialVersionUID = -439517926332934061L;
    private static final String EXPECTED = " expected.";

    public DefaultActor() {
        this((Runnable)null);
    }

    public DefaultActor(Runnable code) {
        if (code != null) {
            if (code instanceof Closure) {
                DefaultActor.checkForBodyArguments((Closure)code);
            }
            this.loopCode = code;
        }
        this.initialize(new DefaultActorClosure(this));
    }

    protected void act() {
        throw new UnsupportedOperationException("The act method has not been overridden");
    }

    final void onMessage(Object message) {
        if (this.nextContinuation == null) {
            throw new IllegalStateException("The actor " + this + " cannot handle the message " + message + ", as it has no registered message handler at the moment.");
        }
        Closure closure = this.nextContinuation;
        this.nextContinuation = null;
        closure.call(message);
        if (this.nextContinuation == null && !this.terminatingFlag) {
            if (this.loopCondition == null || this.evalLoopCondition()) {
                if (this.loopCode == null) {
                    if (this.loopClosure == null) {
                        this.terminate();
                    } else {
                        this.loopClosure.call();
                    }
                } else {
                    this.loopCode.run();
                }
            } else {
                if (this.afterLoopCode != null) {
                    this.runAfterLoopCode(this.afterLoopCode);
                }
                if (this.nextContinuation == null) {
                    this.terminate();
                }
            }
        }
    }

    public final void loop(Runnable code) {
        this.doLoop(null, null, code);
    }

    protected final void loop(int numberOfLoops, Runnable code) {
        this.loop(numberOfLoops, null, code);
    }

    protected final void loop(final int numberOfLoops, Closure afterLoopCode, Runnable code) {
        this.doLoop(new Callable<Boolean>(){
            private int counter = 0;

            @Override
            public Boolean call() {
                ++this.counter;
                return this.counter <= numberOfLoops;
            }
        }, afterLoopCode, code);
    }

    protected final void loop(Closure condition, Runnable code) {
        this.loop(condition, null, code);
    }

    protected final void loop(final Closure condition, Closure afterLoopCode, Runnable code) {
        this.doLoop(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return (Boolean)condition.call();
            }
        }, afterLoopCode, code);
    }

    private void doLoop(Callable<Boolean> condition, Closure afterLoopCode, Runnable code) {
        DefaultActor.checkForNull(code);
        if (afterLoopCode != null) {
            this.afterLoopCode = this.enhanceClosure(afterLoopCode);
        }
        this.loopCondition = condition;
        if (code instanceof Closure) {
            Closure enhancedClosure;
            Closure closure = (Closure)code;
            DefaultActor.checkForBodyArguments(closure);
            this.loopClosure = enhancedClosure = this.enhanceClosure(closure);
            assert (this.nextContinuation == null);
            while (!this.terminatingFlag && this.nextContinuation == null && (this.loopCondition == null || this.evalLoopCondition())) {
                enhancedClosure.call();
            }
            if (!this.terminatingFlag && this.nextContinuation == null && afterLoopCode != null) {
                this.runAfterLoopCode(afterLoopCode);
            }
        } else {
            this.loopCode = code;
            assert (this.nextContinuation == null);
            while (!this.terminatingFlag && this.nextContinuation == null && (this.loopCondition == null || this.evalLoopCondition())) {
                this.loopCode.run();
            }
            if (!this.terminatingFlag && this.nextContinuation == null && afterLoopCode != null) {
                this.runAfterLoopCode(afterLoopCode);
            }
        }
    }

    private void runAfterLoopCode(Closure afterLoopCode) {
        this.loopCondition = null;
        this.loopCode = null;
        this.loopClosure = null;
        this.afterLoopCode = null;
        afterLoopCode.call();
    }

    private boolean evalLoopCondition() {
        try {
            return this.loopCondition.call();
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public final void react(Closure code) {
        this.react(-1L, code);
    }

    protected final void react(Duration duration, Closure code) {
        this.react(duration.toMilliseconds(), code);
    }

    protected final void react(long timeout, TimeUnit timeUnit, Closure code) {
        this.react(timeUnit.toMillis(timeout), code);
    }

    protected final void react(long timeout, Closure code) {
        if (!this.isActorThread()) {
            throw new IllegalStateException("Cannot call react from a thread which is not owned by the actor");
        }
        DefaultActor.checkForNull((Runnable)code);
        DefaultActor.checkForMessageHandlerArguments(code);
        this.nextContinuation = this.enhanceClosure(code);
        if (timeout >= 0L) {
            this.setTimeout(timeout);
        }
    }

    @Override
    public Actor silentStart() {
        throw new UnsupportedOperationException("Old actors cannot start silently. Use DefaultActor instead.");
    }

    @Override
    public Actor start() {
        if (this.started) {
            throw new IllegalStateException("The DefaultActor cannot be restarted.");
        }
        this.started = true;
        return super.start();
    }

    @Override
    protected void handleStart() {
        super.handleStart();
        try {
            Runnable startCode = this.loopCode;
            this.loopCode = null;
            if (startCode != null) {
                if (startCode instanceof Closure) {
                    Closure closure = this.enhanceClosure((Closure)startCode);
                    closure.call();
                } else {
                    startCode.run();
                }
            } else {
                this.act();
            }
            if (this.nextContinuation == null) {
                this.terminate();
            }
        }
        catch (IllegalStateException e) {
            this.terminate();
            throw e;
        }
    }

    private Closure enhanceClosure(Closure closure) {
        Closure cloned = (Closure)closure.clone();
        if (cloned.getOwner() == cloned.getDelegate()) {
            cloned.setResolveStrategy(1);
            cloned.setDelegate((Object)this);
        } else {
            cloned.setDelegate((Object)new ForwardingDelegate(cloned.getDelegate(), this));
        }
        return cloned;
    }

    private static void checkForNull(Runnable code) {
        if (code == null) {
            throw new IllegalArgumentException("An actor's message handlers and loops cannot be set to a null value.");
        }
    }

    private static void checkForBodyArguments(Closure closure) {
        if (closure.getMaximumNumberOfParameters() > 1) {
            throw new IllegalArgumentException("An actor's body as well as a body of a loop can only expect 0 arguments. " + closure.getMaximumNumberOfParameters() + EXPECTED);
        }
    }

    private static void checkForMessageHandlerArguments(Closure code) {
        if (code.getMaximumNumberOfParameters() > 1) {
            throw new IllegalArgumentException("An actor's message handler can only expect 0 or 1 argument. " + code.getMaximumNumberOfParameters() + EXPECTED);
        }
    }
}

