/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars;

import groovyx.gpars.scheduler.Pool;
import groovyx.gpars.scheduler.ResizeablePool;
import groovyx.gpars.util.GeneralTimer;
import groovyx.gpars.util.PoolFactory;
import groovyx.gpars.util.TimerFactory;
import java.util.Timer;
import java.util.TimerTask;

public final class GParsConfig {
    private static volatile PoolFactory poolFactory;
    private static volatile TimerFactory timerFactory;
    private static volatile boolean poolFactoryFlag;
    private static volatile boolean timerFactoryFlag;

    public static synchronized void setPoolFactory(PoolFactory pool) {
        if (poolFactoryFlag) {
            throw new IllegalArgumentException("The pool factory cannot be altered at this stage. It has already been set before.");
        }
        poolFactoryFlag = true;
        poolFactory = pool;
    }

    public static PoolFactory getPoolFactory() {
        return poolFactory;
    }

    public static Pool retrieveDefaultPool() {
        if (poolFactory != null) {
            return poolFactory.createPool();
        }
        return new ResizeablePool(true, 1);
    }

    public static synchronized void setTimerFactory(TimerFactory timerFactory) {
        if (timerFactoryFlag) {
            throw new IllegalArgumentException("The timer factory cannot be altered at this stage. It has already been set before.");
        }
        timerFactoryFlag = true;
        GParsConfig.timerFactory = timerFactory;
    }

    public static TimerFactory getTimerFactory() {
        return timerFactory;
    }

    public static GeneralTimer retrieveDefaultTimer(final String name, final boolean daemon) {
        if (timerFactory != null) {
            return timerFactory.createTimer(name, daemon);
        }
        return new GeneralTimer(){
            private final Timer timer;
            {
                this.timer = new Timer(name, daemon);
            }

            @Override
            public void schedule(TimerTask task, long timeout) {
                this.timer.schedule(task, timeout);
            }
        };
    }

    static {
        poolFactoryFlag = false;
        timerFactoryFlag = false;
    }
}

