/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.ResourceAdapter;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.xa.XAResourceManager;
import org.apache.derby.iapi.store.access.xa.XAXactId;
import org.apache.derby.jdbc.XATransactionState;

public class ResourceAdapterImpl
implements ResourceAdapter,
ModuleControl {
    private boolean active;
    private XAResourceManager rm;
    private Hashtable connectionTable;

    public void boot(boolean create, Properties properties) throws StandardException {
        this.connectionTable = new Hashtable();
        AccessFactory af = (AccessFactory)Monitor.findServiceModule(this, "org.apache.derby.iapi.store.access.AccessFactory");
        this.rm = (XAResourceManager)af.getXAResourceManager();
        this.active = true;
    }

    public void stop() {
        this.active = false;
        Enumeration e = this.connectionTable.elements();
        while (e.hasMoreElements()) {
            XATransactionState tranState = (XATransactionState)e.nextElement();
            try {
                tranState.conn.close();
            }
            catch (SQLException sQLException) {}
        }
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    public synchronized Object findConnection(XAXactId xid) {
        return this.connectionTable.get(xid);
    }

    public synchronized boolean addConnection(XAXactId xid, Object conn) {
        if (this.connectionTable.get(xid) != null) {
            return false;
        }
        this.connectionTable.put(xid, conn);
        return true;
    }

    public synchronized Object removeConnection(XAXactId xid) {
        return this.connectionTable.remove(xid);
    }

    public XAResourceManager getXAResourceManager() {
        return this.rm;
    }
}

