/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.apache.derby.iapi.db.Database;
import org.apache.derby.iapi.jdbc.ResourceAdapter;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.jdbc.Driver30;
import org.apache.derby.jdbc.EmbeddedDataSource;

public class EmbeddedXADataSource
extends EmbeddedDataSource
implements XADataSource {
    private static final long serialVersionUID = -5715798975598379738L;
    private transient ResourceAdapter ra;

    public final XAConnection getXAConnection() throws SQLException {
        if (this.ra == null || !this.ra.isActive()) {
            this.setupResourceAdapter(null, null, false);
        }
        return this.createXAConnection(this.ra, this.getUser(), this.getPassword(), false);
    }

    public final XAConnection getXAConnection(String user, String password) throws SQLException {
        if (this.ra == null || !this.ra.isActive()) {
            this.setupResourceAdapter(user, password, true);
        }
        return this.createXAConnection(this.ra, user, password, true);
    }

    void update() {
        this.ra = null;
        super.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupResourceAdapter(String user, String password, boolean requestPassword) throws SQLException {
        EmbeddedXADataSource embeddedXADataSource = this;
        synchronized (embeddedXADataSource) {
            if (this.ra == null || !this.ra.isActive()) {
                this.ra = null;
                String dbName = this.getDatabaseName();
                if (dbName != null) {
                    Database database = null;
                    if (Monitor.getMonitor() != null) {
                        database = (Database)Monitor.findService("org.apache.derby.database.Database", dbName);
                    }
                    if (database == null) {
                        if (requestPassword) {
                            this.getConnection(user, password).close();
                        } else {
                            this.getConnection().close();
                        }
                        database = (Database)Monitor.findService("org.apache.derby.database.Database", dbName);
                    }
                    if (database != null) {
                        this.ra = (ResourceAdapter)database.getResourceAdapter();
                    }
                }
                if (this.ra == null) {
                    throw new SQLException(MessageService.getTextMessage("I024"), "08006", 45000);
                }
                this.findDriver();
                if (this.driver == null) {
                    throw new SQLException(MessageService.getTextMessage("I025"), "08006", 45000);
                }
            }
        }
    }

    protected XAConnection createXAConnection(ResourceAdapter ra, String user, String password, boolean requestPassword) throws SQLException {
        return ((Driver30)this.findDriver()).getNewXAConnection(this, ra, user, password, requestPassword);
    }
}

