/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Vector;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;
import javax.sql.XAConnection;
import org.apache.derby.iapi.jdbc.ResourceAdapter;
import org.apache.derby.jdbc.EmbedXAConnection;
import org.apache.derby.jdbc.EmbeddedDataSource;

final class EmbedXAConnection40
extends EmbedXAConnection
implements XAConnection {
    protected final Vector<StatementEventListener> statementEventListeners = new Vector();

    EmbedXAConnection40(EmbeddedDataSource ds, ResourceAdapter ra, String user, String password, boolean requestPassword) throws SQLException {
        super(ds, ra, user, password, requestPassword);
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        if (listener == null) {
            return;
        }
        this.statementEventListeners.removeElement(listener);
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        if (!this.isActive) {
            return;
        }
        if (listener == null) {
            return;
        }
        this.statementEventListeners.addElement(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStatementClose(PreparedStatement statement) {
        if (!this.statementEventListeners.isEmpty()) {
            StatementEvent event = new StatementEvent(this, statement);
            Vector<StatementEventListener> vector = this.statementEventListeners;
            synchronized (vector) {
                for (StatementEventListener l : this.statementEventListeners) {
                    l.statementClosed(event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStatementErrorOccurred(PreparedStatement statement, SQLException sqle) {
        if (!this.statementEventListeners.isEmpty()) {
            StatementEvent event = new StatementEvent(this, statement, sqle);
            Vector<StatementEventListener> vector = this.statementEventListeners;
            synchronized (vector) {
                for (StatementEventListener l : this.statementEventListeners) {
                    l.statementErrorOccurred(event);
                }
            }
        }
    }
}

