/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Vector;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;
import org.apache.derby.jdbc.EmbedPooledConnection;
import org.apache.derby.jdbc.ReferenceableDataSource;

class EmbedPooledConnection40
extends EmbedPooledConnection {
    protected final Vector<StatementEventListener> statementEventListeners = new Vector();

    EmbedPooledConnection40(ReferenceableDataSource ds, String user, String password, boolean requestPassword) throws SQLException {
        super(ds, user, password, requestPassword);
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        if (listener == null) {
            return;
        }
        this.statementEventListeners.removeElement(listener);
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        if (!this.isActive) {
            return;
        }
        if (listener == null) {
            return;
        }
        this.statementEventListeners.addElement(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStatementClose(PreparedStatement statement) {
        if (!this.statementEventListeners.isEmpty()) {
            StatementEvent event = new StatementEvent(this, statement);
            Vector<StatementEventListener> vector = this.statementEventListeners;
            synchronized (vector) {
                for (StatementEventListener l : this.statementEventListeners) {
                    l.statementClosed(event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStatementErrorOccurred(PreparedStatement statement, SQLException sqle) {
        if (!this.statementEventListeners.isEmpty()) {
            StatementEvent event = new StatementEvent(this, statement, sqle);
            Vector<StatementEventListener> vector = this.statementEventListeners;
            synchronized (vector) {
                for (StatementEventListener l : this.statementEventListeners) {
                    l.statementErrorOccurred(event);
                }
            }
        }
    }
}

