/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.xact;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.store.access.TransactionInfo;
import org.apache.derby.iapi.store.raw.GlobalTransactionId;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.TransactionId;
import org.apache.derby.impl.store.raw.xact.Xact;
import org.apache.derby.impl.store.raw.xact.XactContext;

public class TransactionTableEntry
implements Formatable,
TransactionInfo,
Cloneable {
    private TransactionId xid;
    private GlobalTransactionId gid;
    private LogInstant firstLog;
    private LogInstant lastLog;
    private int transactionStatus;
    private transient Xact myxact;
    private transient boolean update;
    private transient boolean recovery;
    private transient boolean needExclusion;
    private boolean isClone;
    private transient LanguageConnectionContext lcc;
    static final int UPDATE = 1;
    static final int RECOVERY = 2;
    static final int EXCLUDE = 4;

    TransactionTableEntry(Xact xact, TransactionId tid, int status, int attribute) {
        this.myxact = xact;
        this.xid = tid;
        this.transactionStatus = status;
        this.update = (attribute & 1) != 0;
        this.needExclusion = (attribute & 4) != 0;
        this.recovery = (attribute & 2) != 0;
        SanityManager.ASSERT(tid != null, "tid is null");
        if (this.update && xact.getFirstLogInstant() == null) {
            SanityManager.THROWASSERT("update transaction has firstLog = null");
        }
        if (this.recovery) {
            SanityManager.ASSERT(this.update, "recovery but not update");
            if (tid != xact.getId()) {
                SanityManager.THROWASSERT("adding a update transaction during recovery  but the tids doesn't match" + tid + " " + xact.getId());
            }
            this.gid = xact.getGlobalId();
            this.firstLog = xact.getFirstLogInstant();
            this.lastLog = xact.getLastLogInstant();
        }
    }

    public TransactionTableEntry() {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        SanityManager.ASSERT(!this.recovery, "writing out a recovery transaction");
        SanityManager.ASSERT(this.update, "writing out read only transaction");
        SanityManager.ASSERT(this.myxact.getFirstLogInstant() != null, "myxact.getFirstLogInstant is null");
        SanityManager.ASSERT(!this.isClone, "cannot write out a clone");
        out.writeObject(this.xid);
        out.writeObject(this.myxact.getGlobalId());
        out.writeObject(this.myxact.getFirstLogInstant());
        out.writeObject(this.myxact.getLastLogInstant());
        out.writeInt(this.transactionStatus);
    }

    public void readExternal(ObjectInput in) throws ClassNotFoundException, IOException {
        SanityManager.ASSERT(!this.isClone, "cannot write out a clone");
        this.xid = (TransactionId)in.readObject();
        this.gid = (GlobalTransactionId)in.readObject();
        this.firstLog = (LogInstant)in.readObject();
        this.lastLog = (LogInstant)in.readObject();
        this.transactionStatus = in.readInt();
        this.update = true;
        this.recovery = true;
        this.needExclusion = true;
        SanityManager.ASSERT(this.xid != null, "read in transaction table entry with null id");
        SanityManager.ASSERT(this.firstLog != null, "read in transaction table entry with firstLog");
    }

    void setXact(Xact xact) {
        this.myxact = xact;
    }

    public int getTypeFormatId() {
        return 261;
    }

    public String toString() {
        StringBuffer str = new StringBuffer(500).append("Xid=").append(this.getXid()).append(" gid=").append(this.getGid()).append(" firstLog=").append(this.getFirstLog()).append(" lastLog=").append(this.getLastLog()).append(" transactionStatus=").append(this.transactionStatus).append(" myxact=").append(this.myxact).append(" update=").append(this.update).append(" recovery=").append(this.recovery).append(" prepare=").append(this.isPrepared()).append(" needExclusion=").append(this.needExclusion).append("\n");
        return str.toString();
    }

    void updateTransactionStatus(Xact xact, int status, int attribute) {
        SanityManager.ASSERT(this.myxact == xact, "update transaction status for wrong xact");
        SanityManager.ASSERT(!this.isClone, "cannot change a clone");
        this.update = (attribute & 1) != 0;
    }

    void removeUpdateTransaction() {
        SanityManager.ASSERT(!this.isClone, "cannot change a clone");
        this.update = false;
        this.transactionStatus = 0;
    }

    void unsetRecoveryStatus() {
        SanityManager.ASSERT(!this.isClone, "cannot change a clone");
        this.firstLog = null;
        this.recovery = false;
    }

    void prepareTransaction() {
        SanityManager.ASSERT(!this.isClone, "cannot change a clone");
        this.transactionStatus |= 2;
    }

    TransactionId getXid() {
        SanityManager.ASSERT(this.xid != null, "TTE with null xid");
        SanityManager.ASSERT(!this.isClone, "cannot call method with a clone");
        return this.xid;
    }

    public final GlobalTransactionId getGid() {
        SanityManager.ASSERT(!this.isClone, "cannot call method with a clone");
        if (this.gid != null) {
            return this.gid;
        }
        if (this.myxact != null) {
            return this.myxact.getGlobalId();
        }
        return null;
    }

    LogInstant getFirstLog() {
        SanityManager.ASSERT(!this.isClone, "cannot call method with a clone");
        if (this.recovery) {
            SanityManager.ASSERT(this.firstLog != null, "a recovery transaction with a null firstLog");
        } else {
            SanityManager.ASSERT(this.firstLog == null, "a normal transaction with a non-null firstLogmyxact.getFirstLogInstant() = " + this.myxact.getFirstLogInstant());
        }
        if (this.firstLog != null) {
            return this.firstLog;
        }
        if (this.myxact != null) {
            return this.myxact.getFirstLogInstant();
        }
        return null;
    }

    LogInstant getLastLog() {
        SanityManager.ASSERT(!this.isClone, "cannot call method with a clone");
        if (this.lastLog != null) {
            return this.lastLog;
        }
        if (this.myxact != null) {
            return this.myxact.getLastLogInstant();
        }
        return null;
    }

    public final Xact getXact() {
        SanityManager.ASSERT(!this.isClone, "cannot call method with a clone");
        return this.myxact;
    }

    int getTransactionStatus() {
        SanityManager.ASSERT(!this.isClone, "cannot call method with a clone");
        return this.transactionStatus;
    }

    boolean isUpdate() {
        SanityManager.ASSERT(!this.isClone, "cannot call method with a clone");
        return this.update;
    }

    boolean isRecovery() {
        SanityManager.ASSERT(!this.isClone, "cannot call method with a clone");
        return this.recovery;
    }

    boolean isPrepared() {
        SanityManager.ASSERT(!this.isClone, "cannot call method with a clone");
        return (this.transactionStatus & 2) != 0;
    }

    public boolean needExclusion() {
        SanityManager.ASSERT(!this.isClone, "cannot call method with a clone");
        return this.needExclusion;
    }

    public String getTransactionIdString() {
        SanityManager.ASSERT(!this.recovery, "trying to display recovery transaction");
        SanityManager.ASSERT(this.myxact != null, "my xact is null");
        SanityManager.ASSERT(this.isClone, "Should only call method on a clone");
        TransactionId t = this.myxact.getIdNoCheck();
        return t == null ? "CLOSED" : t.toString();
    }

    public String getGlobalTransactionIdString() {
        SanityManager.ASSERT(!this.recovery, "trying to display recovery transaction");
        SanityManager.ASSERT(this.myxact != null, "my xact is null");
        SanityManager.ASSERT(this.isClone, "Should only call method on a clone");
        GlobalTransactionId gid = this.myxact.getGlobalId();
        return gid == null ? null : gid.toString();
    }

    public String getUsernameString() {
        SanityManager.ASSERT(this.isClone, "Should only call method on a clone");
        this.getlcc();
        return this.lcc == null ? null : this.lcc.getAuthorizationId();
    }

    public String getTransactionTypeString() {
        SanityManager.ASSERT(this.isClone, "Should only call method on a clone");
        if (this.myxact == null) {
            return null;
        }
        if (this.myxact.getTransName() != null) {
            return this.myxact.getTransName();
        }
        return this.myxact.getContextId();
    }

    public String getTransactionStatusString() {
        SanityManager.ASSERT(this.isClone, "Should only call method on a clone");
        return this.myxact == null ? null : this.myxact.getState();
    }

    public String getStatementTextString() {
        StatementContext sc;
        SanityManager.ASSERT(this.isClone, "Should only call method on a clone");
        this.getlcc();
        if (this.lcc != null && (sc = this.lcc.getStatementContext()) != null) {
            return sc.getStatementText();
        }
        return null;
    }

    public String getFirstLogInstantString() {
        SanityManager.ASSERT(this.isClone, "Should only call method on a clone");
        LogInstant logInstant = this.myxact == null ? null : this.myxact.getFirstLogInstant();
        return logInstant == null ? null : logInstant.toString();
    }

    private void getlcc() {
        SanityManager.ASSERT(this.isClone, "Should only call method on a clone");
        if (this.lcc == null && this.myxact != null && this.myxact.xc != null) {
            XactContext xc = this.myxact.xc;
            this.lcc = (LanguageConnectionContext)xc.getContextManager().getContext("LanguageConnectionContext");
        }
    }

    protected Object clone() {
        try {
            Object c = super.clone();
            ((TransactionTableEntry)c).isClone = true;
            return c;
        }
        catch (CloneNotSupportedException e) {
            SanityManager.THROWASSERT("TransactionTableEntry cloneable but throws CloneNotSupportedException", e);
            return null;
        }
    }
}

