/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.log;

import java.io.IOException;
import java.io.SyncFailedException;
import java.util.LinkedList;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.ArrayOutputStream;
import org.apache.derby.iapi.services.io.FormatIdOutputStream;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.impl.store.raw.log.ChecksumOperation;
import org.apache.derby.impl.store.raw.log.LogAccessFileBuffer;
import org.apache.derby.impl.store.raw.log.LogCounter;
import org.apache.derby.impl.store.raw.log.LogRecord;
import org.apache.derby.impl.store.raw.log.LogToFile;
import org.apache.derby.io.StorageRandomAccessFile;

public class LogAccessFile {
    private static final int LOG_RECORD_FIXED_OVERHEAD_SIZE = 16;
    private static final int LOG_RECORD_HEADER_SIZE = 12;
    private static final int LOG_RECORD_TRAILER_SIZE = 4;
    private static final int LOG_NUMBER_LOG_BUFFERS = 3;
    private LinkedList freeBuffers;
    private LinkedList dirtyBuffers;
    private LogAccessFileBuffer currentBuffer;
    private boolean flushInProgress = false;
    private final StorageRandomAccessFile log;
    private final Object logFileSemaphore;
    static int mon_numWritesToLog;
    static int mon_numBytesToLog;
    private ArrayOutputStream logOutputBuffer;
    private FormatIdOutputStream logicalOut;
    private boolean directWrite = false;
    private long checksumInstant = -1L;
    private int checksumLength;
    private int checksumLogRecordSize;
    private boolean writeChecksum;
    private ChecksumOperation checksumLogOperation;
    private LogRecord checksumLogRecord;
    private LogToFile logFactory;
    private boolean databaseEncrypted = false;
    private byte[] db = new byte[4];

    public LogAccessFile(LogToFile logFactory, StorageRandomAccessFile log, int bufferSize) {
        if (SanityManager.DEBUG_ON("LogBufferOff")) {
            bufferSize = 10;
        }
        this.log = log;
        this.logFileSemaphore = log;
        this.logFactory = logFactory;
        SanityManager.ASSERT(true);
        this.freeBuffers = new LinkedList();
        this.dirtyBuffers = new LinkedList();
        for (int i = 0; i < 3; ++i) {
            LogAccessFileBuffer b = new LogAccessFileBuffer(bufferSize);
            this.freeBuffers.addLast(b);
        }
        this.currentBuffer = (LogAccessFileBuffer)this.freeBuffers.removeFirst();
        this.writeChecksum = logFactory.checkVersion(10, 1);
        if (this.writeChecksum) {
            this.checksumLogOperation = new ChecksumOperation();
            this.checksumLogOperation.init();
            this.checksumLogRecord = new LogRecord();
            this.checksumLogRecord.setValue(null, this.checksumLogOperation);
            this.checksumLength = LogRecord.getStoredSize(this.checksumLogOperation.group(), null) + this.checksumLogOperation.getStoredSize();
            if (logFactory.databaseEncrypted()) {
                this.checksumLength = logFactory.getEncryptedDataLength(this.checksumLength);
                this.databaseEncrypted = true;
            }
            this.checksumLogRecordSize = this.checksumLength + 16;
            this.logOutputBuffer = new ArrayOutputStream();
            this.logicalOut = new FormatIdOutputStream(this.logOutputBuffer);
        } else {
            this.checksumLogRecordSize = 0;
        }
        this.currentBuffer.init(this.checksumLogRecordSize);
    }

    public void writeLogRecord(int length, long instant, byte[] data, int data_offset, byte[] optional_data, int optional_data_offset, int optional_data_length) throws StandardException, IOException {
        int total_log_record_length = length + 16;
        if (total_log_record_length <= this.currentBuffer.bytes_free) {
            byte[] b = this.currentBuffer.buffer;
            int p = this.currentBuffer.position;
            p = this.writeInt(length, b, p);
            p = this.writeLong(instant, b, p);
            int transfer_length = length - optional_data_length;
            System.arraycopy(data, data_offset, b, p, transfer_length);
            p += transfer_length;
            if (optional_data_length != 0) {
                System.arraycopy(optional_data, optional_data_offset, b, p, optional_data_length);
                p += optional_data_length;
            }
            this.currentBuffer.position = p = this.writeInt(length, b, p);
            this.currentBuffer.bytes_free -= total_log_record_length;
        } else {
            this.directWrite = true;
            byte[] b = this.currentBuffer.buffer;
            int p = this.currentBuffer.position;
            p = this.writeInt(length, b, p);
            this.currentBuffer.position = p = this.writeLong(instant, b, p);
            this.currentBuffer.bytes_free -= 12;
            this.writeInt(length, this.db, 0);
            if (this.writeChecksum) {
                this.checksumLogOperation.reset();
                this.checksumLogOperation.update(b, this.checksumLogRecordSize, p - this.checksumLogRecordSize);
                this.checksumLogOperation.update(data, data_offset, length - optional_data_length);
                if (optional_data_length != 0) {
                    this.checksumLogOperation.update(optional_data, optional_data_offset, optional_data_length);
                }
                this.checksumLogOperation.update(this.db, 0, 4);
                this.writeChecksumLogRecord();
            }
            this.flushLogAccessFile();
            this.writeToLog(data, data_offset, length - optional_data_length);
            if (optional_data_length != 0) {
                this.writeToLog(optional_data, optional_data_offset, optional_data_length);
            }
            this.writeToLog(this.db, 0, 4);
            this.directWrite = false;
        }
    }

    private final int writeInt(int i, byte[] b, int p) {
        b[p++] = (byte)(i >>> 24 & 0xFF);
        b[p++] = (byte)(i >>> 16 & 0xFF);
        b[p++] = (byte)(i >>> 8 & 0xFF);
        b[p++] = (byte)(i & 0xFF);
        return p;
    }

    private final int writeLong(long l, byte[] b, int p) {
        b[p++] = (byte)((int)(l >>> 56) & 0xFF);
        b[p++] = (byte)((int)(l >>> 48) & 0xFF);
        b[p++] = (byte)((int)(l >>> 40) & 0xFF);
        b[p++] = (byte)((int)(l >>> 32) & 0xFF);
        b[p++] = (byte)((int)(l >>> 24) & 0xFF);
        b[p++] = (byte)((int)(l >>> 16) & 0xFF);
        b[p++] = (byte)((int)(l >>> 8) & 0xFF);
        b[p++] = (byte)((int)l & 0xFF);
        return p;
    }

    public void writeInt(int i) {
        SanityManager.ASSERT(this.currentBuffer.bytes_free >= 4);
        this.currentBuffer.position = this.writeInt(i, this.currentBuffer.buffer, this.currentBuffer.position);
        this.currentBuffer.bytes_free -= 4;
    }

    public void writeLong(long l) {
        SanityManager.ASSERT(this.currentBuffer.bytes_free >= 8);
        this.currentBuffer.position = this.writeLong(l, this.currentBuffer.buffer, this.currentBuffer.position);
        this.currentBuffer.bytes_free -= 8;
    }

    public void write(int b) {
        SanityManager.ASSERT(this.currentBuffer.bytes_free > 0);
        this.currentBuffer.buffer[this.currentBuffer.position++] = (byte)b;
        --this.currentBuffer.bytes_free;
    }

    public void write(byte[] b, int off, int len) {
        SanityManager.ASSERT(len <= this.currentBuffer.bytes_free);
        System.arraycopy(b, off, this.currentBuffer.buffer, this.currentBuffer.position, len);
        this.currentBuffer.bytes_free -= len;
        this.currentBuffer.position += len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void flushDirtyBuffers() throws IOException {
        LogAccessFile logAccessFile;
        LogAccessFileBuffer buf = null;
        int nFlushed = 0;
        try {
            int noOfBuffers;
            logAccessFile = this;
            synchronized (logAccessFile) {
                while (this.flushInProgress) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ie) {}
                }
                noOfBuffers = this.dirtyBuffers.size();
                if (noOfBuffers > 0) {
                    buf = (LogAccessFileBuffer)this.dirtyBuffers.removeFirst();
                }
                this.flushInProgress = true;
            }
            while (nFlushed < noOfBuffers) {
                if (buf.position != 0) {
                    this.writeToLog(buf.buffer, 0, buf.position);
                }
                logAccessFile = this;
                synchronized (logAccessFile) {
                    this.freeBuffers.addLast(buf);
                    if (++nFlushed < noOfBuffers) {
                        buf = (LogAccessFileBuffer)this.dirtyBuffers.removeFirst();
                    } else {
                        int size = this.dirtyBuffers.size();
                        if (size > 0 && nFlushed <= 3) {
                            noOfBuffers += size;
                            buf = (LogAccessFileBuffer)this.dirtyBuffers.removeFirst();
                        }
                    }
                }
            }
            return;
        }
        finally {
            logAccessFile = this;
            synchronized (logAccessFile) {
                this.flushInProgress = false;
                this.notifyAll();
            }
        }
    }

    public void flushLogAccessFile() throws IOException, StandardException {
        this.switchLogBuffer();
        this.flushDirtyBuffers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchLogBuffer() throws IOException, StandardException {
        LogAccessFile logAccessFile = this;
        synchronized (logAccessFile) {
            if (this.currentBuffer.position == this.checksumLogRecordSize) {
                return;
            }
            if (this.writeChecksum && !this.directWrite) {
                this.checksumLogOperation.reset();
                this.checksumLogOperation.update(this.currentBuffer.buffer, this.checksumLogRecordSize, this.currentBuffer.position - this.checksumLogRecordSize);
                this.writeChecksumLogRecord();
            }
            this.dirtyBuffers.addLast(this.currentBuffer);
            if (this.freeBuffers.size() == 0) {
                this.flushDirtyBuffers();
            }
            SanityManager.ASSERT(this.freeBuffers.size() > 0);
            this.currentBuffer = (LogAccessFileBuffer)this.freeBuffers.removeFirst();
            this.currentBuffer.init(this.checksumLogRecordSize);
            SanityManager.ASSERT(this.currentBuffer.position == this.checksumLogRecordSize);
            SanityManager.ASSERT(this.currentBuffer.bytes_free == this.currentBuffer.length);
            SanityManager.ASSERT(this.currentBuffer.bytes_free > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncLogAccessFile() throws IOException, StandardException {
        int i = 0;
        while (true) {
            try {
                LogAccessFile logAccessFile = this;
                synchronized (logAccessFile) {
                    this.log.sync(false);
                }
            }
            catch (SyncFailedException sfe) {
                ++i;
                try {
                    Thread.sleep(200L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (i <= 20) continue;
                throw StandardException.newException("XSLA4.D", sfe);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void corrupt() throws IOException {
        Object object = this.logFileSemaphore;
        synchronized (object) {
            if (this.log != null) {
                this.log.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException, StandardException {
        if (this.currentBuffer.position != this.checksumLogRecordSize) {
            SanityManager.THROWASSERT("Log file being closed with data still buffered " + this.currentBuffer.position + " " + this.currentBuffer.bytes_free);
        }
        this.flushLogAccessFile();
        Object object = this.logFileSemaphore;
        synchronized (object) {
            if (this.log != null) {
                this.log.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToLog(byte[] b, int off, int len) throws IOException {
        Object object = this.logFileSemaphore;
        synchronized (object) {
            if (this.log != null) {
                int i = 0;
                while (true) {
                    try {
                        this.log.write(b, off, len);
                    }
                    catch (IOException ioe) {
                        if (i >= 5) {
                            throw ioe;
                        }
                        ++i;
                        continue;
                    }
                    break;
                }
            }
        }
        ++mon_numWritesToLog;
        mon_numBytesToLog += len;
    }

    protected long reserveSpaceForChecksum(int length, long logFileNumber, long currentPosition) throws StandardException, IOException {
        int total_log_record_length = length + 16;
        boolean reserveChecksumSpace = false;
        if (this.currentBuffer.position == this.checksumLogRecordSize) {
            reserveChecksumSpace = this.writeChecksum;
        } else if (total_log_record_length > this.currentBuffer.bytes_free) {
            this.switchLogBuffer();
            reserveChecksumSpace = this.writeChecksum;
        }
        if (reserveChecksumSpace) {
            SanityManager.ASSERT(this.checksumInstant == -1L, "CHECKSUM INSTANT IS GETTING OVER WRITTEN");
            this.checksumInstant = LogCounter.makeLogInstantAsLong(logFileNumber, currentPosition);
            return this.checksumLogRecordSize;
        }
        return 0L;
    }

    private void writeChecksumLogRecord() throws IOException, StandardException {
        byte[] b = this.currentBuffer.buffer;
        int p = 0;
        p = this.writeInt(this.checksumLength, b, p);
        p = this.writeLong(this.checksumInstant, b, p);
        this.logOutputBuffer.setData(b);
        this.logOutputBuffer.setPosition(p);
        this.logicalOut.writeObject(this.checksumLogRecord);
        if (this.databaseEncrypted) {
            int len = this.logFactory.encrypt(b, 12, this.checksumLength, b, 12);
            SanityManager.ASSERT(len == this.checksumLength, "encrypted log buffer length != log buffer len");
        }
        p = 12 + this.checksumLength;
        SanityManager.ASSERT((p = this.writeInt(this.checksumLength, b, p)) == this.checksumLogRecordSize, "position=" + p + "ckrecordsize=" + this.checksumLogRecordSize);
        if (SanityManager.DEBUG_ON(LogToFile.DBG_FLAG)) {
            SanityManager.DEBUG(LogToFile.DBG_FLAG, "Write log record: tranId=Null instant: " + LogCounter.toDebugString(this.checksumInstant) + " length: " + this.checksumLength + "\n" + this.checksumLogOperation + "\n");
        }
        this.checksumInstant = -1L;
    }

    protected void writeEndMarker(int marker) throws IOException, StandardException {
        this.flushLogAccessFile();
        byte[] b = this.currentBuffer.buffer;
        int p = 0;
        p = this.writeInt(marker, b, p);
        this.writeToLog(b, 0, p);
    }
}

