/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.log;

import java.io.IOException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.TransactionId;
import org.apache.derby.impl.store.raw.log.LogCounter;
import org.apache.derby.impl.store.raw.log.LogRecord;
import org.apache.derby.impl.store.raw.log.LogToFile;
import org.apache.derby.impl.store.raw.log.StreamLogScan;
import org.apache.derby.io.StorageRandomAccessFile;

public class FlushedScan
implements StreamLogScan {
    private StorageRandomAccessFile scan;
    LogToFile logFactory;
    boolean open;
    long currentLogFileNumber;
    long currentLogFileFirstUnflushedPosition;
    long currentInstant;
    long firstUnflushed = -1L;
    long firstUnflushedFileNumber;
    long firstUnflushedFilePosition;
    static final int LOG_REC_LEN_BYTE_LENGTH = 4;
    int nextRecordLength;
    boolean readNextRecordLength;

    public FlushedScan(LogToFile logFactory, long startAt) throws StandardException {
        SanityManager.ASSERT(startAt != 0L, "cannot start scan on an invalid log instant");
        try {
            this.currentLogFileNumber = LogCounter.getLogFileNumber(startAt);
            this.logFactory = logFactory;
            this.scan = logFactory.getLogFileAtPosition(startAt);
            this.setFirstUnflushed();
            this.open = true;
            this.currentInstant = 0L;
        }
        catch (IOException ioe) {
            throw logFactory.markCorrupt(StandardException.newException("XSLA2.D", ioe));
        }
    }

    public LogRecord getNextRecord(ArrayInputStream input, TransactionId tranId, int groupmask) throws StandardException {
        try {
            LogRecord lr;
            boolean candidate;
            int peekAmount = LogRecord.formatOverhead() + LogRecord.maxGroupStoredSize();
            if (tranId != null) {
                peekAmount += LogRecord.maxTransactionIdStoredSize(tranId);
            }
            do {
                if (!this.open || !this.positionToNextRecord()) {
                    return null;
                }
                lr = null;
                candidate = true;
                int readAmount = -1;
                this.currentInstant = this.scan.readLong();
                byte[] data = input.getData();
                if (data.length < this.nextRecordLength) {
                    data = new byte[this.nextRecordLength];
                    input.setData(data);
                }
                if (this.logFactory.databaseEncrypted()) {
                    this.scan.readFully(data, 0, this.nextRecordLength);
                    int len = this.logFactory.decrypt(data, 0, this.nextRecordLength, data, 0);
                    SanityManager.ASSERT(len == this.nextRecordLength);
                    input.setLimit(0, len);
                } else if (groupmask == 0 && tranId == null) {
                    this.scan.readFully(data, 0, this.nextRecordLength);
                    input.setLimit(0, this.nextRecordLength);
                } else {
                    readAmount = this.nextRecordLength > peekAmount ? peekAmount : this.nextRecordLength;
                    this.scan.readFully(data, 0, readAmount);
                    input.setLimit(0, readAmount);
                }
                lr = (LogRecord)input.readObject();
                if (groupmask != 0 || tranId != null) {
                    TransactionId tid;
                    if (groupmask != 0 && (groupmask & lr.group()) == 0) {
                        candidate = false;
                    }
                    if (candidate && tranId != null && !(tid = lr.getTransactionId()).equals(tranId)) {
                        candidate = false;
                    }
                    if (candidate && !this.logFactory.databaseEncrypted()) {
                        SanityManager.ASSERT(readAmount > 0);
                        if (readAmount < this.nextRecordLength) {
                            int inputPosition = input.getPosition();
                            this.scan.readFully(data, readAmount, this.nextRecordLength - readAmount);
                            input.setLimit(0, this.nextRecordLength);
                            input.setPosition(inputPosition);
                        }
                    }
                }
                if (candidate || this.logFactory.databaseEncrypted()) {
                    int checkLength = this.scan.readInt();
                    SanityManager.ASSERT(checkLength == this.nextRecordLength, "log currupted");
                    continue;
                }
                long nextRecordStartPosition = LogCounter.getLogFilePosition(this.currentInstant) + (long)this.nextRecordLength + 16L;
                this.scan.seek(nextRecordStartPosition);
            } while (!candidate);
            return lr;
        }
        catch (ClassNotFoundException cnfe) {
            throw this.logFactory.markCorrupt(StandardException.newException("XSLA3.D", cnfe));
        }
        catch (IOException ioe) {
            throw this.logFactory.markCorrupt(StandardException.newException("XSLA2.D", ioe));
        }
    }

    public void resetPosition(LogInstant instant) throws IOException {
        SanityManager.THROWASSERT("Unsupported feature");
    }

    public long getLogRecordEnd() {
        SanityManager.THROWASSERT("Unsupported feature");
        return 0L;
    }

    public boolean isLogEndFuzzy() {
        SanityManager.THROWASSERT("Unsupported feature");
        return false;
    }

    public long getInstant() {
        return this.currentInstant;
    }

    public LogInstant getLogInstant() {
        if (this.currentInstant == 0L) {
            return null;
        }
        return new LogCounter(this.currentInstant);
    }

    public void close() {
        if (this.scan != null) {
            try {
                this.scan.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.scan = null;
        }
        this.currentInstant = 0L;
        this.open = false;
    }

    private void setFirstUnflushed() throws StandardException, IOException {
        LogInstant firstUnflushedInstant = this.logFactory.getFirstUnflushedInstant();
        this.firstUnflushed = ((LogCounter)firstUnflushedInstant).getValueAsLong();
        this.firstUnflushedFileNumber = LogCounter.getLogFileNumber(this.firstUnflushed);
        this.firstUnflushedFilePosition = LogCounter.getLogFilePosition(this.firstUnflushed);
        this.setCurrentLogFileFirstUnflushedPosition();
    }

    private void setCurrentLogFileFirstUnflushedPosition() throws IOException {
        if (this.currentLogFileNumber == this.firstUnflushedFileNumber) {
            this.currentLogFileFirstUnflushedPosition = this.firstUnflushedFilePosition;
        } else if (this.currentLogFileNumber < this.firstUnflushedFileNumber) {
            this.currentLogFileFirstUnflushedPosition = this.scan.length();
        } else {
            throw new IOException(MessageService.getTextMessage("L014"));
        }
    }

    private void switchLogFile() throws StandardException {
        try {
            this.readNextRecordLength = false;
            this.scan.close();
            this.scan = null;
            this.scan = this.logFactory.getLogFileAtBeginning(++this.currentLogFileNumber);
            this.setCurrentLogFileFirstUnflushedPosition();
        }
        catch (IOException ioe) {
            throw this.logFactory.markCorrupt(StandardException.newException("XSLA2.D", ioe));
        }
    }

    private boolean currentLogFileHasUnflushedRecord() throws IOException {
        SanityManager.ASSERT(this.scan != null, "scan is null");
        long curPos = this.scan.getFilePointer();
        if (!this.readNextRecordLength) {
            if (curPos + 4L > this.currentLogFileFirstUnflushedPosition) {
                return false;
            }
            this.nextRecordLength = this.scan.readInt();
            curPos += 4L;
            this.readNextRecordLength = true;
        }
        if (this.nextRecordLength == 0) {
            return false;
        }
        int bytesNeeded = this.nextRecordLength + 4;
        if (curPos + (long)bytesNeeded > this.currentLogFileFirstUnflushedPosition) {
            return false;
        }
        this.readNextRecordLength = false;
        return true;
    }

    private boolean positionToNextRecord() throws StandardException, IOException {
        if (this.currentLogFileHasUnflushedRecord()) {
            return true;
        }
        this.setFirstUnflushed();
        if (this.currentLogFileHasUnflushedRecord()) {
            return true;
        }
        while (this.currentLogFileNumber < this.firstUnflushedFileNumber) {
            this.switchLogFile();
            if (!this.currentLogFileHasUnflushedRecord()) continue;
            return true;
        }
        this.currentInstant = 0L;
        return false;
    }
}

