/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.access.conglomerate.LogicalUndo;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.LogicalPageOperation;

public final class UpdateFieldOperation
extends LogicalPageOperation {
    protected int doMeSlot;
    protected int fieldId;
    protected transient ByteArray preparedLog;

    public UpdateFieldOperation(RawTransaction t, BasePage page, int slot, int recordId, int fieldId, Object column, LogicalUndo undo) throws StandardException {
        super(page, undo, recordId);
        this.doMeSlot = slot;
        this.fieldId = fieldId;
        try {
            this.writeOptionalDataToBuffer(t, column);
        }
        catch (IOException ioe) {
            throw StandardException.newException("XSDA4.S", ioe);
        }
    }

    public UpdateFieldOperation() {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        CompressedNumber.writeInt(out, this.doMeSlot);
        CompressedNumber.writeInt(out, this.fieldId);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.doMeSlot = CompressedNumber.readInt(in);
        this.fieldId = CompressedNumber.readInt(in);
    }

    public int getTypeFormatId() {
        return 109;
    }

    public void doMe(Transaction xact, LogInstant instant, LimitObjectInput in) throws StandardException, IOException {
        this.page.storeField(instant, this.doMeSlot, this.fieldId, in);
    }

    public void undoMe(Transaction xact, BasePage undoPage, int undoRecordId, LogInstant CLRInstant, LimitObjectInput in) throws StandardException, IOException {
        int slot = undoPage.findRecordById(undoRecordId, 0);
        if (undoRecordId != this.recordId && undoPage.getPageNumber() == this.getPageId().getPageNumber()) {
            SanityManager.THROWASSERT("recordId changed from " + this.recordId + " to " + undoRecordId + " but page number did not change " + undoPage.getPageNumber());
        }
        if (slot == -1) {
            SanityManager.THROWASSERT("recordId " + undoRecordId + " not found on page " + undoPage.getPageNumber());
        }
        undoPage.skipField(in);
        undoPage.storeField(CLRInstant, slot, this.fieldId, in);
        undoPage.setAuxObject(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreLoggedRow(Object[] row, LimitObjectInput in) throws StandardException, IOException {
        BasePage p = null;
        try {
            p = (BasePage)this.getContainer().getPage(this.getPageId().getPageNumber());
            p.skipField(in);
            p.skipField(in);
            p.restoreRecordFromStream(in, row);
        }
        finally {
            if (p != null) {
                p.unlatch();
                p = null;
            }
        }
    }

    public void restoreMe(Transaction xact, BasePage undoPage, LogInstant CLRInstant, LimitObjectInput in) throws StandardException, IOException {
        int slot = undoPage.findRecordById(this.recordId, 0);
        if (!this.getPageId().equals(undoPage.getPageId())) {
            SanityManager.THROWASSERT("restoreMe cannot restore to a different page. doMe page:" + this.getPageId() + " undoPage:" + undoPage.getPageId());
        }
        if (slot != this.doMeSlot) {
            SanityManager.THROWASSERT("restoreMe cannot restore to a different slot. doMe slot:" + this.doMeSlot + " undoMe slot: " + slot + " recordId:" + this.recordId);
        }
        undoPage.skipField(in);
        undoPage.storeField(CLRInstant, slot, this.fieldId, in);
        undoPage.setAuxObject(null);
    }

    public ByteArray getPreparedLog() {
        return this.preparedLog;
    }

    private void writeOptionalDataToBuffer(RawTransaction t, Object column) throws StandardException, IOException {
        int optionalDataLength;
        SanityManager.ASSERT(this.page != null);
        DynamicByteArrayOutputStream logBuffer = t.getLogBuffer();
        int optionalDataStart = logBuffer.getPosition();
        SanityManager.ASSERT(optionalDataStart == 0, "Buffer for writing optional data should start at position 0");
        this.page.logColumn(this.doMeSlot, this.fieldId, column, logBuffer, 100);
        this.page.logField(this.doMeSlot, this.fieldId, logBuffer);
        if (this.undo != null) {
            this.page.logRecord(this.doMeSlot, 0, this.recordId, null, logBuffer, null);
        }
        if ((optionalDataLength = logBuffer.getPosition() - optionalDataStart) != logBuffer.getUsed()) {
            SanityManager.THROWASSERT("wrong optional data length, optionalDataLength = " + optionalDataLength + ", logBuffer.getUsed() = " + logBuffer.getUsed());
        }
        logBuffer.setPosition(optionalDataStart);
        this.preparedLog = new ByteArray(logBuffer.getByteArray(), optionalDataStart, optionalDataLength);
    }

    public String toString() {
        return super.toString() + "UpdateField : " + " Slot=" + this.doMeSlot + " recordId=" + this.recordId + " fieldId=" + this.fieldId;
    }
}

