/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.OutputStream;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.impl.store.raw.data.RecordId;

public final class StoredRecordHeader {
    public static final int RECORD_INITIAL = 0;
    public static final int RECORD_DELETED = 1;
    public static final int RECORD_OVERFLOW = 2;
    public static final int RECORD_HAS_FIRST_FIELD = 4;
    public static final int RECORD_VALID_MASK = 15;
    protected int id;
    protected int status;
    protected int numberFields;
    protected RecordHandle handle;
    protected int overflowId;
    protected long overflowPage;
    protected int firstField;

    public StoredRecordHeader() {
    }

    public StoredRecordHeader(int id, int numberFields) {
        this.setId(id);
        this.setNumberFields(numberFields);
    }

    public StoredRecordHeader(byte[] data, int offset) {
        this.read(data, offset);
    }

    public StoredRecordHeader(StoredRecordHeader loadTargetFrom) {
        this.status = loadTargetFrom.status;
        this.id = loadTargetFrom.id;
        this.numberFields = loadTargetFrom.numberFields;
        this.handle = null;
        this.overflowId = loadTargetFrom.overflowId;
        this.overflowPage = loadTargetFrom.overflowPage;
        this.firstField = loadTargetFrom.firstField;
    }

    protected RecordHandle getHandle(PageKey pageId, int current_slot) {
        if (this.handle == null) {
            this.handle = new RecordId(pageId, this.id, current_slot);
        }
        return this.handle;
    }

    public final int getId() {
        return this.id;
    }

    public int getNumberFields() {
        return this.numberFields;
    }

    public long getOverflowPage() {
        return this.overflowPage;
    }

    public int getOverflowId() {
        return this.overflowId;
    }

    public int getFirstField() {
        return this.firstField;
    }

    public final boolean hasOverflow() {
        return (this.status & 2) == 2;
    }

    protected final boolean hasFirstField() {
        return (this.status & 4) == 4;
    }

    public final boolean isDeleted() {
        return (this.status & 1) == 1;
    }

    public int size() {
        int len;
        int n = this.id <= 63 ? 2 : (len = this.id <= 16383 ? 3 : 5);
        if ((this.status & 6) == 0) {
            len += this.numberFields <= 63 ? 1 : (this.numberFields <= 16383 ? 2 : 4);
        } else if ((this.status & 2) == 0) {
            len += (this.numberFields <= 63 ? 1 : (this.numberFields <= 16383 ? 2 : 4)) + (this.firstField <= 63 ? 1 : (this.firstField <= 16383 ? 2 : 4));
        } else {
            len += CompressedNumber.sizeLong(this.overflowPage);
            len += CompressedNumber.sizeInt(this.overflowId);
            if (this.hasFirstField()) {
                len += CompressedNumber.sizeInt(this.firstField);
                len += CompressedNumber.sizeInt(this.numberFields);
            }
        }
        return len;
    }

    public int setDeleted(boolean deleteTrue) {
        int retCode = 0;
        if (deleteTrue) {
            if (!this.isDeleted()) {
                retCode = 1;
                this.status |= 1;
            }
        } else if (this.isDeleted()) {
            retCode = -1;
            this.status &= 0xFFFFFFFE;
        }
        return retCode;
    }

    public void setFirstField(int firstField) {
        this.firstField = firstField;
        this.status |= 4;
    }

    public final void setId(int id) {
        this.id = id;
    }

    public void setOverflowDetails(RecordHandle overflowHandle) {
        this.overflowPage = overflowHandle.getPageNumber();
        this.overflowId = overflowHandle.getId();
    }

    public void setOverflowFields(StoredRecordHeader loadFromTarget) {
        this.status = loadFromTarget.status | 2;
        this.id = loadFromTarget.id;
        this.numberFields = loadFromTarget.numberFields;
        this.firstField = loadFromTarget.firstField;
        this.handle = null;
    }

    public final void setNumberFields(int numberFields) {
        this.numberFields = numberFields;
    }

    public int write(OutputStream out) throws IOException {
        if ((this.status & 0xFFFFFFF0) != 0) {
            SanityManager.THROWASSERT("Invalid status in StoredRecordHeaader = " + this.status);
        }
        int len = 1;
        out.write(this.status);
        len += CompressedNumber.writeInt(out, this.id);
        if (this.hasOverflow()) {
            len += CompressedNumber.writeLong(out, this.overflowPage);
            len += CompressedNumber.writeInt(out, this.overflowId);
        }
        if (this.hasFirstField()) {
            len += CompressedNumber.writeInt(out, this.firstField);
        }
        if (!this.hasOverflow() || this.hasFirstField()) {
            len += CompressedNumber.writeInt(out, this.numberFields);
        }
        return len;
    }

    public void read(ObjectInput in) throws IOException {
        this.status = in.read();
        if (this.status < 0) {
            throw new EOFException();
        }
        if ((this.status & 0xFFFFFFF0) != 0) {
            SanityManager.THROWASSERT("Invalid status in StoredRecordHeader = " + this.status);
        }
        this.id = CompressedNumber.readInt(in);
        if (this.hasOverflow()) {
            this.overflowPage = CompressedNumber.readLong(in);
            this.overflowId = CompressedNumber.readInt(in);
        } else {
            this.overflowPage = 0L;
            this.overflowId = 0;
        }
        this.firstField = this.hasFirstField() ? CompressedNumber.readInt(in) : 0;
        this.numberFields = !this.hasOverflow() || this.hasFirstField() ? CompressedNumber.readInt(in) : 0;
        this.handle = null;
    }

    private int readId(byte[] data, int offset) {
        int value;
        if (((value = data[offset++]) & 0xFFFFFFC0) == 0) {
            this.id = value;
            return 1;
        }
        if ((value & 0x80) == 0) {
            this.id = (value & 0x3F) << 8 | data[offset] & 0xFF;
            return 2;
        }
        this.id = (value & 0x7F) << 24 | (data[offset++] & 0xFF) << 16 | (data[offset++] & 0xFF) << 8 | data[offset] & 0xFF;
        return 4;
    }

    private int readOverFlowPage(byte[] data, int offset) {
        byte int_value;
        if (((int_value = data[offset++]) & 0xFFFFFFC0) == 0) {
            this.overflowPage = int_value << 8 | data[offset] & 0xFF;
            return 2;
        }
        if ((int_value & 0x80) == 0) {
            this.overflowPage = (int_value & 0x3F) << 24 | (data[offset++] & 0xFF) << 16 | (data[offset++] & 0xFF) << 8 | data[offset] & 0xFF;
            return 4;
        }
        this.overflowPage = (long)(int_value & 0x7F) << 56 | (long)(data[offset++] & 0xFF) << 48 | (long)(data[offset++] & 0xFF) << 40 | (long)(data[offset++] & 0xFF) << 32 | (long)(data[offset++] & 0xFF) << 24 | (long)(data[offset++] & 0xFF) << 16 | (long)(data[offset++] & 0xFF) << 8 | (long)(data[offset] & 0xFF);
        return 8;
    }

    private int readOverFlowId(byte[] data, int offset) {
        int value;
        if (((value = data[offset++]) & 0xFFFFFFC0) == 0) {
            this.overflowId = value;
            return 1;
        }
        if ((value & 0x80) == 0) {
            this.overflowId = (value & 0x3F) << 8 | data[offset] & 0xFF;
            return 2;
        }
        this.overflowId = (value & 0x7F) << 24 | (data[offset++] & 0xFF) << 16 | (data[offset++] & 0xFF) << 8 | data[offset] & 0xFF;
        return 4;
    }

    private int readFirstField(byte[] data, int offset) {
        int value;
        if (((value = data[offset++]) & 0xFFFFFFC0) == 0) {
            this.firstField = value;
            return 1;
        }
        if ((value & 0x80) == 0) {
            this.firstField = (value & 0x3F) << 8 | data[offset] & 0xFF;
            return 2;
        }
        this.firstField = (value & 0x7F) << 24 | (data[offset++] & 0xFF) << 16 | (data[offset++] & 0xFF) << 8 | data[offset] & 0xFF;
        return 4;
    }

    private void readNumberFields(byte[] data, int offset) {
        int value;
        this.numberFields = ((value = data[offset++]) & 0xFFFFFFC0) == 0 ? value : ((value & 0x80) == 0 ? (value & 0x3F) << 8 | data[offset] & 0xFF : (value & 0x7F) << 24 | (data[offset++] & 0xFF) << 16 | (data[offset++] & 0xFF) << 8 | data[offset] & 0xFF);
    }

    private void read(byte[] data, int offset) {
        int value;
        this.status = data[offset++];
        this.id = ((value = data[offset++]) & 0xFFFFFFC0) == 0 ? value : ((value & 0x80) == 0 ? (value & 0x3F) << 8 | data[offset++] & 0xFF : (value & 0x7F) << 24 | (data[offset++] & 0xFF) << 16 | (data[offset++] & 0xFF) << 8 | data[offset++] & 0xFF);
        if ((this.status & 6) == 0) {
            this.overflowPage = 0L;
            this.overflowId = 0;
            this.firstField = 0;
            this.readNumberFields(data, offset);
        } else if ((this.status & 2) == 0) {
            this.overflowPage = 0L;
            this.overflowId = 0;
            offset += this.readFirstField(data, offset);
            this.readNumberFields(data, offset);
        } else {
            offset += this.readOverFlowPage(data, offset);
            offset += this.readOverFlowId(data, offset);
            if (this.hasFirstField()) {
                offset += this.readFirstField(data, offset);
                this.readNumberFields(data, offset);
            } else {
                this.firstField = 0;
                this.numberFields = 0;
            }
        }
        this.handle = null;
    }

    public String toString() {
        String str = "recordHeader: Id=" + this.getId();
        str = str + "\n  isDeleted     = " + this.isDeleted();
        str = str + "\n  hasOverflow   = " + this.hasOverflow();
        str = str + "\n  hasFirstField = " + this.hasFirstField();
        str = str + "\n  numberFields  = " + this.getNumberFields();
        str = str + "\n  firstField    = " + this.getFirstField();
        str = str + "\n  overflowPage  = " + this.getOverflowPage();
        str = str + "\n  overflowId    = " + this.getOverflowId();
        return str;
    }
}

