/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.util.Hashtable;
import org.apache.derby.iapi.services.locks.Latch;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.RowLock;

public final class RecordId
implements RecordHandle {
    private final PageKey pageId;
    private final int recordId;
    private transient int slotNumberHint;

    public RecordId(ContainerKey container, long pageNumber, int recordId) {
        this.pageId = new PageKey(container, pageNumber);
        this.recordId = recordId;
    }

    public RecordId(PageKey pageId, int recordId) {
        this.pageId = pageId;
        this.recordId = recordId;
    }

    public RecordId(PageKey pageId, int recordId, int current_slot) {
        this.pageId = pageId;
        this.recordId = recordId;
        this.slotNumberHint = current_slot;
    }

    public int getId() {
        return this.recordId;
    }

    public long getPageNumber() {
        return this.pageId.getPageNumber();
    }

    public Object getPageId() {
        return this.pageId;
    }

    public ContainerKey getContainerId() {
        return this.pageId.getContainerId();
    }

    public int getSlotNumberHint() {
        return this.slotNumberHint;
    }

    public void lockEvent(Latch lockInfo) {
    }

    public boolean requestCompatible(Object requestedQualifier, Object grantedQualifier) {
        SanityManager.ASSERT(requestedQualifier == RowLock.RS2 || requestedQualifier == RowLock.RS3 || requestedQualifier == RowLock.RU2 || requestedQualifier == RowLock.RU3 || requestedQualifier == RowLock.RIP || requestedQualifier == RowLock.RI || requestedQualifier == RowLock.RX2 || requestedQualifier == RowLock.RX3);
        SanityManager.ASSERT(grantedQualifier == RowLock.RS2 || grantedQualifier == RowLock.RS3 || grantedQualifier == RowLock.RU2 || grantedQualifier == RowLock.RU3 || grantedQualifier == RowLock.RIP || grantedQualifier == RowLock.RI || grantedQualifier == RowLock.RX2 || grantedQualifier == RowLock.RX3);
        RowLock rlRequested = (RowLock)requestedQualifier;
        RowLock rlGranted = (RowLock)grantedQualifier;
        return rlRequested.isCompatible(rlGranted);
    }

    public boolean lockerAlwaysCompatible() {
        return true;
    }

    public void unlockEvent(Latch lockInfo) {
    }

    public boolean equals(Object ref) {
        if (!(ref instanceof RecordId)) {
            return false;
        }
        RecordId other = (RecordId)ref;
        return this.recordId == other.recordId && this.pageId.equals(other.pageId);
    }

    public int hashCode() {
        return this.recordId ^ this.pageId.hashCode();
    }

    public String toString() {
        return "Record id=" + this.recordId + " " + this.pageId.toString();
    }

    public boolean lockAttributes(int flag, Hashtable attributes) {
        SanityManager.ASSERT(attributes != null, "cannot call lockProperties with null attribute list");
        SanityManager.ASSERT(this.pageId != null, "RecordId PageId is null");
        if ((flag & 2) == 0) {
            return false;
        }
        attributes.put("CONTAINERID", new Long(this.pageId.getContainerId().getContainerId()));
        attributes.put("LOCKNAME", "(" + this.pageId.getPageNumber() + "," + this.recordId + ")");
        attributes.put("TYPE", "ROW");
        return true;
    }
}

