/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.store.access.FileResource;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.impl.store.raw.data.BaseDataFileFactory;
import org.apache.derby.impl.store.raw.data.RemoveFile;
import org.apache.derby.impl.store.raw.data.RemoveFileOperation;
import org.apache.derby.io.StorageFile;

class RFResource
implements FileResource {
    private final BaseDataFileFactory factory;

    RFResource(BaseDataFileFactory dataFactory) {
        this.factory = dataFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long add(String name, InputStream source) throws StandardException {
        OutputStream os = null;
        if (this.factory.isReadOnly()) {
            throw StandardException.newException("XSDFB.S");
        }
        long generationId = this.factory.getNextId();
        try {
            StorageFile file = this.getAsFile(name, generationId);
            if (file.exists()) {
                throw StandardException.newException("XSDF0.S", file);
            }
            ContextManager cm = ContextService.getFactory().getCurrentContextManager();
            RawTransaction tran = this.factory.getRawStoreFactory().getXactFactory().findUserTransaction(this.factory.getRawStoreFactory(), cm, "UserTransaction");
            tran.blockBackup(true);
            StorageFile directory = file.getParentDir();
            if (!directory.exists() && !directory.mkdirs()) {
                throw StandardException.newException("XSDF3.S", directory);
            }
            os = file.getOutputStream();
            byte[] data = new byte[4096];
            this.factory.writeInProgress();
            try {
                int len;
                while ((len = source.read(data)) != -1) {
                    os.write(data, 0, len);
                }
                this.factory.writableStorageFactory.sync(os, false);
            }
            finally {
                this.factory.writeFinished();
            }
        }
        catch (IOException ioe) {
            throw StandardException.newException("XSDFF.S", ioe);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException ioe2) {}
            try {
                if (source != null) {
                    source.close();
                }
            }
            catch (IOException ioe2) {}
        }
        return generationId;
    }

    public void remove(String name, long currentGenerationId) throws StandardException {
        if (this.factory.isReadOnly()) {
            throw StandardException.newException("XSDFB.S");
        }
        ContextManager cm = ContextService.getFactory().getCurrentContextManager();
        RawTransaction tran = this.factory.getRawStoreFactory().getXactFactory().findUserTransaction(this.factory.getRawStoreFactory(), cm, "UserTransaction");
        tran.blockBackup(true);
        tran.logAndDo(new RemoveFileOperation(name, currentGenerationId, true));
        RemoveFile s = new RemoveFile(this.getAsFile(name, currentGenerationId));
        tran.addPostCommitWork(s);
    }

    public long replace(String name, long currentGenerationId, InputStream source) throws StandardException {
        if (this.factory.isReadOnly()) {
            throw StandardException.newException("XSDFB.S");
        }
        this.remove(name, currentGenerationId);
        long generationId = this.add(name, source);
        return generationId;
    }

    public StorageFile getAsFile(String name, long generationId) {
        String versionedFileName = this.factory.getVersionedName(name, generationId);
        return this.factory.storageFactory.newStorageFile(versionedFileName);
    }

    public char getSeparatorChar() {
        return this.factory.storageFactory.getSeparator();
    }
}

