/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.iapi.services.io.FormatIdUtil;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.impl.store.raw.data.BaseContainerHandle;
import org.apache.derby.impl.store.raw.data.BaseDataFileFactory;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.FileContainer;
import org.apache.derby.impl.store.raw.data.TempRAFContainer;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.StorageRandomAccessFile;

class RAFContainer
extends FileContainer
implements PrivilegedExceptionAction {
    protected StorageRandomAccessFile fileData;
    protected boolean needsSync;
    private int actionCode;
    private static final int GET_FILE_NAME_ACTION = 1;
    private static final int CREATE_CONTAINER_ACTION = 2;
    private static final int REMOVE_FILE_ACTION = 3;
    private static final int OPEN_CONTAINER_ACTION = 4;
    private static final int STUBBIFY_ACTION = 5;
    private static final int BACKUP_CONTAINER_ACTION = 6;
    private static final int GET_RANDOM_ACCESS_FILE_ACTION = 7;
    private ContainerKey actionIdentity;
    private boolean actionStub;
    private boolean actionErrorOK;
    private boolean actionTryAlternatePath;
    private StorageFile actionFile;
    private LogInstant actionInstant;
    private String actionBackupLocation;
    private BaseContainerHandle actionContainerHandle;
    private boolean inBackup = false;
    private boolean inRemove = false;

    RAFContainer(BaseDataFileFactory factory) {
        super(factory);
    }

    public synchronized boolean isDirty() {
        return super.isDirty() || this.needsSync;
    }

    public Cacheable setIdentity(Object key) throws StandardException {
        ContainerKey newIdentity = (ContainerKey)key;
        if (newIdentity.getSegmentId() == -1L) {
            TempRAFContainer tmpContainer = new TempRAFContainer(this.dataFactory);
            return tmpContainer.setIdent(newIdentity);
        }
        return this.setIdent(newIdentity);
    }

    public Cacheable createIdentity(Object key, Object createParameter) throws StandardException {
        ContainerKey newIdentity = (ContainerKey)key;
        if (newIdentity.getSegmentId() == -1L) {
            TempRAFContainer tmpContainer = new TempRAFContainer(this.dataFactory);
            return tmpContainer.createIdent(newIdentity, createParameter);
        }
        return this.createIdent(newIdentity, createParameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeContainer(LogInstant instant, boolean leaveStub) throws StandardException {
        RAFContainer rAFContainer;
        try {
            rAFContainer = this;
            synchronized (rAFContainer) {
                this.inRemove = true;
                while (this.inBackup) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ie) {
                        throw StandardException.interrupt(ie);
                    }
                }
            }
            this.pageCache.discard(this.identity);
            this.stubbify(instant);
        }
        finally {
            rAFContainer = this;
            synchronized (rAFContainer) {
                this.inRemove = false;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeContainer() {
        if (this.fileData != null) {
            try {
                this.fileData.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.fileData = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readPage(long pageNumber, byte[] pageData) throws IOException, StandardException {
        SanityManager.ASSERT(!this.getCommittedDropState());
        long pageOffset = pageNumber * (long)this.pageSize;
        RAFContainer rAFContainer = this;
        synchronized (rAFContainer) {
            this.fileData.seek(pageOffset);
            this.fileData.readFully(pageData, 0, this.pageSize);
        }
        if (this.dataFactory.databaseEncrypted() && pageNumber != 0L) {
            this.decryptPage(pageData, this.pageSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void writePage(long pageNumber, byte[] pageData, boolean syncPage) throws IOException, StandardException {
        RAFContainer rAFContainer = this;
        synchronized (rAFContainer) {
            if (this.getCommittedDropState()) {
                return;
            }
            long pageOffset = pageNumber * (long)this.pageSize;
            byte[] encryptionBuf = null;
            if (this.dataFactory.databaseEncrypted() && pageNumber != 0L) {
                encryptionBuf = this.getEncryptionBuffer();
            }
            byte[] dataToWrite = this.updatePageArray(pageNumber, pageData, encryptionBuf, false);
            try {
                this.fileData.seek(pageOffset);
                if (this.fileData.getFilePointer() != pageOffset) {
                    this.padFile(this.fileData, pageOffset);
                }
                this.dataFactory.writeInProgress();
                try {
                    this.fileData.write(dataToWrite, 0, this.pageSize);
                }
                finally {
                    this.dataFactory.writeFinished();
                }
            }
            catch (IOException ioe) {
                if (!this.padFile(this.fileData, pageOffset)) {
                    throw ioe;
                }
                SanityManager.ASSERT(this.fileData.length() >= pageOffset, "failed to blank filled missing pages");
                this.fileData.seek(pageOffset);
                this.dataFactory.writeInProgress();
                try {
                    this.fileData.write(dataToWrite, 0, this.pageSize);
                }
                finally {
                    this.dataFactory.writeFinished();
                }
            }
            if (syncPage) {
                this.dataFactory.writeInProgress();
                try {
                    if (this.dataFactory.dataNotSyncedAtAllocation) return;
                    this.fileData.sync(false);
                }
                finally {
                    this.dataFactory.writeFinished();
                }
            } else {
                this.needsSync = true;
            }
            return;
        }
    }

    protected byte[] updatePageArray(long pageNumber, byte[] pageData, byte[] encryptionBuf, boolean encryptWithNewEngine) throws StandardException, IOException {
        if (pageNumber == 0L) {
            this.writeHeader(pageData);
            if (FormatIdUtil.readFormatIdInteger(pageData) != 118) {
                SanityManager.THROWASSERT("expect 118got " + FormatIdUtil.readFormatIdInteger(pageData));
            }
            return pageData;
        }
        if (this.dataFactory.databaseEncrypted() || encryptWithNewEngine) {
            return this.encryptPage(pageData, this.pageSize, encryptionBuf, encryptWithNewEngine);
        }
        return pageData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean padFile(StorageRandomAccessFile file, long pageOffset) throws IOException, StandardException {
        long currentEOF = file.length();
        if (currentEOF >= pageOffset) {
            return false;
        }
        byte[] zero = new byte[this.pageSize];
        file.seek(currentEOF);
        while (currentEOF < pageOffset) {
            this.dataFactory.writeInProgress();
            try {
                long len = pageOffset - currentEOF;
                if (len > (long)this.pageSize) {
                    len = this.pageSize;
                }
                file.write(zero, 0, (int)len);
            }
            finally {
                this.dataFactory.writeFinished();
            }
            currentEOF += (long)this.pageSize;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean(boolean forRemove) throws StandardException {
        boolean waited = false;
        RAFContainer rAFContainer = this;
        synchronized (rAFContainer) {
            if (this.getCommittedDropState()) {
                this.clearDirty();
                return;
            }
            while (this.preDirty) {
                waited = true;
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    throw StandardException.interrupt(ie);
                }
            }
            if (waited && this.getCommittedDropState()) {
                this.clearDirty();
                return;
            }
            if (!forRemove && this.isDirty()) {
                try {
                    this.writeRAFHeader(this.fileData, false, true);
                    this.clearDirty();
                }
                catch (IOException ioe) {
                    throw this.dataFactory.markCorrupt(StandardException.newException("XSDG3.D", ioe, (Object)this));
                }
            }
        }
    }

    private void clearDirty() {
        this.isDirty = false;
        this.needsSync = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int preAllocate(long lastPreallocPagenum, int preAllocSize) {
        int n = this.doPreAllocatePages(lastPreallocPagenum, preAllocSize);
        if (n > 0) {
            RAFContainer rAFContainer = this;
            synchronized (rAFContainer) {
                boolean inwrite = false;
                try {
                    this.dataFactory.writeInProgress();
                    inwrite = true;
                    if (!this.dataFactory.dataNotSyncedAtAllocation) {
                        this.fileData.sync(false);
                    }
                }
                catch (IOException ioe) {
                    n = 0;
                }
                catch (StandardException se) {
                    n = 0;
                }
                finally {
                    if (inwrite) {
                        this.dataFactory.writeFinished();
                    }
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void truncatePages(long lastValidPagenum) throws StandardException {
        RAFContainer rAFContainer = this;
        synchronized (rAFContainer) {
            boolean inwrite = false;
            try {
                this.dataFactory.writeInProgress();
                inwrite = true;
                this.fileData.setLength((lastValidPagenum + 1L) * (long)this.pageSize);
            }
            catch (IOException ioe) {
            }
            catch (StandardException se) {
            }
            finally {
                if (inwrite) {
                    this.dataFactory.writeFinished();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRAFHeader(StorageRandomAccessFile file, boolean create, boolean syncFile) throws IOException, StandardException {
        byte[] epage;
        if (create) {
            epage = this.getEmbryonicPage(null);
        } else {
            file.seek(0L);
            epage = this.getEmbryonicPage(file);
        }
        file.seek(0L);
        this.writeHeader(file, create, epage);
        if (create) {
            this.padFile(file, this.pageSize);
        }
        if (syncFile) {
            this.dataFactory.writeInProgress();
            try {
                if (!this.dataFactory.dataNotSyncedAtCheckpoint) {
                    file.sync(false);
                }
            }
            finally {
                this.dataFactory.writeFinished();
            }
        }
        epage = null;
    }

    protected void flushAll() throws StandardException {
        this.pageCache.clean(this.identity);
        this.clean(false);
    }

    synchronized StorageFile getFileName(ContainerKey identity, boolean stub, boolean errorOK, boolean tryAlternatePath) throws StandardException {
        this.actionCode = 1;
        this.actionIdentity = identity;
        this.actionStub = stub;
        this.actionErrorOK = errorOK;
        this.actionTryAlternatePath = tryAlternatePath;
        try {
            StorageFile storageFile = (StorageFile)AccessController.doPrivileged(this);
            return storageFile;
        }
        catch (PrivilegedActionException pae) {
            throw (StandardException)pae.getException();
        }
        finally {
            this.actionIdentity = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StorageFile privGetFileName(ContainerKey identity, boolean stub, boolean errorOK, boolean tryAlternatePath) throws StandardException {
        StorageFile directory;
        StorageFile container = this.dataFactory.getContainerPath(identity, stub);
        if (!container.exists() && tryAlternatePath) {
            container = this.dataFactory.getAlternateContainerPath(identity, stub);
        }
        if (!container.exists() && !(directory = container.getParentDir()).exists()) {
            BaseDataFileFactory baseDataFileFactory = this.dataFactory;
            synchronized (baseDataFileFactory) {
                if (!directory.exists() && !directory.mkdirs()) {
                    if (errorOK) {
                        return null;
                    }
                    throw StandardException.newException("XSDF3.S", directory);
                }
            }
        }
        return container;
    }

    synchronized void createContainer(ContainerKey newIdentity) throws StandardException {
        if (this.spareSpace < 0 || this.spareSpace > 100) {
            SanityManager.THROWASSERT("invalid spare space " + this.spareSpace);
        }
        this.actionCode = 2;
        this.actionIdentity = newIdentity;
        try {
            AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException pae) {
            throw (StandardException)pae.getException();
        }
        finally {
            this.actionIdentity = null;
        }
    }

    synchronized boolean removeFile(StorageFile file) throws SecurityException, StandardException {
        this.actionCode = 3;
        this.actionFile = file;
        try {
            boolean bl = AccessController.doPrivileged(this) != null;
            return bl;
        }
        catch (PrivilegedActionException pae) {
            throw (StandardException)pae.getException();
        }
        finally {
            this.actionFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean privRemoveFile(StorageFile file) throws StandardException {
        this.closeContainer();
        this.dataFactory.writeInProgress();
        try {
            if (file.exists()) {
                boolean bl = file.delete();
                return bl;
            }
        }
        finally {
            this.dataFactory.writeFinished();
        }
        return true;
    }

    synchronized boolean openContainer(ContainerKey newIdentity) throws StandardException {
        this.actionCode = 4;
        this.actionIdentity = newIdentity;
        try {
            boolean bl = AccessController.doPrivileged(this) != null;
            return bl;
        }
        catch (PrivilegedActionException pae) {
            throw (StandardException)pae.getException();
        }
        finally {
            this.actionIdentity = null;
        }
    }

    private synchronized void stubbify(LogInstant instant) throws StandardException {
        this.setDroppedState(true);
        this.setCommittedDropState(true);
        this.actionIdentity = (ContainerKey)this.getIdentity();
        this.actionInstant = instant;
        this.actionCode = 5;
        try {
            AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException pae) {
            throw (StandardException)pae.getException();
        }
        finally {
            this.actionIdentity = null;
            this.actionInstant = null;
        }
    }

    protected void backupContainer(BaseContainerHandle handle, String backupLocation) throws StandardException {
        this.actionContainerHandle = handle;
        this.actionBackupLocation = backupLocation;
        this.actionCode = 6;
        try {
            AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException pae) {
            throw (StandardException)pae.getException();
        }
        finally {
            this.actionContainerHandle = null;
            this.actionBackupLocation = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void privBackupContainer(BaseContainerHandle handle, String backupLocation) throws StandardException {
        IOException ioe22;
        RAFContainer rAFContainer;
        Object var18_16;
        boolean backupCompleted = false;
        File backupFile = null;
        RandomAccessFile backupRaf = null;
        boolean isStub = false;
        BasePage page = null;
        while (!backupCompleted) {
            RAFContainer rAFContainer2 = this;
            // MONITORENTER : rAFContainer2
            while (this.inRemove) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    throw StandardException.interrupt(ie);
                }
            }
            if (this.getCommittedDropState()) {
                isStub = true;
            }
            this.inBackup = true;
            // MONITOREXIT : rAFContainer2
            if (isStub) {
                StorageFile file = this.privGetFileName((ContainerKey)this.getIdentity(), true, false, true);
                backupFile = new File(backupLocation, file.getName());
                if (!FileUtil.copyFile(this.dataFactory.getStorageFactory(), file, backupFile)) {
                    throw StandardException.newException("XSRS5.S", (Object)file, (Object)backupFile);
                }
            } else {
                long lastPageNumber = this.getLastPageNumber(handle);
                if (lastPageNumber == -1L) {
                    var18_16 = null;
                    rAFContainer = this;
                    // MONITORENTER : rAFContainer
                    this.inBackup = false;
                    this.notifyAll();
                    // MONITOREXIT : rAFContainer
                    if (page != null) {
                        page.unlatch();
                        page = null;
                    }
                    if (backupCompleted) return;
                    if (backupFile == null) return;
                    if (backupRaf != null) {
                        try {
                            backupRaf.close();
                            backupRaf = null;
                        }
                        catch (IOException ioe22) {
                            throw StandardException.newException("XSDFH.S", ioe22, (Object)backupFile);
                        }
                    }
                    if (!backupFile.exists()) return;
                    if (backupFile.delete()) return;
                    throw StandardException.newException("XBM0R.D", backupFile);
                }
                StorageFile file = this.privGetFileName((ContainerKey)this.getIdentity(), false, false, true);
                backupFile = new File(backupLocation, file.getName());
                backupRaf = new RandomAccessFile(backupFile, "rw");
                byte[] encryptionBuf = null;
                if (this.dataFactory.databaseEncrypted()) {
                    encryptionBuf = new byte[this.pageSize];
                }
                for (long pageNumber = 0L; pageNumber <= lastPageNumber; ++pageNumber) {
                    page = this.getLatchedPage(handle, pageNumber);
                    byte[] dataToWrite = this.updatePageArray(pageNumber, page.getPageArray(), encryptionBuf, false);
                    backupRaf.write(dataToWrite, 0, this.pageSize);
                    page.unlatch();
                    page = null;
                    RAFContainer rAFContainer3 = this;
                    // MONITORENTER : rAFContainer3
                    if (this.inRemove) {
                        // MONITOREXIT : rAFContainer3
                        break;
                    }
                    // MONITOREXIT : rAFContainer3
                }
            }
            if (!isStub) {
                backupRaf.getFD().sync();
                backupRaf.close();
                backupRaf = null;
            }
            backupCompleted = true;
            var18_16 = null;
            rAFContainer = this;
            // MONITORENTER : rAFContainer
            this.inBackup = false;
            this.notifyAll();
            // MONITOREXIT : rAFContainer
            if (page != null) {
                page.unlatch();
                page = null;
            }
            if (backupCompleted || backupFile == null) continue;
            if (backupRaf != null) {
                try {}
                catch (IOException ioe22) {
                    throw StandardException.newException("XSDFH.S", ioe22, (Object)backupFile);
                }
                backupRaf.close();
                backupRaf = null;
            }
            if (backupFile.exists() && !backupFile.delete()) throw StandardException.newException("XBM0R.D", backupFile);
        }
        return;
        {
            catch (IOException ioe3) {
                throw StandardException.newException("XSDFH.S", ioe3, backupFile);
            }
        }
        catch (Throwable throwable) {
            var18_16 = null;
            rAFContainer = this;
            // MONITORENTER : rAFContainer
            this.inBackup = false;
            this.notifyAll();
            // MONITOREXIT : rAFContainer
            if (page != null) {
                page.unlatch();
                page = null;
            }
            if (backupCompleted) throw throwable;
            if (backupFile == null) throw throwable;
            if (backupRaf != null) {
                try {}
                catch (IOException ioe22) {
                    throw StandardException.newException("XSDFH.S", ioe22, (Object)backupFile);
                }
                backupRaf.close();
                backupRaf = null;
            }
            if (!backupFile.exists()) throw throwable;
            if (backupFile.delete()) throw throwable;
            throw StandardException.newException("XBM0R.D", backupFile);
        }
    }

    protected void encryptContainer(BaseContainerHandle handle, String newFilePath) throws StandardException {
        BasePage page = null;
        StorageFile newFile = this.dataFactory.getStorageFactory().newStorageFile(newFilePath);
        StorageRandomAccessFile newRaf = null;
        try {
            long lastPageNumber = this.getLastPageNumber(handle);
            newRaf = this.privGetRandomAccessFile(newFile);
            byte[] encryptionBuf = null;
            encryptionBuf = new byte[this.pageSize];
            for (long pageNumber = 0L; pageNumber <= lastPageNumber; ++pageNumber) {
                page = this.getLatchedPage(handle, pageNumber);
                byte[] dataToWrite = this.updatePageArray(pageNumber, page.getPageArray(), encryptionBuf, true);
                newRaf.write(dataToWrite, 0, this.pageSize);
                page.unlatch();
                page = null;
            }
            newRaf.sync(true);
            newRaf.close();
            newRaf = null;
        }
        catch (IOException ioe) {
            throw StandardException.newException("XSDG3.D", ioe, (Object)newFile);
        }
        finally {
            if (page != null) {
                page.unlatch();
                page = null;
            }
            if (newRaf != null) {
                try {
                    newRaf.close();
                }
                catch (IOException ioe) {
                    newRaf = null;
                    throw StandardException.newException("XSDG3.D", ioe, (Object)newFile);
                }
            }
        }
    }

    synchronized StorageRandomAccessFile privGetRandomAccessFile(StorageFile file) throws SecurityException, StandardException {
        this.actionCode = 7;
        this.actionFile = file;
        try {
            StorageRandomAccessFile storageRandomAccessFile = (StorageRandomAccessFile)AccessController.doPrivileged(this);
            return storageRandomAccessFile;
        }
        catch (PrivilegedActionException pae) {
            throw (StandardException)pae.getException();
        }
        finally {
            this.actionFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object run() throws StandardException, IOException {
        switch (this.actionCode) {
            case 1: {
                return this.privGetFileName(this.actionIdentity, this.actionStub, this.actionErrorOK, this.actionTryAlternatePath);
            }
            case 2: {
                StorageFile file = this.privGetFileName(this.actionIdentity, false, false, false);
                try {
                    if (file.exists()) {
                        throw StandardException.newException("XSDF0.S", file);
                    }
                }
                catch (SecurityException se) {
                    throw StandardException.newException("XSDF1.S", se, (Object)file);
                }
                try {
                    this.dataFactory.writeInProgress();
                    try {
                        this.fileData = file.getRandomAccessFile("rw");
                    }
                    finally {
                        this.dataFactory.writeFinished();
                    }
                    this.writeRAFHeader(this.fileData, true, this.actionIdentity.getSegmentId() != -1L);
                }
                catch (SecurityException se) {
                    throw StandardException.newException("XSDF1.S", se, (Object)file);
                }
                catch (IOException ioe) {
                    boolean fileDeleted;
                    try {
                        fileDeleted = this.privRemoveFile(file);
                    }
                    catch (SecurityException se) {
                        throw StandardException.newException("XSDF2.S", ioe, (Object)file, (Object)se.toString());
                    }
                    if (!fileDeleted) {
                        throw StandardException.newException("XSDF2.S", ioe, (Object)file, (Object)ioe.toString());
                    }
                    throw StandardException.newException("XSDF1.S", ioe, (Object)file);
                }
                this.canUpdate = true;
                return null;
            }
            case 3: {
                return this.privRemoveFile(this.actionFile) ? this : null;
            }
            case 4: {
                boolean isStub = false;
                StorageFile file = this.privGetFileName(this.actionIdentity, false, true, true);
                if (file == null) {
                    return null;
                }
                try {
                    if (!file.exists()) {
                        file = this.privGetFileName(this.actionIdentity, true, true, true);
                        if (!file.exists()) {
                            return null;
                        }
                        isStub = true;
                    }
                }
                catch (SecurityException se) {
                    throw StandardException.newException("XSDA4.S", se);
                }
                this.canUpdate = false;
                try {
                    if (!this.dataFactory.isReadOnly() && file.canWrite()) {
                        this.canUpdate = true;
                    }
                }
                catch (SecurityException se) {
                    // empty catch block
                }
                try {
                    this.fileData = file.getRandomAccessFile(this.canUpdate ? "rw" : "r");
                    this.fileData.seek(0L);
                    this.readHeader(this.fileData);
                    if (isStub) {
                        SanityManager.ASSERT(this.getDroppedState() && this.getCommittedDropState(), "a stub failed to set drop state");
                    }
                }
                catch (IOException ioe) {
                    if (isStub) {
                        throw this.dataFactory.markCorrupt(StandardException.newException("XSDG3.D", ioe, (Object)this));
                    }
                    StorageFile stub = this.privGetFileName(this.actionIdentity, true, true, true);
                    if (stub.exists()) {
                        try {
                            boolean delete_status = this.privRemoveFile(file);
                            if (!delete_status) {
                                SanityManager.THROWASSERT("delete of file (" + file + ") failed.");
                            }
                            this.fileData = stub.getRandomAccessFile(this.canUpdate ? "rw" : "r");
                            this.readHeader(this.fileData);
                        }
                        catch (IOException ioe2) {
                            throw this.dataFactory.markCorrupt(StandardException.newException("XSDG3.D", ioe2, (Object)this));
                        }
                    }
                    throw this.dataFactory.markCorrupt(StandardException.newException("XSDG3.D", ioe, (Object)this));
                }
                return this;
            }
            case 5: {
                StorageFile file = this.privGetFileName(this.actionIdentity, false, false, true);
                StorageFile stub = this.privGetFileName(this.actionIdentity, true, false, false);
                StorageRandomAccessFile stubData = null;
                try {
                    if (!stub.exists()) {
                        stubData = stub.getRandomAccessFile("rw");
                        this.writeRAFHeader(stubData, true, true);
                        stubData.close();
                        stubData = null;
                    }
                    this.dataFactory.flush(this.actionInstant);
                    this.privRemoveFile(file);
                }
                catch (SecurityException se) {
                    throw StandardException.newException("XSDF4.S", se, (Object)file, (Object)se.toString());
                }
                catch (IOException ioe) {
                    try {
                        if (stubData != null) {
                            stubData.close();
                            stub.delete();
                            stubData = null;
                        }
                        if (this.fileData != null) {
                            this.fileData.close();
                            this.fileData = null;
                        }
                    }
                    catch (IOException ioe2) {
                        throw StandardException.newException("XSDF4.S", ioe2, (Object)file, (Object)ioe.toString());
                    }
                    catch (SecurityException se) {
                        throw StandardException.newException("XSDF4.S", se, (Object)file, (Object)stub);
                    }
                }
                this.dataFactory.stubFileToRemoveAfterCheckPoint(stub, this.actionInstant, this.getIdentity());
                return null;
            }
            case 6: {
                this.privBackupContainer(this.actionContainerHandle, this.actionBackupLocation);
                return null;
            }
            case 7: {
                return this.actionFile.getRandomAccessFile("rw");
            }
        }
        return null;
    }
}

