/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.InputStreamUtil;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.impl.store.raw.data.BaseContainerHandle;
import org.apache.derby.impl.store.raw.data.BaseDataFileFactory;
import org.apache.derby.impl.store.raw.data.FileContainer;
import org.apache.derby.io.StorageFile;

final class InputStreamContainer
extends FileContainer {
    private StorageFile containerPath;

    InputStreamContainer(BaseDataFileFactory factory) {
        super(factory);
        this.canUpdate = false;
    }

    final boolean openContainer(ContainerKey newIdentity) throws StandardException {
        FilterInputStream dis = null;
        try {
            InputStream is = null;
            this.containerPath = this.dataFactory.getContainerPath(newIdentity, false);
            try {
                is = this.containerPath.getInputStream();
            }
            catch (IOException ioe) {
                this.containerPath = this.dataFactory.getContainerPath(newIdentity, true);
                try {
                    is = this.getInputStream();
                }
                catch (IOException ioe2) {
                    this.containerPath = null;
                    boolean bl = false;
                    if (dis != null) {
                        try {
                            dis.close();
                        }
                        catch (IOException ioe3) {
                            // empty catch block
                        }
                    }
                    return bl;
                }
            }
            dis = new DataInputStream(is);
            this.readHeader((DataInput)((Object)dis));
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            throw StandardException.newException("XSDG3.D", ioe, (Object)this);
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    void closeContainer() {
        this.containerPath = null;
    }

    public final void clean(boolean forRemove) throws StandardException {
    }

    protected final int preAllocate(long lastPreallocPagenum, int preAllocSize) {
        return 0;
    }

    protected void truncatePages(long lastValidPagenum) {
    }

    void createContainer(ContainerKey newIdentity) throws StandardException {
    }

    protected final void removeContainer(LogInstant instant, boolean leaveStub) throws StandardException {
    }

    protected final void readPage(long pageNumber, byte[] pageData) throws IOException, StandardException {
        SanityManager.ASSERT(!this.getCommittedDropState());
        long pageOffset = pageNumber * (long)this.pageSize;
        this.readPositionedPage(pageOffset, pageData);
        if (this.dataFactory.databaseEncrypted() && pageNumber != 0L) {
            this.decryptPage(pageData, this.pageSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readPositionedPage(long pageOffset, byte[] pageData) throws IOException {
        InputStream is = null;
        try {
            is = this.getInputStream();
            InputStreamUtil.skipBytes(is, pageOffset);
            InputStreamUtil.readFully(is, pageData, 0, this.pageSize);
            is.close();
            is = null;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    protected final void writePage(long pageNumber, byte[] pageData, boolean syncPage) throws IOException, StandardException {
    }

    protected final void flushAll() {
    }

    protected InputStream getInputStream() throws IOException {
        return this.containerPath.getInputStream();
    }

    protected void backupContainer(BaseContainerHandle handle, String backupLocation) throws StandardException {
        throw StandardException.newException("XSAI3.S");
    }

    protected void encryptContainer(BaseContainerHandle handle, String newFilePath) throws StandardException {
        throw StandardException.newException("XSAI3.S");
    }
}

