/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.CacheManager;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.io.FormatIdUtil;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.impl.store.raw.data.BaseDataFileFactory;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.FileContainer;

public abstract class CachedPage
extends BasePage
implements Cacheable {
    protected boolean alreadyReadPage;
    protected byte[] pageData;
    protected boolean isDirty;
    protected boolean preDirty;
    protected int initialRowCount;
    private long containerRowCount;
    protected CacheManager pageCache;
    protected CacheManager containerCache;
    protected BaseDataFileFactory dataFactory;
    protected static final int PAGE_FORMAT_ID_SIZE = 4;
    public static final int WRITE_SYNC = 1;
    public static final int WRITE_NO_SYNC = 2;

    public final void setFactory(BaseDataFileFactory factory) {
        this.dataFactory = factory;
        this.pageCache = factory.getPageCache();
        this.containerCache = factory.getContainerCache();
    }

    protected void initialize() {
        super.initialize();
        this.isDirty = false;
        this.preDirty = false;
        this.initialRowCount = 0;
        this.containerRowCount = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cacheable setIdentity(Object key) throws StandardException {
        SanityManager.ASSERT(key instanceof PageKey);
        this.initialize();
        PageKey newIdentity = (PageKey)key;
        FileContainer myContainer = (FileContainer)this.containerCache.find(newIdentity.getContainerId());
        this.setContainerRowCount(myContainer.getEstimatedRowCount(0));
        try {
            if (!this.alreadyReadPage) {
                this.readPage(myContainer, newIdentity);
            } else {
                this.alreadyReadPage = false;
            }
            int fmtId = this.getTypeFormatId();
            int onPageFormatId = FormatIdUtil.readFormatIdInteger(this.pageData);
            if (fmtId != onPageFormatId) {
                Cacheable cacheable = this.changeInstanceTo(onPageFormatId, newIdentity).setIdentity(key);
                return cacheable;
            }
            this.initFromData(myContainer, newIdentity);
        }
        finally {
            this.containerCache.release(myContainer);
            myContainer = null;
        }
        this.fillInIdentity(newIdentity);
        this.initialRowCount = 0;
        return this;
    }

    public Cacheable createIdentity(Object key, Object createParameter) throws StandardException {
        SanityManager.ASSERT(key instanceof PageKey);
        this.initialize();
        PageKey newIdentity = (PageKey)key;
        int[] createArgs = (int[])createParameter;
        if (createArgs[0] == -1) {
            throw StandardException.newException("XSDB1.D", newIdentity);
        }
        if (createArgs[0] != this.getTypeFormatId()) {
            return this.changeInstanceTo(createArgs[0], newIdentity).createIdentity(key, createParameter);
        }
        this.initializeHeaders(5);
        this.createPage(newIdentity, createArgs);
        this.fillInIdentity(newIdentity);
        this.initialRowCount = 0;
        if ((createArgs[1] & 1) != 0 || (createArgs[1] & 2) != 0) {
            this.writePage(newIdentity, (createArgs[1] & 1) != 0);
        }
        if (SanityManager.DEBUG_ON(FileContainer.SPACE_TRACE)) {
            String syncFlag = (createArgs[1] & 1) != 0 ? "Write_Sync" : ((createArgs[1] & 2) != 0 ? "Write_NO_Sync" : "No_write");
            SanityManager.DEBUG(FileContainer.SPACE_TRACE, "creating new page " + newIdentity + " with " + syncFlag);
        }
        return this;
    }

    private CachedPage changeInstanceTo(int fid, PageKey newIdentity) throws StandardException {
        CachedPage realPage;
        try {
            realPage = (CachedPage)Monitor.newInstanceFromIdentifier(fid);
        }
        catch (StandardException se) {
            if (se.getSeverity() > 20000) {
                throw se;
            }
            throw StandardException.newException("XSDB1.D", se, (Object)newIdentity);
        }
        realPage.setFactory(this.dataFactory);
        if (this.pageData != null) {
            realPage.alreadyReadPage = true;
            realPage.usePageBuffer(this.pageData);
        }
        return realPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirty() {
        CachedPage cachedPage = this;
        synchronized (cachedPage) {
            return this.isDirty || this.preDirty;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActuallyDirty() {
        CachedPage cachedPage = this;
        synchronized (cachedPage) {
            return this.isDirty;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preDirty() {
        CachedPage cachedPage = this;
        synchronized (cachedPage) {
            if (!this.isDirty) {
                this.preDirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDirty() {
        CachedPage cachedPage = this;
        synchronized (cachedPage) {
            this.isDirty = true;
            this.preDirty = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseExclusive() {
        if (this.isDirty && !this.isOverflowPage() && this.containerRowCount / 8L < (long)this.recordCount()) {
            int posDelta;
            int currentRowCount = this.internalNonDeletedRecordCount();
            int delta = currentRowCount - this.initialRowCount;
            int n = posDelta = delta > 0 ? delta : -delta;
            if (this.containerRowCount / 8L < (long)posDelta) {
                FileContainer myContainer = null;
                try {
                    myContainer = (FileContainer)this.containerCache.find(this.identity.getContainerId());
                    if (myContainer != null) {
                        myContainer.updateEstimatedRowCount(delta);
                        this.setContainerRowCount(myContainer.getEstimatedRowCount(0));
                        this.initialRowCount = currentRowCount;
                        myContainer.trackUnfilledPage(this.identity.getPageNumber(), this.unfilled());
                    }
                }
                catch (StandardException se) {
                }
                finally {
                    if (myContainer != null) {
                        this.containerCache.release(myContainer);
                    }
                }
            }
        }
        super.releaseExclusive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean(boolean remove) throws StandardException {
        CachedPage cachedPage = this;
        synchronized (cachedPage) {
            if (!this.isDirty()) {
                return;
            }
            while (this.inClean) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    throw StandardException.interrupt(ie);
                }
            }
            if (!this.isDirty()) {
                return;
            }
            this.inClean = true;
            while (this.owner != null && !this.preLatch) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    this.inClean = false;
                    throw StandardException.interrupt(ie);
                }
            }
            if (!this.isActuallyDirty()) {
                this.preDirty = false;
                this.inClean = false;
                this.notifyAll();
                return;
            }
        }
        try {
            this.writePage(this.getPageId(), false);
        }
        catch (StandardException se) {
            throw this.dataFactory.markCorrupt(se);
        }
        finally {
            CachedPage cachedPage2 = this;
            synchronized (cachedPage2) {
                this.inClean = false;
                this.notifyAll();
            }
        }
    }

    public void clearIdentity() {
        this.alreadyReadPage = false;
        super.clearIdentity();
    }

    private void readPage(FileContainer myContainer, PageKey newIdentity) throws StandardException {
        int pagesize = myContainer.getPageSize();
        this.setPageArray(pagesize);
        int io_retry_count = 0;
        while (true) {
            try {
                myContainer.readPage(newIdentity.getPageNumber(), this.pageData);
            }
            catch (IOException ioe) {
                if (++io_retry_count <= 4) continue;
                StandardException se = StandardException.newException("XSDG0.D", ioe, (Object)newIdentity, (Object)new Integer(pagesize));
                if (this.dataFactory.getLogFactory().inRFR()) {
                    throw se;
                }
                throw this.dataFactory.markCorrupt(se);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writePage(PageKey identity, boolean syncMe) throws StandardException {
        block10: {
            FileContainer myContainer;
            this.writeFormatId(identity);
            this.writePage(identity);
            LogInstant flushLogTo = this.getLastLogInstant();
            this.dataFactory.flush(flushLogTo);
            if (flushLogTo != null) {
                this.clearLastLogInstant();
            }
            if ((myContainer = (FileContainer)this.containerCache.find(identity.getContainerId())) == null) {
                StandardException nested = StandardException.newException("40XD2", identity.getContainerId());
                throw this.dataFactory.markCorrupt(StandardException.newException("XSDG1.D", nested, (Object)identity, (Object)new Integer(myContainer.getPageSize())));
            }
            try {
                myContainer.writePage(identity.getPageNumber(), this.pageData, syncMe);
                if (this.isOverflowPage() || !this.isDirty()) break block10;
                myContainer.trackUnfilledPage(identity.getPageNumber(), this.unfilled());
                int currentRowCount = this.internalNonDeletedRecordCount();
                if (currentRowCount != this.initialRowCount) {
                    myContainer.updateEstimatedRowCount(currentRowCount - this.initialRowCount);
                    this.setContainerRowCount(myContainer.getEstimatedRowCount(0));
                    this.initialRowCount = currentRowCount;
                }
            }
            catch (IOException ioe) {
                throw StandardException.newException("XSDG1.D", ioe, (Object)identity, (Object)new Integer(myContainer.getPageSize()));
            }
            finally {
                this.containerCache.release(myContainer);
                myContainer = null;
            }
        }
        CachedPage cachedPage = this;
        synchronized (cachedPage) {
            this.isDirty = false;
            this.preDirty = false;
            return;
        }
    }

    public void setContainerRowCount(long rowCount) {
        this.containerRowCount = rowCount;
    }

    protected void setPageArray(int pageSize) {
        if (this.pageData == null || this.pageData.length != pageSize) {
            this.pageData = null;
            this.pageData = new byte[pageSize];
            this.usePageBuffer(this.pageData);
        }
    }

    protected byte[] getPageArray() throws StandardException {
        this.writeFormatId(this.identity);
        this.writePage(this.identity);
        return this.pageData;
    }

    protected abstract void usePageBuffer(byte[] var1);

    protected abstract void initFromData(FileContainer var1, PageKey var2) throws StandardException;

    protected abstract void createPage(PageKey var1, int[] var2) throws StandardException;

    protected abstract void writePage(PageKey var1) throws StandardException;

    protected abstract void writeFormatId(PageKey var1) throws StandardException;
}

