/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import org.apache.derby.impl.store.raw.data.ByteHolder;
import org.apache.derby.impl.store.raw.data.ByteHolderInputStream;

public abstract class BufferedByteHolderInputStream
extends ByteHolderInputStream {
    public BufferedByteHolderInputStream(ByteHolder bh) {
        super(bh);
    }

    public abstract void fillByteHolder() throws IOException;

    public int read() throws IOException {
        this.fillByteHolder();
        return super.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.fillByteHolder();
        return super.read(b, off, len);
    }

    public long skip(long count) throws IOException {
        long bytesSkipped;
        long skipped;
        for (bytesSkipped = 0L; bytesSkipped < count; bytesSkipped += skipped) {
            this.fillByteHolder();
            skipped = super.skip(count - bytesSkipped);
            if (skipped <= 0L) break;
        }
        return bytesSkipped;
    }

    public int available() throws IOException {
        this.fillByteHolder();
        return super.available();
    }
}

