/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.CacheFactory;
import org.apache.derby.iapi.services.cache.CacheManager;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.cache.CacheableFactory;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.daemon.DaemonService;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.info.ProductVersionHolder;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.monitor.PersistentService;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.services.stream.HeaderPrintWriter;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.store.access.FileResource;
import org.apache.derby.iapi.store.access.RowSource;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.StreamContainerHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.data.DataFactory;
import org.apache.derby.iapi.store.raw.data.RawContainerHandle;
import org.apache.derby.iapi.store.raw.log.LogFactory;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.iapi.util.CheapDateFormatter;
import org.apache.derby.iapi.util.PrivilegedFileOps;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.store.raw.data.AllocationActions;
import org.apache.derby.impl.store.raw.data.BaseContainerHandle;
import org.apache.derby.impl.store.raw.data.ContainerOperation;
import org.apache.derby.impl.store.raw.data.DirectActions;
import org.apache.derby.impl.store.raw.data.DirectAllocActions;
import org.apache.derby.impl.store.raw.data.EncryptData;
import org.apache.derby.impl.store.raw.data.FileContainer;
import org.apache.derby.impl.store.raw.data.InputStreamContainer;
import org.apache.derby.impl.store.raw.data.LoggableActions;
import org.apache.derby.impl.store.raw.data.LoggableAllocActions;
import org.apache.derby.impl.store.raw.data.PageActions;
import org.apache.derby.impl.store.raw.data.RAFContainer;
import org.apache.derby.impl.store.raw.data.RFResource;
import org.apache.derby.impl.store.raw.data.ReclaimSpace;
import org.apache.derby.impl.store.raw.data.ReclaimSpaceHelper;
import org.apache.derby.impl.store.raw.data.StoredPage;
import org.apache.derby.impl.store.raw.data.StreamFileContainer;
import org.apache.derby.impl.store.raw.data.StreamFileContainerHandle;
import org.apache.derby.impl.store.raw.data.TempRAFContainer;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.StorageRandomAccessFile;
import org.apache.derby.io.WritableStorageFactory;

public class BaseDataFileFactory
implements DataFactory,
CacheableFactory,
ModuleControl,
ModuleSupportable,
PrivilegedExceptionAction {
    StorageFactory storageFactory;
    WritableStorageFactory writableStorageFactory;
    private long nextContainerId = System.currentTimeMillis();
    private boolean databaseEncrypted;
    private CacheManager pageCache;
    private CacheManager containerCache;
    private LogFactory logFactory;
    private ProductVersionHolder jbmsVersion;
    private RawStoreFactory rawStoreFactory;
    private String dataDirectory;
    private boolean throwDBlckException;
    private UUID identifier;
    private Object freezeSemaphore;
    private boolean isFrozen;
    private int writersInProgress;
    private boolean removeStubsOK;
    private boolean isCorrupt;
    private boolean inCreateNoLog;
    private StorageRandomAccessFile fileLockOnDB;
    private StorageFile exFileLock;
    private HeaderPrintWriter istream;
    private static final String LINE = "----------------------------------------------------------------";
    boolean dataNotSyncedAtAllocation = true;
    boolean dataNotSyncedAtCheckpoint = false;
    private PageActions loggablePageActions;
    private AllocationActions loggableAllocActions;
    private boolean readOnly;
    private boolean supportsRandomAccess;
    private FileResource fileHandler;
    private Hashtable droppedTableStubInfo;
    private Hashtable postRecoveryRemovedFiles;
    private EncryptData containerEncrypter;
    private int actionCode;
    private static final int GET_TEMP_DIRECTORY_ACTION = 1;
    private static final int REMOVE_TEMP_DIRECTORY_ACTION = 2;
    private static final int GET_CONTAINER_PATH_ACTION = 3;
    private static final int GET_ALTERNATE_CONTAINER_PATH_ACTION = 4;
    private static final int FIND_MAX_CONTAINER_ID_ACTION = 5;
    private static final int DELETE_IF_EXISTS_ACTION = 6;
    private static final int GET_PATH_ACTION = 7;
    private static final int POST_RECOVERY_REMOVE_ACTION = 8;
    private static final int REMOVE_STUBS_ACTION = 9;
    private static final int BOOT_ACTION = 10;
    private static final int GET_LOCK_ON_DB_ACTION = 11;
    private static final int RELEASE_LOCK_ON_DB_ACTION = 12;
    private static final int RESTORE_DATA_DIRECTORY_ACTION = 13;
    private static final int GET_CONTAINER_NAMES_ACTION = 14;
    private ContainerKey containerId;
    private boolean stub;
    private StorageFile actionFile;
    private UUID myUUID;
    private UUIDFactory uuidFactory;
    private String databaseDirectory;
    private String backupPath;
    private File backupRoot;
    private String[] bfilelist;

    public boolean canSupport(Properties startParams) {
        String serviceType = startParams.getProperty("derby.__rt.serviceType");
        if (serviceType == null) {
            return false;
        }
        if (!this.handleServiceType(serviceType)) {
            return false;
        }
        return startParams.getProperty("derby.__rt.serviceDirectory") != null;
    }

    public void boot(boolean create, Properties startParams) throws StandardException {
        this.jbmsVersion = Monitor.getMonitor().getEngineVersion();
        this.dataDirectory = startParams.getProperty("derby.__rt.serviceDirectory");
        UUIDFactory uf = Monitor.getMonitor().getUUIDFactory();
        this.identifier = uf.createUUID();
        PersistentService ps = Monitor.getMonitor().getServiceType(this);
        try {
            this.storageFactory = ps.getStorageFactoryInstance(true, this.dataDirectory, startParams.getProperty("derby.storage.tempDirectory", PropertyUtil.getSystemProperty("derby.storage.tempDirectory")), this.identifier.toANSIidentifier());
        }
        catch (IOException ioe) {
            if (create) {
                throw StandardException.newException("XBM0H.D", ioe, (Object)this.dataDirectory);
            }
            throw StandardException.newException("XJ004.C", ioe, (Object)this.dataDirectory);
        }
        if (this.storageFactory instanceof WritableStorageFactory) {
            this.writableStorageFactory = (WritableStorageFactory)this.storageFactory;
        }
        this.actionCode = 10;
        try {
            AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException pae) {
            // empty catch block
        }
        String value = startParams.getProperty("derby.database.forceDatabaseLock", PropertyUtil.getSystemProperty("derby.database.forceDatabaseLock"));
        this.throwDBlckException = Boolean.valueOf(value != null ? value.trim() : value);
        if (!this.isReadOnly()) {
            this.getJBMSLockOnDB(this.identifier, uf, this.dataDirectory);
        }
        String restoreFrom = null;
        restoreFrom = startParams.getProperty("createFrom");
        if (restoreFrom == null) {
            restoreFrom = startParams.getProperty("restoreFrom");
        }
        if (restoreFrom == null) {
            restoreFrom = startParams.getProperty("rollForwardRecoveryFrom");
        }
        if (restoreFrom != null) {
            try {
                String dataEncryption = startParams.getProperty("dataEncryption");
                this.databaseEncrypted = Boolean.valueOf(dataEncryption);
                this.restoreDataDirectory(restoreFrom);
            }
            catch (StandardException se) {
                this.releaseJBMSLockOnDB();
                throw se;
            }
        }
        this.logMsg(LINE);
        long bootTime = System.currentTimeMillis();
        String readOnlyMsg = this.isReadOnly() ? MessageService.getTextMessage("D014") : "";
        this.logMsg(CheapDateFormatter.formatDate(bootTime) + MessageService.getTextMessage("D001", this.jbmsVersion, this.identifier, this.dataDirectory, readOnlyMsg));
        uf = null;
        CacheFactory cf = (CacheFactory)Monitor.startSystemModule("org.apache.derby.iapi.services.cache.CacheFactory");
        int pageCacheSize = this.getIntParameter("derby.storage.pageCacheSize", null, 1000, 40, Integer.MAX_VALUE);
        this.pageCache = cf.newCacheManager(this, "PageCache", pageCacheSize / 2, pageCacheSize);
        int fileCacheSize = this.getIntParameter("derby.storage.fileCacheSize", null, 100, 2, 100);
        this.containerCache = cf.newCacheManager(this, "ContainerCache", fileCacheSize / 2, fileCacheSize);
        if (create) {
            String noLog = startParams.getProperty("derby.__rt.storage.createWithNoLog");
            this.inCreateNoLog = noLog != null && Boolean.valueOf(noLog) != false;
        }
        this.freezeSemaphore = new Object();
        this.droppedTableStubInfo = new Hashtable();
        if ("test".equalsIgnoreCase(PropertyUtil.getSystemProperty("derby.system.durability"))) {
            this.dataNotSyncedAtCheckpoint = true;
            Monitor.logMessage(MessageService.getTextMessage("D013", "derby.system.durability", "test"));
        }
        this.fileHandler = new RFResource(this);
    }

    public void stop() {
        DaemonService rawStoreDaemon;
        boolean OK = false;
        if (this.rawStoreFactory != null && (rawStoreDaemon = this.rawStoreFactory.getDaemon()) != null) {
            rawStoreDaemon.stop();
        }
        long shutdownTime = System.currentTimeMillis();
        this.logMsg("\n" + CheapDateFormatter.formatDate(shutdownTime) + MessageService.getTextMessage("D002", this.getIdentifier()));
        this.istream.println(LINE);
        if (!this.isCorrupt) {
            try {
                if (this.pageCache != null && this.containerCache != null) {
                    this.pageCache.shutdown();
                    this.containerCache.shutdown();
                    OK = true;
                }
            }
            catch (StandardException se) {
                se.printStackTrace(this.istream.getPrintWriter());
            }
        }
        this.removeTempDirectory();
        if (this.isReadOnly()) {
            this.storageFactory.shutdown();
            return;
        }
        if (this.removeStubsOK && OK) {
            this.removeStubs();
        }
        this.releaseJBMSLockOnDB();
        this.writableStorageFactory.shutdown();
    }

    public Cacheable newCacheable(CacheManager cm) {
        if (cm == this.pageCache) {
            StoredPage sp = new StoredPage();
            sp.setFactory(this);
            return sp;
        }
        return this.newContainerObject();
    }

    public void createFinished() throws StandardException {
        if (!this.inCreateNoLog) {
            throw StandardException.newException("XSDG5.D");
        }
        this.checkpoint();
        this.inCreateNoLog = false;
    }

    public ContainerHandle openContainer(RawTransaction t, ContainerKey containerId, LockingPolicy locking, int mode) throws StandardException {
        return this.openContainer(t, containerId, locking, mode, false);
    }

    public RawContainerHandle openDroppedContainer(RawTransaction t, ContainerKey containerId, LockingPolicy locking, int mode) throws StandardException {
        return this.openContainer(t, containerId, locking, mode |= 0x400, true);
    }

    private RawContainerHandle openContainer(RawTransaction t, ContainerKey identity, LockingPolicy locking, int mode, boolean droppedOK) throws StandardException {
        boolean waitForLock;
        if ((mode & 0xC) == 12) {
            SanityManager.THROWASSERT("update and readonly mode specified");
        }
        boolean bl = waitForLock = (mode & 0x80) == 0;
        if ((mode & 0x40) != 0) {
            BaseContainerHandle lockOnlyHandle = new BaseContainerHandle(this.getIdentifier(), t, identity, locking, mode);
            if (lockOnlyHandle.useContainer(true, waitForLock)) {
                return lockOnlyHandle;
            }
            return null;
        }
        FileContainer container = (FileContainer)this.containerCache.find(identity);
        if (container == null) {
            return null;
        }
        if (identity.getSegmentId() == -1L) {
            SanityManager.ASSERT(container instanceof TempRAFContainer);
            mode = (mode & 0x800) == 2048 ? (mode |= 1) : (mode |= 0x101);
            locking = t.newLockingPolicy(0, 0, true);
        } else {
            if (this.inCreateNoLog) {
                mode |= 3;
            } else if (this.logFactory.logArchived()) {
                mode &= 0xFFFFFFFC;
            } else if (!((mode & 1) != 1 && (mode & 2) != 2 || t.blockBackup(false))) {
                mode &= 0xFFFFFFFC;
            }
            if ((mode & 1) == 1 && (mode & 2) == 0) {
                mode |= 0x200;
            }
        }
        PageActions pageActions = null;
        AllocationActions allocActions = null;
        if ((mode & 4) == 4) {
            if ((mode & 1) == 0) {
                pageActions = this.getLoggablePageActions();
                allocActions = this.getLoggableAllocationActions();
            } else {
                pageActions = new DirectActions();
                allocActions = new DirectAllocActions();
            }
        }
        BaseContainerHandle c = new BaseContainerHandle(this.getIdentifier(), t, pageActions, allocActions, locking, container, mode);
        try {
            if (!c.useContainer(droppedOK, waitForLock)) {
                this.containerCache.release(container);
                return null;
            }
        }
        catch (StandardException se) {
            this.containerCache.release(container);
            throw se;
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long addContainer(RawTransaction t, long segmentId, long input_containerid, int mode, Properties tableProperties, int temporaryFlag) throws StandardException {
        if ((mode & 2) != 0) {
            SanityManager.ASSERT((mode & 1) != 0, "cannot have CREATE_UNLOGGED set but UNLOGGED not set");
        }
        long containerId = input_containerid != 0L ? input_containerid : this.getNextId();
        ContainerKey identity = new ContainerKey(segmentId, containerId);
        boolean tmpContainer = segmentId == -1L;
        ContainerHandle ch = null;
        LockingPolicy cl = null;
        if (!tmpContainer) {
            if (this.isReadOnly()) {
                throw StandardException.newException("40XD1");
            }
            cl = t.newLockingPolicy(2, 5, true);
            SanityManager.ASSERT(cl != null);
            ch = t.openContainer(identity, cl, 68);
        }
        FileContainer container = (FileContainer)this.containerCache.create(identity, tableProperties);
        ContainerHandle containerHdl = null;
        Page firstPage = null;
        try {
            if (tmpContainer && (temporaryFlag & 2) == 2) {
                mode |= 0x800;
            }
            SanityManager.ASSERT((containerHdl = t.openContainer(identity, null, 4 | mode)) != null);
            if (!tmpContainer) {
                RawContainerHandle rch = (RawContainerHandle)containerHdl;
                ContainerOperation lop = new ContainerOperation(rch, 1);
                rch.preDirty(true);
                try {
                    t.logAndDo(lop);
                    this.flush(t.getLastLogInstant());
                }
                finally {
                    rch.preDirty(false);
                }
            }
            firstPage = containerHdl.addPage();
        }
        finally {
            if (firstPage != null) {
                firstPage.unlatch();
                firstPage = null;
            }
            this.containerCache.release(container);
            if (containerHdl != null) {
                containerHdl.close();
                containerHdl = null;
            }
            if (!tmpContainer) {
                cl.unlockContainer(t, ch);
            }
        }
        return containerId;
    }

    public long addAndLoadStreamContainer(RawTransaction t, long segmentId, Properties tableProperties, RowSource rowSource) throws StandardException {
        long containerId = this.getNextId();
        ContainerKey identity = new ContainerKey(segmentId, containerId);
        StreamFileContainer sContainer = new StreamFileContainer(identity, this, tableProperties);
        sContainer.load(rowSource);
        return containerId;
    }

    public StreamContainerHandle openStreamContainer(RawTransaction t, long segmentId, long containerId, boolean hold) throws StandardException {
        ContainerKey identity = new ContainerKey(segmentId, containerId);
        StreamFileContainer container = new StreamFileContainer(identity, this);
        if ((container = container.open(false)) == null) {
            return null;
        }
        StreamFileContainerHandle c = new StreamFileContainerHandle(this.getIdentifier(), t, container, hold);
        if (c.useContainer()) {
            return c;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropStreamContainer(RawTransaction t, long segmentId, long containerId) throws StandardException {
        boolean tmpContainer = segmentId == -1L;
        StreamContainerHandle containerHdl = null;
        try {
            ContainerKey ckey = new ContainerKey(segmentId, containerId);
            t.notifyObservers(ckey);
            containerHdl = t.openStreamContainer(segmentId, containerId, false);
            if (tmpContainer && containerHdl != null) {
                containerHdl.removeContainer();
                return;
            }
        }
        finally {
            if (containerHdl != null) {
                containerHdl.close();
            }
        }
    }

    public void reCreateContainerForRedoRecovery(RawTransaction t, long segmentId, long containerId, ByteArray containerInfo) throws StandardException {
        SanityManager.ASSERT(segmentId != -1L, "Cannot recreate temp container during load tran");
        ContainerKey identity = new ContainerKey(segmentId, containerId);
        FileContainer container = (FileContainer)this.containerCache.create(identity, containerInfo);
        this.containerCache.release(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropContainer(RawTransaction t, ContainerKey ckey) throws StandardException {
        block15: {
            boolean tmpContainer = ckey.getSegmentId() == -1L;
            LockingPolicy cl = null;
            if (!tmpContainer) {
                if (this.isReadOnly()) {
                    throw StandardException.newException("40XD1");
                }
                cl = t.newLockingPolicy(2, 5, true);
                SanityManager.ASSERT(cl != null);
            }
            t.notifyObservers(ckey);
            RawContainerHandle containerHdl = (RawContainerHandle)t.openContainer(ckey, cl, 4);
            try {
                if (containerHdl == null || containerHdl.getContainerStatus() != 1) {
                    if (tmpContainer) {
                        if (containerHdl != null) {
                            containerHdl.removeContainer(null);
                        }
                        return;
                    }
                    throw StandardException.newException("40XD2", ckey);
                }
                if (tmpContainer) {
                    containerHdl.dropContainer(null, true);
                    containerHdl.removeContainer(null);
                    break block15;
                }
                ContainerOperation lop = new ContainerOperation(containerHdl, 2);
                containerHdl.preDirty(true);
                try {
                    t.logAndDo(lop);
                }
                finally {
                    containerHdl.preDirty(false);
                }
                ReclaimSpace p = new ReclaimSpace(1, ckey, (DataFactory)this, true);
                if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
                    SanityManager.DEBUG(DaemonService.DaemonTrace, "Add post commit work " + p);
                }
                t.addPostCommitWork(p);
            }
            finally {
                if (containerHdl != null) {
                    containerHdl.close();
                }
            }
        }
    }

    public void checkpoint() throws StandardException {
        this.pageCache.cleanAll();
        this.containerCache.cleanAll();
    }

    public void idle() throws StandardException {
        this.pageCache.ageOut();
        this.containerCache.ageOut();
    }

    public void setRawStoreFactory(RawStoreFactory rsf, boolean create, Properties startParams) throws StandardException {
        this.rawStoreFactory = rsf;
        this.bootLogFactory(create, startParams);
    }

    public UUID getIdentifier() {
        return this.identifier;
    }

    public int reclaimSpace(Serviceable work, ContextManager contextMgr) throws StandardException {
        if (work == null) {
            return 1;
        }
        Transaction tran = this.rawStoreFactory.findUserTransaction(contextMgr, "SystemTransaction");
        SanityManager.ASSERT(tran != null, "null transaction");
        if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
            SanityManager.DEBUG(DaemonService.DaemonTrace, "Performing post commit work " + work);
        }
        return ReclaimSpaceHelper.reclaimSpace(this, (RawTransaction)tran, (ReclaimSpace)work);
    }

    public StandardException markCorrupt(StandardException originalError) {
        boolean firsttime = !this.isCorrupt;
        this.isCorrupt = true;
        if (this.getLogFactory() != null) {
            this.getLogFactory().markCorrupt(originalError);
        }
        if (firsttime) {
            if (this.pageCache != null) {
                this.pageCache.discard(null);
            }
            if (this.containerCache != null) {
                this.containerCache.discard(null);
            }
            this.pageCache = null;
            this.containerCache = null;
            this.releaseJBMSLockOnDB();
        }
        return originalError;
    }

    public FileResource getFileHandler() {
        return this.fileHandler;
    }

    public void removeStubsOK() {
        this.removeStubsOK = true;
    }

    public int getIntParameter(String parameterName, Properties properties, int defaultValue, int minimumValue, int maximumValue) {
        String parameter = null;
        if (properties != null) {
            parameter = properties.getProperty(parameterName);
        }
        if (parameter == null) {
            parameter = PropertyUtil.getSystemProperty(parameterName);
        }
        if (parameter != null) {
            try {
                int newValue = Integer.parseInt(parameter);
                if (newValue >= minimumValue && newValue <= maximumValue) {
                    return newValue;
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    CacheManager getContainerCache() {
        return this.containerCache;
    }

    CacheManager getPageCache() {
        return this.pageCache;
    }

    public long[] getCacheStats(String cacheName) {
        if (cacheName == null) {
            return this.getPageCache().getCacheStats();
        }
        if (cacheName.equals("pageCache")) {
            return this.getPageCache().getCacheStats();
        }
        return this.getPageCache().getCacheStats();
    }

    public void resetCacheStats(String cacheName) {
        if (cacheName == null) {
            this.getPageCache().resetCacheStats();
            return;
        }
        if (cacheName.equals("pageCache")) {
            this.getPageCache().resetCacheStats();
        } else {
            this.getPageCache().resetCacheStats();
        }
    }

    void flush(LogInstant instant) throws StandardException {
        this.getLogFactory().flush(instant);
    }

    private void syncSideLog(long bipLocation) throws StandardException {
    }

    LogFactory getLogFactory() {
        return this.logFactory;
    }

    RawStoreFactory getRawStoreFactory() {
        return this.rawStoreFactory;
    }

    public String getRootDirectory() {
        return this.dataDirectory;
    }

    Cacheable newContainerObject() {
        if (this.supportsRandomAccess) {
            return this.newRAFContainer(this);
        }
        return new InputStreamContainer(this);
    }

    protected Cacheable newRAFContainer(BaseDataFileFactory factory) {
        return new RAFContainer(factory);
    }

    private void pageToDirty(RawTransaction t, StoredPage page) throws StandardException {
    }

    private PageActions getLoggablePageActions() throws StandardException {
        if (this.loggablePageActions == null) {
            this.loggablePageActions = new LoggableActions();
        }
        return this.loggablePageActions;
    }

    private AllocationActions getLoggableAllocationActions() {
        if (this.loggableAllocActions == null) {
            this.loggableAllocActions = new LoggableAllocActions();
        }
        return this.loggableAllocActions;
    }

    synchronized StorageFile getTempDirectory() {
        this.actionCode = 1;
        try {
            return (StorageFile)AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException pae) {
            return null;
        }
    }

    private synchronized void removeTempDirectory() {
        if (this.storageFactory != null) {
            this.actionCode = 2;
            try {
                AccessController.doPrivileged(this);
            }
            catch (PrivilegedActionException privilegedActionException) {
                // empty catch block
            }
        }
    }

    public StorageFile getContainerPath(ContainerKey containerId, boolean stub) {
        return this.getContainerPath(containerId, stub, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized StorageFile getContainerPath(ContainerKey containerId, boolean stub, int code) {
        this.actionCode = code;
        try {
            this.containerId = containerId;
            this.stub = stub;
            try {
                StorageFile storageFile = (StorageFile)AccessController.doPrivileged(this);
                return storageFile;
            }
            catch (PrivilegedActionException pae) {
                StorageFile storageFile = null;
                this.containerId = null;
                return storageFile;
            }
        }
        finally {
            this.containerId = null;
        }
    }

    public StorageFile getAlternateContainerPath(ContainerKey containerId, boolean stub) {
        return this.getContainerPath(containerId, stub, 4);
    }

    private synchronized void removeStubs() {
        this.actionCode = 9;
        try {
            AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
    }

    public void stubFileToRemoveAfterCheckPoint(StorageFile file, LogInstant logInstant, Object identity) {
        if (this.droppedTableStubInfo != null) {
            Object[] removeInfo = new Object[]{file, identity};
            this.droppedTableStubInfo.put(logInstant, removeInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDroppedContainerFileStubs(LogInstant redoLWM) throws StandardException {
        if (this.droppedTableStubInfo != null) {
            Hashtable hashtable = this.droppedTableStubInfo;
            synchronized (hashtable) {
                Enumeration e = this.droppedTableStubInfo.keys();
                while (e.hasMoreElements()) {
                    LogInstant logInstant = (LogInstant)e.nextElement();
                    if (!logInstant.lessThan(redoLWM)) continue;
                    Object[] removeInfo = (Object[])this.droppedTableStubInfo.get(logInstant);
                    Object identity = removeInfo[1];
                    Cacheable ccentry = this.containerCache.findCached(identity);
                    if (ccentry != null) {
                        this.containerCache.remove(ccentry);
                    }
                    BaseDataFileFactory baseDataFileFactory = this;
                    synchronized (baseDataFileFactory) {
                        this.actionFile = (StorageFile)removeInfo[0];
                        this.actionCode = 6;
                        try {
                            if (AccessController.doPrivileged(this) != null) {
                                this.droppedTableStubInfo.remove(logInstant);
                            }
                        }
                        catch (PrivilegedActionException pae) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    private synchronized long findMaxContainerId() {
        this.actionCode = 5;
        try {
            return (Long)AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException pae) {
            return 0L;
        }
    }

    private void bootLogFactory(boolean create, Properties startParams) throws StandardException {
        if (this.isReadOnly()) {
            startParams.put("derby.__rt.storage.log", "readonly");
        }
        this.logFactory = (LogFactory)Monitor.bootServiceModule(create, this, this.rawStoreFactory.getLogFactoryModule(), startParams);
    }

    private boolean handleServiceType(String type) {
        try {
            PersistentService ps = Monitor.getMonitor().getServiceProvider(type);
            return ps != null && ps.hasStorageFactory();
        }
        catch (StandardException se) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getJBMSLockOnDB(UUID myUUID, UUIDFactory uuidFactory, String databaseDirectory) throws StandardException {
        if (this.fileLockOnDB != null) {
            return;
        }
        if (this.isReadOnly()) {
            return;
        }
        if (myUUID == null) {
            SanityManager.THROWASSERT("myUUID == null");
        }
        BaseDataFileFactory baseDataFileFactory = this;
        synchronized (baseDataFileFactory) {
            this.actionCode = 11;
            this.myUUID = myUUID;
            this.uuidFactory = uuidFactory;
            this.databaseDirectory = databaseDirectory;
            try {
                AccessController.doPrivileged(this);
            }
            catch (PrivilegedActionException pae) {
                throw (StandardException)pae.getException();
            }
            finally {
                this.myUUID = null;
                this.uuidFactory = null;
                this.databaseDirectory = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void privGetJBMSLockOnDB() throws StandardException {
        boolean fileLockExisted = false;
        String blownUUID = null;
        StorageFile fileLock = this.storageFactory.newStorageFile("db.lck");
        try {
            if (fileLock.exists()) {
                fileLockExisted = true;
                this.fileLockOnDB = fileLock.getRandomAccessFile("rw");
                try {
                    blownUUID = this.fileLockOnDB.readUTF();
                }
                catch (IOException ioe) {
                    fileLockExisted = false;
                }
                this.fileLockOnDB.close();
                this.fileLockOnDB = null;
                if (!fileLock.delete()) {
                    throw StandardException.newException("XSDB6.D", this.databaseDirectory);
                }
            }
            this.fileLockOnDB = fileLock.getRandomAccessFile("rw");
            this.fileLockOnDB.writeUTF(this.myUUID.toString());
            this.fileLockOnDB.sync(false);
            this.fileLockOnDB.seek(0L);
            UUID checkUUID = this.uuidFactory.recreateUUID(this.fileLockOnDB.readUTF());
            if (!checkUUID.equals(this.myUUID)) {
                throw StandardException.newException("XSDB6.D", this.databaseDirectory);
            }
        }
        catch (IOException ioe) {
            this.readOnly = true;
            try {
                if (this.fileLockOnDB != null) {
                    this.fileLockOnDB.close();
                }
            }
            catch (IOException ioe2) {
                // empty catch block
            }
            this.fileLockOnDB = null;
            return;
        }
        if (fileLock.delete()) {
            Object[] args = new Object[]{this.myUUID, this.databaseDirectory, blownUUID};
            int exLockStatus = 0;
            if (!this.throwDBlckException) {
                this.exFileLock = this.storageFactory.newStorageFile("dbex.lck");
                exLockStatus = this.exFileLock.getExclusiveFileLock();
            }
            if (exLockStatus == 0 && fileLockExisted && !this.throwDBlckException) {
                StandardException multipleJBMSWarning = StandardException.newException("XSDB7.D", args);
                String warningMsg = MessageService.getCompleteMessage("XSDB7.D", args);
                this.logMsg(warningMsg);
                System.err.println(warningMsg);
            }
            try {
                if (this.fileLockOnDB != null) {
                    this.fileLockOnDB.close();
                }
                this.fileLockOnDB = fileLock.getRandomAccessFile("rw");
                this.fileLockOnDB.writeUTF(this.myUUID.toString());
                this.fileLockOnDB.sync(false);
                this.fileLockOnDB.close();
            }
            catch (IOException ioe) {
                try {
                    this.fileLockOnDB.close();
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
            }
            finally {
                this.fileLockOnDB = null;
            }
            if (fileLockExisted && this.throwDBlckException) {
                throw StandardException.newException("XSDB8.D", args);
            }
            if (exLockStatus == 2) {
                throw StandardException.newException("XSDB6.D", this.databaseDirectory);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseJBMSLockOnDB() {
        if (this.isReadOnly()) {
            return;
        }
        BaseDataFileFactory baseDataFileFactory = this;
        synchronized (baseDataFileFactory) {
            this.actionCode = 12;
            try {
                AccessController.doPrivileged(this);
            }
            catch (PrivilegedActionException privilegedActionException) {
            }
            finally {
                this.fileLockOnDB = null;
            }
        }
    }

    private void privReleaseJBMSLockOnDB() throws IOException {
        if (this.fileLockOnDB != null) {
            this.fileLockOnDB.close();
        }
        if (this.storageFactory != null) {
            StorageFile fileLock = this.storageFactory.newStorageFile("db.lck");
            fileLock.delete();
        }
        if (this.exFileLock != null) {
            this.exFileLock.releaseExclusiveFileLock();
        }
    }

    private void logMsg(String msg) {
        if (this.istream == null) {
            this.istream = Monitor.getStream();
        }
        this.istream.println(msg);
    }

    public final boolean databaseEncrypted() {
        return this.databaseEncrypted;
    }

    public void setDatabaseEncrypted() {
        this.databaseEncrypted = true;
    }

    public int encrypt(byte[] cleartext, int offset, int length, byte[] ciphertext, int outputOffset, boolean newEngine) throws StandardException {
        return this.rawStoreFactory.encrypt(cleartext, offset, length, ciphertext, outputOffset, newEngine);
    }

    public int decrypt(byte[] ciphertext, int offset, int length, byte[] cleartext, int outputOffset) throws StandardException {
        return this.rawStoreFactory.decrypt(ciphertext, offset, length, cleartext, outputOffset);
    }

    public void encryptAllContainers(RawTransaction t) throws StandardException {
        this.containerEncrypter = new EncryptData(this);
        this.containerEncrypter.encryptAllContainers(t);
    }

    public void removeOldVersionOfContainers(boolean inRecovery) throws StandardException {
        if (inRecovery) {
            this.containerEncrypter = new EncryptData(this);
        }
        this.containerEncrypter.removeOldVersionOfContainers(inRecovery);
        this.containerEncrypter = null;
    }

    public int getEncryptionBlockSize() {
        return this.rawStoreFactory.getEncryptionBlockSize();
    }

    public String getVersionedName(String name, long generationId) {
        return name.concat(".G".concat(Long.toString(generationId)));
    }

    public long getMaxContainerId() throws StandardException {
        return this.findMaxContainerId();
    }

    synchronized long getNextId() {
        return this.nextContainerId++;
    }

    int random() {
        return this.databaseEncrypted ? this.rawStoreFactory.random() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fileToRemove(StorageFile file, boolean remove) {
        if (this.postRecoveryRemovedFiles == null) {
            this.postRecoveryRemovedFiles = new Hashtable();
        }
        String path = null;
        BaseDataFileFactory baseDataFileFactory = this;
        synchronized (baseDataFileFactory) {
            this.actionCode = 7;
            this.actionFile = file;
            try {
                path = (String)AccessController.doPrivileged(this);
            }
            catch (PrivilegedActionException pae) {
            }
            finally {
                this.actionFile = null;
            }
        }
        if (remove) {
            this.postRecoveryRemovedFiles.put(path, file);
        } else {
            this.postRecoveryRemovedFiles.remove(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRecovery() throws StandardException {
        DaemonService daemon = this.rawStoreFactory.getDaemon();
        if (daemon == null) {
            return;
        }
        this.containerCache.useDaemonService(daemon);
        this.pageCache.useDaemonService(daemon);
        if (this.postRecoveryRemovedFiles != null) {
            BaseDataFileFactory baseDataFileFactory = this;
            synchronized (baseDataFileFactory) {
                this.actionCode = 8;
                try {
                    AccessController.doPrivileged(this);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    // empty catch block
                }
            }
            this.postRecoveryRemovedFiles = null;
        }
    }

    /*
     * Exception decompiling
     */
    public void freezePersistentStore() throws StandardException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unfreezePersistentStore() {
        Object object = this.freezeSemaphore;
        synchronized (object) {
            this.isFrozen = false;
            this.freezeSemaphore.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeInProgress() throws StandardException {
        Object object = this.freezeSemaphore;
        synchronized (object) {
            while (this.isFrozen) {
                try {
                    this.freezeSemaphore.wait();
                }
                catch (InterruptedException ie) {
                    throw StandardException.interrupt(ie);
                }
            }
            ++this.writersInProgress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFinished() {
        Object object = this.freezeSemaphore;
        synchronized (object) {
            SanityManager.ASSERT(this.writersInProgress > 0, "no writers in progress");
            --this.writersInProgress;
            this.freezeSemaphore.notifyAll();
        }
    }

    public void backupDataFiles(Transaction rt, File backupDir) throws StandardException {
        String[] files = this.getContainerNames();
        if (files != null) {
            LockingPolicy lockPolicy = rt.newLockingPolicy(0, 0, false);
            long segmentId = 0L;
            for (int f = files.length - 1; f >= 0; --f) {
                long containerId;
                try {
                    containerId = Long.parseLong(files[f].substring(1, files[f].length() - 4), 16);
                }
                catch (Throwable t) {
                    continue;
                }
                ContainerKey identity = new ContainerKey(segmentId, containerId);
                RawContainerHandle containerHdl = this.openDroppedContainer((RawTransaction)rt, identity, lockPolicy, 8);
                if (containerHdl == null) continue;
                containerHdl.backupContainer(backupDir.getPath());
                containerHdl.close();
            }
        } else {
            SanityManager.THROWASSERT("backup process is unable to read container names in seg0");
        }
    }

    synchronized String[] getContainerNames() {
        this.actionCode = 14;
        try {
            return (String[])AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException pae) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreDataDirectory(String backupPath) throws StandardException {
        File backupRoot = new File(backupPath);
        String[] bfilelist = PrivilegedFileOps.list(backupRoot);
        if (bfilelist != null) {
            boolean segmentexist = false;
            for (int i = 0; i < bfilelist.length; ++i) {
                File bsegdir;
                if (!bfilelist[i].startsWith("seg") || !PrivilegedFileOps.exists(bsegdir = new File(backupRoot, bfilelist[i])) || !PrivilegedFileOps.isDirectory(bsegdir)) continue;
                segmentexist = true;
                break;
            }
            if (!segmentexist) {
                throw StandardException.newException("XSDG6.D", backupRoot);
            }
        } else {
            throw StandardException.newException("XSDG6.D", backupRoot);
        }
        BaseDataFileFactory baseDataFileFactory = this;
        synchronized (baseDataFileFactory) {
            this.actionCode = 13;
            this.backupPath = backupPath;
            this.backupRoot = backupRoot;
            this.bfilelist = bfilelist;
            try {
                AccessController.doPrivileged(this);
            }
            catch (PrivilegedActionException pae) {
                throw (StandardException)pae.getException();
            }
            finally {
                this.backupPath = null;
                this.backupRoot = null;
                this.bfilelist = null;
            }
        }
    }

    private void privRestoreDataDirectory() throws StandardException {
        StorageFile csegdir;
        int i;
        StorageFile dataRoot = this.storageFactory.newStorageFile(null);
        String[] cfilelist = dataRoot.list();
        if (cfilelist != null) {
            for (i = 0; i < cfilelist.length; ++i) {
                if (!cfilelist[i].startsWith("seg") || (csegdir = this.storageFactory.newStorageFile(cfilelist[i])).deleteAll()) continue;
                throw StandardException.newException("XSDG7.D", csegdir);
            }
        }
        for (i = 0; i < this.bfilelist.length; ++i) {
            StorageFile toFile;
            File fromFile;
            if (this.bfilelist[i].startsWith("seg")) {
                File bsegdir1 = new File(this.backupRoot, this.bfilelist[i]);
                csegdir = this.storageFactory.newStorageFile(this.bfilelist[i]);
                if (FileUtil.copyDirectory(this.writableStorageFactory, bsegdir1, csegdir)) continue;
                throw StandardException.newException("XSDG8.D", (Object)bsegdir1, (Object)csegdir);
            }
            if (!this.databaseEncrypted || !this.bfilelist[i].startsWith("verifyKey.dat") || FileUtil.copyFile(this.writableStorageFactory, fromFile = new File(this.backupRoot, this.bfilelist[i]), toFile = this.storageFactory.newStorageFile(this.bfilelist[i]))) continue;
            throw StandardException.newException("XSDG8.D", (Object)this.bfilelist[i], (Object)toFile);
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public StorageFactory getStorageFactory() {
        return this.storageFactory;
    }

    public final Object run() throws Exception {
        switch (this.actionCode) {
            case 10: {
                this.readOnly = this.storageFactory.isReadOnlyDatabase();
                this.supportsRandomAccess = this.storageFactory.supportsRandomAccess();
                return null;
            }
            case 1: {
                return this.storageFactory.getTempDir();
            }
            case 2: {
                StorageFile tempDir = this.storageFactory.getTempDir();
                if (tempDir != null) {
                    tempDir.deleteAll();
                }
                return null;
            }
            case 3: 
            case 4: {
                StringBuffer sb = new StringBuffer("seg");
                sb.append(this.containerId.getSegmentId());
                sb.append(this.storageFactory.getSeparator());
                if (this.actionCode == 3) {
                    sb.append(this.stub ? (char)'d' : 'c');
                    sb.append(Long.toHexString(this.containerId.getContainerId()));
                    sb.append(".dat");
                } else {
                    sb.append(this.stub ? (char)'D' : 'C');
                    sb.append(Long.toHexString(this.containerId.getContainerId()));
                    sb.append(".DAT");
                }
                return this.storageFactory.newStorageFile(sb.toString());
            }
            case 9: {
                char separator = this.storageFactory.getSeparator();
                StorageFile root = this.storageFactory.newStorageFile(null);
                String[] segs = root.list();
                for (int s = segs.length - 1; s >= 0; --s) {
                    StorageFile seg;
                    if (!segs[s].startsWith("seg") || !(seg = this.storageFactory.newStorageFile(root, segs[s])).exists() || !seg.isDirectory()) continue;
                    String[] files = seg.list();
                    for (int f = files.length - 1; f >= 0; --f) {
                        StorageFile stub;
                        boolean delete_status;
                        if (!files[f].startsWith("D") && !files[f].startsWith("d") || (delete_status = (stub = this.storageFactory.newStorageFile(root, segs[s] + separator + files[f])).delete())) continue;
                        SanityManager.THROWASSERT("delete of stub (" + stub + ") failed.");
                    }
                }
                break;
            }
            case 5: {
                long maxnum = 1L;
                StorageFile seg = this.storageFactory.newStorageFile("seg0");
                if (seg.exists() && seg.isDirectory()) {
                    String[] files = seg.list();
                    for (int f = files.length - 1; f >= 0; --f) {
                        try {
                            long fileNumber = Long.parseLong(files[f].substring(1, files[f].length() - 4), 16);
                            if (fileNumber <= maxnum) continue;
                            maxnum = fileNumber;
                            continue;
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                }
                return ReuseFactory.getLong(maxnum);
            }
            case 6: {
                boolean ret = this.actionFile.exists() && this.actionFile.delete();
                this.actionFile = null;
                return ret ? this : null;
            }
            case 7: {
                String path = this.actionFile.getPath();
                this.actionFile = null;
                return path;
            }
            case 8: {
                Enumeration e = this.postRecoveryRemovedFiles.elements();
                while (e.hasMoreElements()) {
                    boolean delete_status;
                    StorageFile f = (StorageFile)e.nextElement();
                    if (!f.exists() || (delete_status = f.delete())) continue;
                    SanityManager.THROWASSERT("delete of stub (" + this.stub + ") failed.");
                }
                return null;
            }
            case 11: {
                this.privGetJBMSLockOnDB();
                return null;
            }
            case 12: {
                this.privReleaseJBMSLockOnDB();
                return null;
            }
            case 13: {
                this.privRestoreDataDirectory();
                return null;
            }
            case 14: {
                StorageFile seg = this.storageFactory.newStorageFile("seg0");
                if (seg.exists() && seg.isDirectory()) {
                    return seg.list();
                }
                return null;
            }
        }
        return null;
    }
}

