/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.access.SpaceInfo;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.data.RawContainerHandle;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.store.raw.data.AllocationActions;
import org.apache.derby.impl.store.raw.data.BaseContainer;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.DropOnCommit;
import org.apache.derby.impl.store.raw.data.PageActions;
import org.apache.derby.impl.store.raw.data.RecordId;
import org.apache.derby.impl.store.raw.data.SyncOnCommit;
import org.apache.derby.impl.store.raw.data.TruncateOnCommit;

public class BaseContainerHandle
extends Observable
implements RawContainerHandle,
Observer {
    private ContainerKey identity;
    private boolean active;
    protected BaseContainer container;
    private LockingPolicy locking;
    private RawTransaction xact;
    private boolean forUpdate;
    private int mode;
    private PageActions actionsSet;
    private AllocationActions allocActionsSet;

    public BaseContainerHandle(UUID rawStoreId, RawTransaction xact, ContainerKey identity, LockingPolicy locking, int mode) {
        this.identity = identity;
        this.xact = xact;
        this.locking = locking;
        this.mode = mode;
        this.forUpdate = (mode & 4) == 4;
    }

    public BaseContainerHandle(UUID rawStoreId, RawTransaction xact, PageActions actionsSet, AllocationActions allocActionsSet, LockingPolicy locking, BaseContainer container, int mode) {
        this(rawStoreId, xact, (ContainerKey)container.getIdentity(), locking, mode);
        this.actionsSet = actionsSet;
        this.allocActionsSet = allocActionsSet;
        this.container = container;
    }

    public Page addPage() throws StandardException {
        this.checkUpdateOpen();
        Page page = this.container.addPage(this, false);
        return page;
    }

    public void compressContainer() throws StandardException {
        this.checkUpdateOpen();
        this.container.compressContainer(this);
    }

    public long getReusableRecordIdSequenceNumber() throws StandardException {
        this.checkOpen();
        return this.container.getReusableRecordIdSequenceNumber();
    }

    public Page addPage(int flag) throws StandardException {
        if ((flag & 2) != 0 && this.active && this.forUpdate) {
            this.container.clearPreallocThreshold();
        }
        return this.addPage();
    }

    public void preAllocate(int numPage) {
        if (numPage > 0 && this.active && this.forUpdate) {
            this.container.prepareForBulkLoad(this, numPage);
        }
    }

    public void getContainerProperties(Properties prop) throws StandardException {
        this.checkOpen();
        this.container.getContainerProperties(prop);
    }

    public void removePage(Page page) throws StandardException {
        if (!this.active) {
            if (page != null) {
                page.unlatch();
            }
            throw StandardException.newException("40XD0");
        }
        if (!this.forUpdate) {
            if (page != null) {
                page.unlatch();
            }
            throw StandardException.newException("40XD1");
        }
        this.container.removePage(this, (BasePage)page);
    }

    public Page getPage(long pageNumber) throws StandardException {
        this.checkOpen();
        return this.container.getPage(this, pageNumber, true);
    }

    public Page getAllocPage(long pageNumber) throws StandardException {
        this.checkOpen();
        return this.container.getAllocPage(this, pageNumber, true);
    }

    public Page getUserPageNoWait(long pageNumber) throws StandardException {
        this.checkOpen();
        return this.container.getHeadPage(this, pageNumber, false);
    }

    public Page getUserPageWait(long pageNumber) throws StandardException {
        this.checkOpen();
        return this.container.getHeadPage(this, pageNumber, true);
    }

    public Page getPageNoWait(long pageNumber) throws StandardException {
        this.checkOpen();
        return this.container.getPage(this, pageNumber, false);
    }

    public Page getFirstPage() throws StandardException {
        this.checkOpen();
        return this.container.getFirstPage(this);
    }

    public Page getNextPage(long pageNumber) throws StandardException {
        this.checkOpen();
        return this.container.getNextPage(this, pageNumber);
    }

    public Page getPageForInsert(int flag) throws StandardException {
        this.checkUpdateOpen();
        return this.container.getPageForInsert(this, flag);
    }

    public Page getPageForCompress(int flag, long pageno) throws StandardException {
        this.checkUpdateOpen();
        return this.container.getPageForCompress(this, flag, pageno);
    }

    public final boolean isReadOnly() {
        return !this.forUpdate;
    }

    public synchronized void close() {
        if (this.xact == null) {
            return;
        }
        this.informObservers();
        this.active = false;
        this.getLockingPolicy().unlockContainer(this.xact, this);
        if (this.container != null) {
            this.container.letGo(this);
            this.container = null;
        }
        this.xact.deleteObserver(this);
        this.xact = null;
    }

    public long getEstimatedRowCount(int flag) throws StandardException {
        this.checkOpen();
        return this.container.getEstimatedRowCount(flag);
    }

    public void setEstimatedRowCount(long count, int flag) throws StandardException {
        this.checkOpen();
        this.container.setEstimatedRowCount(count, flag);
    }

    public long getEstimatedPageCount(int flag) throws StandardException {
        this.checkOpen();
        return this.container.getEstimatedPageCount(this, flag);
    }

    public void flushContainer() throws StandardException {
        this.checkUpdateOpen();
        this.container.flushAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compactRecord(RecordHandle record) throws StandardException {
        if (!this.forUpdate) {
            throw StandardException.newException("40XD1");
        }
        PageKey pkey = (PageKey)record.getPageId();
        BasePage headPage = (BasePage)this.getPage(pkey.getPageNumber());
        if (headPage != null) {
            try {
                headPage.compactRecord(record);
            }
            finally {
                headPage.unlatch();
            }
        }
    }

    public int getContainerStatus() throws StandardException {
        this.checkOpen();
        return this.container.getContainerStatus();
    }

    public void removeContainer(LogInstant instant) throws StandardException {
        this.checkUpdateOpen();
        this.container.removeContainer(instant, true);
    }

    public ContainerKey getId() {
        return this.identity;
    }

    public Object getUniqueId() {
        return this;
    }

    public void dropContainer(LogInstant instant, boolean drop) throws StandardException {
        this.checkUpdateOpen();
        this.container.dropContainer(instant, drop);
    }

    public long getContainerVersion() throws StandardException {
        this.checkOpen();
        return this.container.getContainerVersion();
    }

    public Page getAnyPage(long pageNumber) throws StandardException {
        this.checkOpen();
        return this.container.getAnyPage(this, pageNumber, true);
    }

    public Page reCreatePageForRedoRecovery(int pageFormat, long pageNumber, long pageOffset) throws StandardException {
        this.checkUpdateOpen();
        return this.container.reCreatePageForRedoRecovery(this, pageFormat, pageNumber, pageOffset);
    }

    public ByteArray logCreateContainerInfo() throws StandardException {
        this.checkUpdateOpen();
        return this.container.logCreateContainerInfo();
    }

    public RecordHandle makeRecordHandle(long pageNumber, int recordId) throws StandardException {
        return new RecordId(this.identity, pageNumber, recordId);
    }

    public void update(Observable obj, Object arg) {
        if (arg == null) {
            SanityManager.THROWASSERT("still on observr list " + this);
        }
        if (this.xact == null) {
            return;
        }
        if (obj != this.xact) {
            SanityManager.THROWASSERT("Observable passed to update is incorrect expected " + this.xact + " got " + obj);
        }
        if (arg.equals(RawTransaction.COMMIT) || arg.equals(RawTransaction.ABORT) || arg.equals(this.identity)) {
            this.close();
            return;
        }
        if (arg.equals(RawTransaction.SAVEPOINT_ROLLBACK)) {
            this.informObservers();
            return;
        }
        if (arg.equals(RawTransaction.LOCK_ESCALATE)) {
            if (this.getLockingPolicy().getMode() != 1) {
                return;
            }
            try {
                this.getLockingPolicy().lockContainer(this.getTransaction(), this, false, this.forUpdate);
            }
            catch (StandardException se) {
                this.xact.setObserverException(se);
            }
        }
    }

    public PageActions getActionSet() {
        return this.actionsSet;
    }

    public AllocationActions getAllocationActionSet() {
        return this.allocActionsSet;
    }

    public boolean useContainer(boolean droppedOK, boolean waitForLock) throws StandardException {
        SanityManager.ASSERT(!this.active);
        boolean gotLock = this.getLockingPolicy().lockContainer(this.getTransaction(), this, waitForLock, this.forUpdate);
        if (!gotLock) {
            SanityManager.ASSERT(!waitForLock, "lockContainer wait returns false");
            this.container = null;
            throw StandardException.newException("40XL1");
        }
        if ((this.mode & 0x40) == 0) {
            SanityManager.ASSERT(this.container != null);
            if (!this.container.use(this, this.forUpdate, droppedOK)) {
                this.getLockingPolicy().unlockContainer(this.xact, this);
                this.container = null;
                return false;
            }
            this.active = true;
        } else if (this.getLockingPolicy().getMode() != 1) {
            return true;
        }
        this.xact.addObserver(this);
        if ((this.mode & 0x408) == 0) {
            if ((this.mode & 0x10) == 16) {
                this.xact.addObserver(new TruncateOnCommit(this.identity, true));
            } else if ((this.mode & 0x100) == 256) {
                this.xact.addObserver(new TruncateOnCommit(this.identity, false));
            }
            if ((this.mode & 0x20) == 32) {
                this.xact.addObserver(new DropOnCommit(this.identity));
            }
            if ((this.mode & 0x200) == 512) {
                this.xact.addObserver(new SyncOnCommit(this.identity));
            }
        }
        return true;
    }

    public final RawTransaction getTransaction() {
        return this.xact;
    }

    public final LockingPolicy getLockingPolicy() {
        SanityManager.ASSERT(this.locking != null);
        return this.locking;
    }

    public final void setLockingPolicy(LockingPolicy newLockingPolicy) {
        this.locking = newLockingPolicy;
    }

    public final boolean updateOK() {
        return this.forUpdate;
    }

    public int getMode() {
        return this.mode;
    }

    public void preDirty(boolean preDirtyOn) throws StandardException {
        this.checkUpdateOpen();
        this.container.preDirty(preDirtyOn);
    }

    public boolean isTemporaryContainer() throws StandardException {
        this.checkOpen();
        return this.identity != null && this.identity.getSegmentId() == -1L;
    }

    protected void checkOpen() throws StandardException {
        if (!this.active) {
            throw StandardException.newException("40XD0");
        }
    }

    private void checkUpdateOpen() throws StandardException {
        if (!this.active) {
            throw StandardException.newException("40XD0");
        }
        if (!this.forUpdate) {
            throw StandardException.newException("40XD1");
        }
    }

    protected void informObservers() {
        if (this.countObservers() != 0) {
            this.setChanged();
            this.notifyObservers();
        }
    }

    public SpaceInfo getSpaceInfo() throws StandardException {
        return this.container.getSpaceInfo(this);
    }

    public void backupContainer(String backupContainerPath) throws StandardException {
        this.checkOpen();
        this.container.backupContainer(this, backupContainerPath);
    }

    public void encryptContainer(String newFilePath) throws StandardException {
        this.checkOpen();
        this.container.encryptContainer(this, newFilePath);
    }

    public String toString() {
        String str = new String();
        str = str + "BaseContainerHandle:(" + this.identity.toString() + ")";
        return str;
    }
}

