/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.heap;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.ScanInfo;
import org.apache.derby.iapi.store.access.conglomerate.Conglomerate;
import org.apache.derby.iapi.store.access.conglomerate.ScanManager;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.store.access.conglomerate.GenericScanController;
import org.apache.derby.impl.store.access.conglomerate.RowPosition;
import org.apache.derby.impl.store.access.heap.Heap;
import org.apache.derby.impl.store.access.heap.HeapPostCommit;
import org.apache.derby.impl.store.access.heap.HeapRowLocation;
import org.apache.derby.impl.store.access.heap.HeapScanInfo;

class HeapScan
extends GenericScanController
implements ScanManager {
    private DataValueDescriptor[][] fetchNext_one_slot_array = new DataValueDescriptor[1][];

    protected void queueDeletePostCommitWork(RowPosition pos) throws StandardException {
        TransactionManager xact_mgr = this.open_conglom.getXactMgr();
        xact_mgr.addPostCommitWork(new HeapPostCommit(xact_mgr.getAccessManager(), (Heap)this.open_conglom.getConglomerate(), pos.current_page.getPageNumber()));
    }

    protected void setRowLocationArray(RowLocation[] rowloc_array, int index, RowPosition pos) throws StandardException {
        if (rowloc_array[index] == null) {
            rowloc_array[index] = new HeapRowLocation(pos.current_rh);
        } else {
            SanityManager.ASSERT(rowloc_array[index] instanceof HeapRowLocation);
            ((HeapRowLocation)rowloc_array[index]).setFrom(pos.current_rh);
        }
    }

    protected void setRowLocationArray(RowLocation[] rowloc_array, int index, RecordHandle rh) throws StandardException {
        if (rowloc_array[index] == null) {
            rowloc_array[index] = new HeapRowLocation(rh);
        } else {
            SanityManager.ASSERT(rowloc_array[index] instanceof HeapRowLocation);
            ((HeapRowLocation)rowloc_array[index]).setFrom(rh);
        }
    }

    private boolean reopenScanByRecordHandleAndSetLocks(RecordHandle rh) throws StandardException {
        if (rh == null) {
            return false;
        }
        if (this.scan_position.current_rh != null) {
            this.open_conglom.unlockPositionAfterRead(this.scan_position);
        }
        this.scan_position.current_rh = rh;
        this.scan_position.current_rh_qualified = false;
        boolean rowLocationDisappeared = this.open_conglom.latchPageAndRepositionScan(this.scan_position);
        if (!rowLocationDisappeared) {
            this.setScanState(2);
            this.open_conglom.lockPositionForRead(this.scan_position, null, true, true);
        }
        this.scan_position.unlatch();
        return !rowLocationDisappeared;
    }

    public boolean fetchNext(DataValueDescriptor[] fetch_row) throws StandardException {
        this.fetchNext_one_slot_array[0] = fetch_row == null ? RowUtil.EMPTY_ROW : fetch_row;
        boolean ret_val = this.fetchRows(this.fetchNext_one_slot_array, null, null, 1L, null) == 1;
        return ret_val;
    }

    public boolean next() throws StandardException {
        this.fetchNext_one_slot_array[0] = this.open_conglom.getRuntimeMem().get_scratch_row(this.open_conglom.getRawTran());
        boolean ret_val = this.fetchRows(this.fetchNext_one_slot_array, null, null, 1L, null) == 1;
        return ret_val;
    }

    public boolean positionAtRowLocation(RowLocation rl) throws StandardException {
        if (this.open_conglom.isClosed() && !this.rowLocationsInvalidated) {
            this.reopenAfterEndTransaction();
        }
        if (this.rowLocationsInvalidated) {
            return false;
        }
        return this.reopenScanByRecordHandleAndSetLocks(((HeapRowLocation)rl).getRecordHandle(this.open_conglom.getContainer()));
    }

    public void fetchLocation(RowLocation templateLocation) throws StandardException {
        if (this.open_conglom.getContainer() == null || this.scan_position.current_rh == null) {
            throw StandardException.newException("XSCH7.S");
        }
        HeapRowLocation hrl = (HeapRowLocation)templateLocation;
        hrl.setFrom(this.scan_position.current_rh);
    }

    public int fetchNextGroup(DataValueDescriptor[][] row_array, RowLocation[] rowloc_array) throws StandardException {
        return this.fetchRows(row_array, rowloc_array, null, row_array.length, null);
    }

    public int fetchNextGroup(DataValueDescriptor[][] row_array, RowLocation[] old_rowloc_array, RowLocation[] new_rowloc_array) throws StandardException {
        throw StandardException.newException("XSCH8.S");
    }

    public ScanInfo getScanInfo() throws StandardException {
        return new HeapScanInfo(this);
    }

    public void reopenScanByRowLocation(RowLocation startRowLocation, Qualifier[][] qualifier) throws StandardException {
        this.reopenScanByRecordHandle(((HeapRowLocation)startRowLocation).getRecordHandle(this.open_conglom.getContainer()), qualifier);
    }

    public void savePosition(Conglomerate conglom, Page page) throws StandardException {
    }
}

