/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.heap;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.ResultSet;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.store.raw.data.RecordId;

public class HeapRowLocation
extends DataType
implements RowLocation {
    private long pageno;
    private int recid;
    private RecordHandle rh;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(HeapRowLocation.class);
    private static final int RECORD_HANDLE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(RecordId.class);

    public int estimateMemoryUsage() {
        int sz = BASE_MEMORY_USAGE;
        if (null != this.rh) {
            sz += RECORD_HANDLE_MEMORY_USAGE;
        }
        return sz;
    }

    public String getTypeName() {
        return "RowLocation";
    }

    public void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) {
    }

    public DataValueDescriptor getNewNull() {
        return new HeapRowLocation();
    }

    public Object getObject() {
        return null;
    }

    public Object cloneObject() {
        return this.getClone();
    }

    public DataValueDescriptor getClone() {
        return new HeapRowLocation(this);
    }

    public DataValueDescriptor recycle() {
        this.pageno = 0L;
        this.recid = 0;
        this.rh = null;
        return this;
    }

    public int getLength() {
        return 10;
    }

    public String getString() {
        return this.toString();
    }

    public boolean compare(int op, DataValueDescriptor other, boolean orderedNulls, boolean unknownRV) {
        int result = this.compare(other);
        switch (op) {
            case 1: {
                return result < 0;
            }
            case 2: {
                return result == 0;
            }
            case 3: {
                return result <= 0;
            }
        }
        SanityManager.THROWASSERT("Unexpected operation");
        return false;
    }

    public int compare(DataValueDescriptor other) {
        SanityManager.ASSERT(other instanceof HeapRowLocation);
        HeapRowLocation arg = (HeapRowLocation)other;
        long myPage = this.pageno;
        long otherPage = arg.pageno;
        if (myPage < otherPage) {
            return -1;
        }
        if (myPage > otherPage) {
            return 1;
        }
        int myRecordId = this.recid;
        int otherRecordId = arg.recid;
        if (myRecordId == otherRecordId) {
            return 0;
        }
        if (myRecordId < otherRecordId) {
            return -1;
        }
        return 1;
    }

    HeapRowLocation(RecordHandle rh) {
        this.setFrom(rh);
    }

    public HeapRowLocation() {
        this.pageno = 0L;
        this.recid = 0;
    }

    private HeapRowLocation(HeapRowLocation other) {
        this.pageno = other.pageno;
        this.recid = other.recid;
        this.rh = other.rh;
    }

    public RecordHandle getRecordHandle(ContainerHandle ch) throws StandardException {
        if (this.rh != null) {
            return this.rh;
        }
        this.rh = ch.makeRecordHandle(this.pageno, this.recid);
        return this.rh;
    }

    void setFrom(RecordHandle rh) {
        this.pageno = rh.getPageNumber();
        this.recid = rh.getId();
        this.rh = rh;
    }

    public int getTypeFormatId() {
        return 90;
    }

    public boolean isNull() {
        return false;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        CompressedNumber.writeLong(out, this.pageno);
        CompressedNumber.writeInt(out, this.recid);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.pageno = CompressedNumber.readLong(in);
        this.recid = CompressedNumber.readInt(in);
        this.rh = null;
    }

    public void readExternalFromArray(ArrayInputStream in) throws IOException, ClassNotFoundException {
        this.pageno = in.readCompressedLong();
        this.recid = in.readCompressedInt();
        this.rh = null;
    }

    public void restoreToNull() {
        SanityManager.THROWASSERT("HeapRowLocation is never null");
    }

    protected void setFrom(DataValueDescriptor theValue) {
        SanityManager.THROWASSERT("SHOULD NOT BE CALLED");
    }

    public boolean equals(Object ref) {
        if (ref instanceof HeapRowLocation) {
            HeapRowLocation other = (HeapRowLocation)ref;
            return this.pageno == other.pageno && this.recid == other.recid;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.pageno ^ this.recid;
    }

    public String toString() {
        String string = "(" + this.pageno + "," + this.recid + ")";
        return string;
    }
}

