/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree.index;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.conglomerate.Conglomerate;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.btree.BTreeForwardScan;
import org.apache.derby.impl.store.access.btree.BTreeLockingPolicy;
import org.apache.derby.impl.store.access.btree.index.B2I;
import org.apache.derby.impl.store.access.btree.index.B2IStaticCompiledInfo;
import org.apache.derby.impl.store.access.btree.index.B2IUndo;

public class B2IForwardScan
extends BTreeForwardScan {
    private ConglomerateController base_cc_for_locking;
    private int init_isolation_level;

    B2IForwardScan() {
    }

    public void close() throws StandardException {
        super.close();
        if (this.base_cc_for_locking != null) {
            this.base_cc_for_locking.close();
            this.base_cc_for_locking = null;
        }
    }

    public boolean closeForEndTransaction(boolean closeHeldScan) throws StandardException {
        boolean ret_val = super.closeForEndTransaction(closeHeldScan);
        if (this.base_cc_for_locking != null) {
            this.base_cc_for_locking.close();
            this.base_cc_for_locking = null;
        }
        return ret_val;
    }

    public ContainerHandle reopen() throws StandardException {
        ContainerHandle container = super.reopen();
        B2I b2i = (B2I)this.getConglomerate();
        int base_open_mode = this.getOpenMode() | 0x40;
        this.base_cc_for_locking = this.getXactMgr().openConglomerate(b2i.baseConglomerateId, false, base_open_mode, this.init_lock_level, this.init_isolation_level);
        this.setLockingPolicy(b2i.getBtreeLockingPolicy(this.getXactMgr().getRawStoreXact(), this.getLockLevel(), this.getOpenMode(), this.init_isolation_level, this.base_cc_for_locking, this));
        return container;
    }

    public void init(TransactionManager xact_manager, Transaction rawtran, boolean hold, int open_mode, int lock_level, LockingPolicy locking_policy, int isolation_level, boolean open_for_locking, FormatableBitSet scanColumnList, DataValueDescriptor[] startKeyValue, int startSearchOperator, Qualifier[][] qualifier, DataValueDescriptor[] stopKeyValue, int stopSearchOperator, B2I conglomerate, B2IUndo undo, B2IStaticCompiledInfo static_info, DynamicCompiledOpenConglomInfo dynamic_info) throws StandardException {
        int base_open_mode = open_mode | 0x40;
        this.base_cc_for_locking = static_info != null ? xact_manager.openCompiledConglomerate(false, base_open_mode, lock_level, isolation_level, static_info.base_table_static_info, ((Conglomerate)static_info.getConglom()).getDynamicCompiledConglomInfo(conglomerate.baseConglomerateId)) : xact_manager.openConglomerate(conglomerate.baseConglomerateId, false, base_open_mode, lock_level, isolation_level);
        BTreeLockingPolicy b2i_locking_policy = conglomerate.getBtreeLockingPolicy(rawtran, lock_level, open_mode, isolation_level, this.base_cc_for_locking, this);
        super.init(xact_manager, rawtran, hold, open_mode, lock_level, b2i_locking_policy, scanColumnList, startKeyValue, startSearchOperator, qualifier, stopKeyValue, stopSearchOperator, conglomerate, undo, static_info, dynamic_info);
        this.init_isolation_level = isolation_level;
    }
}

