/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.btree.BTree;
import org.apache.derby.impl.store.access.btree.BranchControlRow;
import org.apache.derby.impl.store.access.btree.BranchRow;
import org.apache.derby.impl.store.access.btree.ControlRow;
import org.apache.derby.impl.store.access.btree.OpenBTree;
import org.apache.derby.impl.store.access.btree.SearchParameters;

public class LeafControlRow
extends ControlRow {
    public LeafControlRow() {
    }

    LeafControlRow(OpenBTree btree, Page page, ControlRow parent, boolean isRoot) throws StandardException {
        super(btree, page, 0, parent, isRoot);
    }

    private static LeafControlRow allocate(OpenBTree btree, ControlRow parent) throws StandardException {
        Page page = btree.container.addPage();
        LeafControlRow control_row = new LeafControlRow(btree, page, parent, false);
        byte insertFlag = 0;
        insertFlag = (byte)(insertFlag | 1);
        RecordHandle rh = page.insertAtSlot(0, control_row.getRow(), null, null, insertFlag, 50);
        RecordHandle rh2 = null;
        rh2 = page.fetchFromSlot(null, 0, new DataValueDescriptor[0], null, true);
        SanityManager.ASSERT(rh.getId() == rh2.getId() && rh.getPageNumber() == rh2.getPageNumber());
        return control_row;
    }

    private float get_left_nondeleted_rowcnt(int startslot) throws StandardException {
        int non_deleted_row_count = 0;
        for (int slot = 1; slot <= startslot; ++slot) {
            if (this.page.isDeletedAtSlot(slot)) continue;
            ++non_deleted_row_count;
        }
        return non_deleted_row_count;
    }

    protected final void controlRowInit() {
    }

    public static void initEmptyBtree(OpenBTree open_btree) throws StandardException {
        Page page = open_btree.container.getPage(1L);
        LeafControlRow control_row = new LeafControlRow(open_btree, page, null, true);
        byte insertFlag = 0;
        insertFlag = (byte)(insertFlag | 1);
        RecordHandle rh = page.insertAtSlot(0, control_row.getRow(), null, null, insertFlag, 50);
        RecordHandle rh2 = null;
        rh2 = page.fetchFromSlot(null, 0, new DataValueDescriptor[0], null, true);
        SanityManager.ASSERT(rh.getId() == rh2.getId() && rh.getPageNumber() == rh2.getPageNumber());
        if (SanityManager.DEBUG_ON("enableBtreeConsistencyCheck")) {
            control_row.checkConsistency(open_btree, null, true);
        }
        page.unlatch();
    }

    protected final int getNumberOfControlRowColumns() {
        return 7;
    }

    public boolean isLeftmostLeaf() throws StandardException {
        return this.getleftSiblingPageNumber() == -1L;
    }

    public boolean isRightmostLeaf() throws StandardException {
        return this.getrightSiblingPageNumber() == -1L;
    }

    public ControlRow search(SearchParameters sp) throws StandardException {
        this.searchForEntry(sp);
        if (sp.searchForOptimizer) {
            int startslot = sp.resultSlot;
            if (sp.resultExact) {
                SanityManager.ASSERT(sp.resultSlot > 0);
                if (sp.partial_key_match_op == 1) {
                    --startslot;
                }
            }
            float non_deleted_left_rows = this.get_left_nondeleted_rowcnt(startslot);
            int non_deleted_row_count = this.page.nonDeletedRecordCount();
            if (this.getIsRoot()) {
                sp.current_fraction = 1.0f;
                sp.left_fraction = 0.0f;
            }
            if (non_deleted_row_count > 1) {
                sp.left_fraction += sp.current_fraction * (non_deleted_left_rows / (float)(non_deleted_row_count - 1));
            }
            if (non_deleted_row_count > 1) {
                sp.current_fraction *= 1.0f / (float)(non_deleted_row_count - 1);
            }
        }
        return this;
    }

    protected ControlRow searchLeft(OpenBTree btree) throws StandardException {
        return this;
    }

    protected ControlRow searchRight(OpenBTree btree) throws StandardException {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean shrinkFor(OpenBTree btree, DataValueDescriptor[] key) throws StandardException {
        boolean shrink_me = false;
        try {
            if (this.page.recordCount() == 1 && !this.getIsRoot()) {
                shrink_me = this.unlink(btree);
            }
        }
        finally {
            if (!shrink_me) {
                this.release();
            }
        }
        return shrink_me;
    }

    protected long splitFor(OpenBTree open_btree, DataValueDescriptor[] template, BranchControlRow parent_page, DataValueDescriptor[] splitrow, int flag) throws StandardException {
        long current_leaf_pageno = this.page.getPageNumber();
        if (parent_page == null && !this.getIsRoot()) {
            SanityManager.THROWASSERT(this + " splitFor null parent and non-root");
        }
        int n = this.page.recordCount() - 1;
        open_btree.getConglomerate();
        if (n < BTree.maxRowsPerPage && this.page.spaceForInsert(splitrow, null, 50)) {
            open_btree.getXactMgr().commit();
            if (parent_page != null) {
                parent_page.release();
            }
            this.release();
            return current_leaf_pageno;
        }
        SanityManager.ASSERT(this.page.recordCount() > 1);
        if (this.getIsRoot()) {
            LeafControlRow.growRoot(open_btree, template, this);
            ControlRow new_root = ControlRow.get(open_btree, 1L);
            return new_root.splitFor(open_btree, template, null, splitrow, flag);
        }
        int splitpoint = (this.page.recordCount() - 1) / 2 + 1;
        if ((flag & 4) != 0) {
            splitpoint = 1;
        } else if ((flag & 1) != 0) {
            splitpoint = this.page.recordCount() - 1;
        }
        if (splitpoint <= 0) {
            SanityManager.THROWASSERT(this + " yikes! splitpoint of 0!");
        }
        Object[] split_leaf_row = open_btree.getConglomerate().createTemplate(open_btree.getRawTran());
        this.page.fetchFromSlot(null, splitpoint, split_leaf_row, null, true);
        BranchRow branchrow = BranchRow.createBranchRowFromOldLeafRow((DataValueDescriptor[])split_leaf_row, -1L);
        if (!parent_page.page.spaceForInsert(branchrow.getRow(), null, 50)) {
            return BranchControlRow.restartSplitFor(open_btree, template, parent_page, this, branchrow.getRow(), splitrow, flag);
        }
        SanityManager.ASSERT(open_btree.init_open_user_scans != null);
        open_btree.init_open_user_scans.saveScanPositions(open_btree.getConglomerate(), this.page);
        if (!open_btree.getLockingPolicy().lockScan(this, parent_page, true, 1)) {
            return current_leaf_pageno;
        }
        LeafControlRow newleaf = LeafControlRow.allocate(open_btree, parent_page);
        branchrow.setPageNumber(newleaf.page.getPageNumber());
        if (SanityManager.DEBUG_ON("leaf_split_abort1")) {
            throw StandardException.newException("XSCB9.S");
        }
        newleaf.linkRight(open_btree, this);
        int num_rows_to_move = this.page.recordCount() - splitpoint;
        SanityManager.ASSERT(num_rows_to_move >= 0);
        if (num_rows_to_move != 0) {
            this.page.copyAndPurge(newleaf.page, splitpoint, num_rows_to_move, 1);
        }
        if (SanityManager.DEBUG_ON("leaf_split_abort2")) {
            throw StandardException.newException("XSCB9.S");
        }
        if (SanityManager.DEBUG_ON("leaf_split_abort3")) {
            throw StandardException.newException("XSCB9.S");
        }
        BranchRow branch_template = BranchRow.createEmptyTemplate(open_btree.getRawTran(), open_btree.getConglomerate());
        SearchParameters sp = new SearchParameters(branchrow.getRow(), 1, branch_template.getRow(), open_btree, false);
        parent_page.searchForEntry(sp);
        SanityManager.ASSERT(parent_page.page.spaceForInsert(branchrow.getRow(), null, 50));
        byte insertFlag = 0;
        insertFlag = (byte)(insertFlag | 1);
        insertFlag = (byte)(insertFlag | 2);
        if (parent_page.page.insertAtSlot(sp.resultSlot + 1, branchrow.getRow(), null, null, insertFlag, 50) == null) {
            throw StandardException.newException("XSCB6.S");
        }
        branchrow = null;
        if (SanityManager.DEBUG_ON("leaf_split_abort4")) {
            throw StandardException.newException("XSCB9.S");
        }
        if (SanityManager.DEBUG_ON("enableBtreeConsistencyCheck")) {
            this.checkConsistency(open_btree, parent_page, false);
            newleaf.checkConsistency(open_btree, parent_page, false);
            parent_page.checkConsistency(open_btree, null, false);
        }
        open_btree.getXactMgr().commit();
        parent_page.release();
        this.release();
        long new_leaf_pageno = newleaf.page.getPageNumber();
        newleaf.release();
        return new_leaf_pageno;
    }

    private static void growRoot(OpenBTree open_btree, DataValueDescriptor[] template, LeafControlRow leafroot) throws StandardException {
        BranchControlRow branchroot = null;
        LeafControlRow newleaf = null;
        open_btree.init_open_user_scans.saveScanPositions(open_btree.getConglomerate(), leafroot.page);
        if (!open_btree.getLockingPolicy().lockScan(leafroot, null, true, 1)) {
            return;
        }
        newleaf = LeafControlRow.allocate(open_btree, leafroot);
        if (SanityManager.DEBUG_ON("leaf_split_growRoot1")) {
            throw StandardException.newException("XSCB9.S");
        }
        SanityManager.ASSERT(leafroot.page.recordCount() - 1 > 0);
        leafroot.page.copyAndPurge(newleaf.page, 1, leafroot.page.recordCount() - 1, 1);
        if (SanityManager.DEBUG_ON("leaf_split_growRoot2")) {
            throw StandardException.newException("XSCB9.S");
        }
        if (SanityManager.DEBUG_ON("leaf_split_growRoot3")) {
            leafroot.setLevel(42);
            leafroot.setParent(42L);
            throw StandardException.newException("XSCB9.S");
        }
        branchroot = new BranchControlRow(open_btree, leafroot.page, 1, null, true, newleaf.page.getPageNumber());
        leafroot = null;
        branchroot.page.updateAtSlot(0, branchroot.getRow(), null);
        if (SanityManager.DEBUG_ON("leaf_split_growRoot4")) {
            throw StandardException.newException("XSCB9.S");
        }
        if (SanityManager.DEBUG_ON("enableBtreeConsistencyCheck")) {
            newleaf.checkConsistency(open_btree, branchroot, false);
            branchroot.checkConsistency(open_btree, null, false);
        }
        open_btree.getXactMgr().commit();
        if (SanityManager.DEBUG_ON("leaf_split_growRoot5")) {
            throw StandardException.newException("XSCB9.S");
        }
        if (branchroot != null) {
            branchroot.release();
        }
        if (leafroot != null) {
            leafroot.release();
        }
        if (newleaf != null) {
            newleaf.release();
        }
    }

    protected ControlRow getLeftChild(OpenBTree btree) throws StandardException {
        return null;
    }

    protected ControlRow getRightChild(OpenBTree btree) throws StandardException {
        return null;
    }

    public int checkConsistency(OpenBTree btree, ControlRow parent, boolean check_other_pages) throws StandardException {
        this.checkGeneric(btree, parent, check_other_pages);
        SanityManager.ASSERT(this.getLevel() == 0, "leaf not at level 0");
        SanityManager.ASSERT(this.page.fetchNumFieldsAtSlot(0) == 7);
        int numslots = this.page.recordCount();
        for (int slot = 1; slot < numslots; ++slot) {
            if (this.page.fetchNumFieldsAtSlot(slot) >= btree.getConglomerate().nKeyFields) continue;
            SanityManager.THROWASSERT("row[" + slot + "]" + " has " + this.page.fetchNumFieldsAtSlot(slot) + " columns, should have at least" + btree.getConglomerate().nKeyFields);
        }
        return 1;
    }

    public void printTree(OpenBTree btree) throws StandardException {
        SanityManager.DEBUG_PRINT("p_tree", this.debugPage(btree));
    }

    public int getTypeFormatId() {
        return 133;
    }
}

