/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.raw.FetchDescriptor;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.store.access.btree.BTreeRowPosition;
import org.apache.derby.impl.store.access.btree.BTreeScan;
import org.apache.derby.impl.store.access.btree.ControlRow;
import org.apache.derby.impl.store.access.btree.LeafControlRow;

public class BTreeMaxScan
extends BTreeScan {
    private boolean fetchMaxRowFromBeginning(BTreeRowPosition pos, DataValueDescriptor[] fetch_row) throws StandardException {
        boolean ret_row_count = false;
        RecordHandle max_rh = null;
        Object[] check_row_template = new DataValueDescriptor[]{fetch_row[0].getClone()};
        FetchDescriptor check_row_desc = RowUtil.getFetchDescriptorConstant(1);
        this.reopenScan(null, 0, null, null, 0);
        this.positionAtStartForForwardScan(pos);
        boolean nulls_not_reached = true;
        while (pos.current_leaf != null && nulls_not_reached) {
            while (pos.current_slot + 1 < pos.current_leaf.page.recordCount()) {
                if (pos.current_rh != null) {
                    this.getLockingPolicy().unlockScanRecordAfterRead(pos, this.init_forUpdate);
                    pos.current_rh = null;
                }
                ++pos.current_slot;
                ++this.stat_numrows_visited;
                RecordHandle rh = pos.current_leaf.page.fetchFromSlot(null, pos.current_slot, check_row_template, null, true);
                boolean latch_released = !this.getLockingPolicy().lockScanRow(this, this.getConglomerate(), pos, false, this.init_lock_fetch_desc, pos.current_lock_template, pos.current_lock_row_loc, false, this.init_forUpdate, this.lock_operation);
                latch_released = BTreeMaxScan.test_errors(this, "BTreeMaxScan_fetchNextGroup", false, this.getLockingPolicy(), pos.current_leaf, latch_released);
                pos.current_rh = rh;
                if (latch_released && !this.reposition(pos, false)) {
                    SanityManager.THROWASSERT("can not fail holding scan lock.");
                }
                if (pos.current_leaf.page.isDeletedAtSlot(pos.current_slot)) {
                    ++this.stat_numdeleted_rows_visited;
                    if (!check_row_template[0].isNull()) continue;
                    nulls_not_reached = false;
                    break;
                }
                if (check_row_template[0].isNull()) {
                    nulls_not_reached = false;
                    break;
                }
                pos.current_leaf.page.fetchFromSlot(pos.current_rh, pos.current_slot, fetch_row, this.init_fetchDesc, true);
                ++this.stat_numrows_qualified;
                max_rh = pos.current_rh;
            }
            this.positionAtNextPage(pos);
            ++this.stat_numpages_visited;
        }
        this.positionAtDoneScan(pos);
        --this.stat_numpages_visited;
        return max_rh != null;
    }

    protected int fetchRows(BTreeRowPosition pos, DataValueDescriptor[][] row_array, RowLocation[] rowloc_array, BackingStoreHashtable hash_table, long max_rowcnt, int[] key_column_numbers) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    protected void positionAtStartPosition(BTreeRowPosition pos) throws StandardException {
        SanityManager.ASSERT(this.scan_state == 1);
        SanityManager.ASSERT(pos.current_rh == null);
        SanityManager.ASSERT(pos.current_positionKey == null);
        SanityManager.ASSERT(pos.current_scan_pageno == 0L);
        while (true) {
            ControlRow root = ControlRow.get(this, 1L);
            this.stat_numpages_visited += root.getLevel() + 1;
            if (this.init_startKeyValue != null) {
                throw StandardException.newException("XSCB3.S");
            }
            pos.current_leaf = (LeafControlRow)root.searchRight(this);
            pos.current_slot = pos.current_leaf.page.recordCount();
            boolean exact = false;
            --pos.current_slot;
            boolean latch_released = !this.getLockingPolicy().lockScanRow(this, this.getConglomerate(), pos, true, this.init_lock_fetch_desc, pos.current_lock_template, pos.current_lock_row_loc, false, this.init_forUpdate, this.lock_operation);
            ++pos.current_slot;
            latch_released = BTreeMaxScan.test_errors(this, "BTreeMaxScan_positionAtStartPosition", true, this.getLockingPolicy(), pos.current_leaf, latch_released);
            if (!latch_released) break;
            pos.current_leaf = null;
        }
        this.scan_state = 2;
        pos.current_scan_pageno = pos.current_leaf.page.getPageNumber();
        SanityManager.ASSERT(pos.current_leaf != null);
    }

    public boolean fetchMax(DataValueDescriptor[] fetch_row) throws StandardException {
        BTreeRowPosition pos = this.scan_position;
        int ret_row_count = 0;
        SanityManager.ASSERT(this.container != null, "BTreeMaxScan.fetchMax() called on a closed scan.");
        if (this.scan_state == 2) {
            if (!this.reposition(this.scan_position, true)) {
                SanityManager.THROWASSERT("can not fail with 2nd param true.");
            }
        } else if (this.scan_state == 1) {
            this.positionAtStartPosition(this.scan_position);
        } else {
            SanityManager.ASSERT(this.scan_state == 3);
            return false;
        }
        boolean max_found = false;
        if (pos.current_slot - 1 > 0) {
            --pos.current_slot;
            while (pos.current_slot > 0) {
                ++this.stat_numrows_visited;
                RecordHandle rh = pos.current_leaf.page.fetchFromSlot(null, pos.current_slot, fetch_row, this.init_fetchDesc, true);
                boolean latch_released = !this.getLockingPolicy().lockScanRow(this, this.getConglomerate(), pos, false, this.init_lock_fetch_desc, pos.current_lock_template, pos.current_lock_row_loc, false, this.init_forUpdate, this.lock_operation);
                pos.current_rh = rh;
                if (latch_released) {
                    pos.current_leaf = null;
                    break;
                }
                if (pos.current_leaf.page.isDeletedAtSlot(pos.current_slot)) {
                    ++this.stat_numdeleted_rows_visited;
                    pos.current_rh_qualified = false;
                } else {
                    pos.current_rh_qualified = !fetch_row[0].isNull();
                }
                if (pos.current_rh_qualified) {
                    ++ret_row_count;
                    ++this.stat_numrows_qualified;
                    pos.current_slot = -1;
                    max_found = true;
                    break;
                }
                --pos.current_slot;
            }
        }
        if (pos.current_leaf != null) {
            pos.current_leaf.release();
            pos.current_leaf = null;
        }
        this.positionAtDoneScan(this.scan_position);
        if (!max_found) {
            max_found = this.fetchMaxRowFromBeginning(this.scan_position, fetch_row);
        }
        return max_found;
    }
}

