/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.RowLocationRetRowSource;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.conglomerate.LogicalUndo;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.FetchDescriptor;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.store.access.btree.BTree;
import org.apache.derby.impl.store.access.btree.BTreeLockingPolicy;
import org.apache.derby.impl.store.access.btree.BranchRow;
import org.apache.derby.impl.store.access.btree.ControlRow;
import org.apache.derby.impl.store.access.btree.LeafControlRow;
import org.apache.derby.impl.store.access.btree.OpenBTree;
import org.apache.derby.impl.store.access.btree.SearchParameters;
import org.apache.derby.impl.store.access.conglomerate.ConglomerateUtil;
import org.apache.derby.impl.store.access.conglomerate.TemplateRow;

public class BTreeController
extends OpenBTree
implements ConglomerateController {
    transient DataValueDescriptor[] scratch_template = null;
    boolean get_insert_row_lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reclaim_deleted_rows(OpenBTree open_btree, long pageno) throws StandardException {
        boolean purged_at_least_one_row = false;
        ControlRow controlRow = null;
        try {
            block9: {
                controlRow = ControlRow.get(open_btree, pageno);
                if (controlRow == null) {
                    boolean bl = false;
                    return bl;
                }
                LeafControlRow leaf = (LeafControlRow)controlRow;
                BTreeLockingPolicy btree_locking_policy = open_btree.getLockingPolicy();
                int num_possible_commit_delete = leaf.page.recordCount() - 1 - leaf.page.nonDeletedRecordCount();
                if (num_possible_commit_delete <= 0) break block9;
                if (!btree_locking_policy.lockScanForReclaimSpace(leaf)) break;
                Page page = leaf.page;
                FetchDescriptor lock_fetch_desc = RowUtil.getFetchDescriptorConstant(this.scratch_template.length - 1);
                for (int slot_no = page.recordCount() - 1; slot_no > 0; --slot_no) {
                    if (!page.isDeletedAtSlot(slot_no) || !btree_locking_policy.lockScanCommittedDeletedRow(open_btree, leaf, this.scratch_template, lock_fetch_desc, slot_no)) continue;
                    page.purgeAtSlot(slot_no, 1, true);
                    purged_at_least_one_row = true;
                }
                break;
            }
        }
        catch (ClassCastException cce) {}
        finally {
            if (controlRow != null) {
                controlRow.release();
            }
            return purged_at_least_one_row;
        }
    }

    private long start_xact_and_dosplit(boolean attempt_to_reclaim_deleted_rows, long leaf_pageno, DataValueDescriptor[] scratch_template, DataValueDescriptor[] rowToInsert, int flag) throws StandardException {
        TransactionManager split_xact = null;
        OpenBTree split_open_btree = null;
        ControlRow root = null;
        split_xact = this.init_open_user_scans.getInternalTransaction();
        if ((this.getOpenMode() & 4) != 4) {
            SanityManager.THROWASSERT("Container not opened with update should not cause split");
        }
        boolean do_split = true;
        if (attempt_to_reclaim_deleted_rows) {
            ConglomerateController base_cc = null;
            try {
                base_cc = this.getConglomerate().lockTable(split_xact, 132, 6, 4);
            }
            catch (StandardException se) {
                // empty catch block
            }
            if (base_cc != null) {
                split_open_btree = new OpenBTree();
                split_open_btree.init(this.init_open_user_scans, split_xact, null, split_xact.getRawStoreXact(), false, 132, 6, this.getConglomerate().getBtreeLockingPolicy(split_xact.getRawStoreXact(), 6, 1, 4, base_cc, split_open_btree), this.getConglomerate(), null, null);
                do_split = !this.reclaim_deleted_rows(split_open_btree, leaf_pageno);
                split_open_btree.close();
            }
        }
        long new_leaf_pageno = leaf_pageno;
        if (do_split) {
            split_open_btree = new OpenBTree();
            split_open_btree.init(this.init_open_user_scans, split_xact, null, split_xact.getRawStoreXact(), false, this.getOpenMode(), 5, this.getConglomerate().getBtreeLockingPolicy(split_xact.getRawStoreXact(), this.init_lock_level, 1, 4, null, split_open_btree), this.getConglomerate(), null, null);
            root = ControlRow.get(split_open_btree, 1L);
            SanityManager.ASSERT(root.page.isLatched());
            new_leaf_pageno = root.splitFor(split_open_btree, scratch_template, null, rowToInsert, flag);
            split_open_btree.close();
        }
        split_xact.commit();
        split_xact.destroy();
        return new_leaf_pageno;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int doIns(DataValueDescriptor[] rowToInsert) throws StandardException {
        LeafControlRow targetleaf = null;
        Object save_targetleaf = null;
        int insert_slot = 0;
        int result_slot = 0;
        int ret_val = 0;
        boolean reclaim_deleted_rows_attempted = false;
        if (this.scratch_template == null) {
            this.scratch_template = this.runtime_mem.get_template(this.getRawTran());
        }
        this.isIndexableRowConsistent(rowToInsert);
        SearchParameters sp = new SearchParameters(rowToInsert, 1, this.scratch_template, this, false);
        FetchDescriptor lock_fetch_desc = RowUtil.getFetchDescriptorConstant(this.scratch_template.length - 1);
        RowLocation lock_row_loc = (RowLocation)this.scratch_template[this.scratch_template.length - 1];
        if (this.get_insert_row_lock) {
            this.getLockingPolicy().lockNonScanRow(this.getConglomerate(), null, null, rowToInsert, 3);
        }
        while (true) {
            SanityManager.ASSERT(this.container != null);
            targetleaf = (LeafControlRow)ControlRow.get(this, 1L).search(sp);
            int slot_after_previous = sp.resultExact ? sp.resultSlot : sp.resultSlot + 1;
            boolean latch_released = false;
            latch_released = !this.getLockingPolicy().lockNonScanPreviousRow(this.getConglomerate(), targetleaf, slot_after_previous, lock_fetch_desc, this.scratch_template, lock_row_loc, this, 5, 1);
            latch_released = BTreeController.test_errors(this, "BTreeController_doIns", false, this.getLockingPolicy(), targetleaf, latch_released);
            if (latch_released) {
                targetleaf = null;
                continue;
            }
            if (sp.resultExact) {
                result_slot = insert_slot = sp.resultSlot;
                if (this.getConglomerate().nKeyFields != this.getConglomerate().nUniqueColumns) {
                    boolean bl = latch_released = !this.getLockingPolicy().lockNonScanRowOnPage(this.getConglomerate(), targetleaf, insert_slot, lock_fetch_desc, this.scratch_template, lock_row_loc, 1);
                    if (latch_released) {
                        targetleaf = null;
                        continue;
                    }
                }
                if (!targetleaf.page.isDeletedAtSlot(insert_slot)) {
                    ret_val = 1;
                    break;
                }
                if (this.getConglomerate().nKeyFields == this.getConglomerate().nUniqueColumns) {
                    targetleaf.page.deleteAtSlot(insert_slot, false, this.btree_undo);
                    break;
                }
                if (this.getConglomerate().nUniqueColumns != this.getConglomerate().nKeyFields - 1) throw StandardException.newException("XSCB3.S");
                targetleaf.page.deleteAtSlot(insert_slot, false, this.btree_undo);
                boolean update_succeeded = true;
                try {
                    int rowloc_index = this.getConglomerate().nKeyFields - 1;
                    targetleaf.page.updateFieldAtSlot(insert_slot, rowloc_index, RowUtil.getColumn(rowToInsert, (FormatableBitSet)null, rowloc_index), this.btree_undo);
                }
                catch (StandardException se) {
                    if (!se.getMessageId().equals("XSDA3.S")) {
                        throw se;
                    }
                    update_succeeded = false;
                    targetleaf.page.deleteAtSlot(insert_slot, true, this.btree_undo);
                }
                if (update_succeeded) {
                    break;
                }
            } else {
                int n = targetleaf.page.recordCount() - 1;
                this.getConglomerate();
                if (n < BTree.maxRowsPerPage) {
                    insert_slot = sp.resultSlot + 1;
                    result_slot = insert_slot + 1;
                    if (targetleaf.page.insertAtSlot(insert_slot, rowToInsert, null, this.btree_undo, (byte)1, 50) != null) break;
                    if (targetleaf.page.recordCount() <= 2) {
                        throw StandardException.newException("XSCB6.S");
                    }
                }
            }
            int flag = 0;
            if (insert_slot == 1) {
                flag |= 4;
                if (targetleaf.isLeftmostLeaf()) {
                    flag |= 8;
                }
            } else if (insert_slot == targetleaf.page.recordCount()) {
                flag |= 1;
                if (targetleaf.isRightmostLeaf()) {
                    flag |= 2;
                }
            }
            long targetleaf_pageno = targetleaf.page.getPageNumber();
            if (targetleaf.page.recordCount() - targetleaf.page.nonDeletedRecordCount() <= 0) {
                reclaim_deleted_rows_attempted = true;
            }
            BranchRow branchrow = BranchRow.createBranchRowFromOldLeafRow(rowToInsert, targetleaf_pageno);
            targetleaf.release();
            targetleaf = null;
            this.start_xact_and_dosplit(!reclaim_deleted_rows_attempted, targetleaf_pageno, this.scratch_template, branchrow.getRow(), flag);
            reclaim_deleted_rows_attempted = true;
        }
        targetleaf.last_search_result = result_slot;
        if (SanityManager.DEBUG_ON("enableBtreeConsistencyCheck")) {
            targetleaf.checkConsistency(this, null, true);
        }
        targetleaf.release();
        return ret_val;
    }

    private boolean do_load_insert(DataValueDescriptor[] rowToInsert, LeafControlRow leaf, int insert_slot) throws StandardException {
        Object old_leaf = null;
        boolean row_inserted = false;
        int num_rows_on_page = leaf.page.recordCount() - 1;
        SanityManager.ASSERT(insert_slot == leaf.page.recordCount());
        SanityManager.ASSERT(leaf.getrightSiblingPageNumber() == -1L);
        this.isIndexableRowConsistent(rowToInsert);
        this.getConglomerate();
        if (num_rows_on_page < BTree.maxRowsPerPage) {
            int compare_result;
            if (insert_slot > 1 && (compare_result = ControlRow.compareIndexRowFromPageToKey(leaf, insert_slot - 1, this.scratch_template, rowToInsert, this.getConglomerate().nUniqueColumns, 0, this.getConglomerate().ascDescInfo)) >= 0) {
                SanityManager.THROWASSERT("result = " + compare_result);
            }
            if (leaf.page.insertAtSlot(insert_slot, rowToInsert, null, this.btree_undo, (byte)1, 50) != null) {
                row_inserted = true;
            } else if (leaf.page.recordCount() <= 2) {
                throw StandardException.newException("XSCB6.S");
            }
        }
        if (SanityManager.DEBUG_ON("enableBtreeConsistencyCheck")) {
            leaf.checkConsistency(this, null, true);
        }
        return row_inserted;
    }

    private LeafControlRow do_load_split(DataValueDescriptor[] rowToInsert, LeafControlRow leaf) throws StandardException {
        LeafControlRow new_leaf = null;
        BranchRow branchrow = BranchRow.createBranchRowFromOldLeafRow(rowToInsert, leaf.page.getPageNumber());
        long old_leafpage = leaf.page.getPageNumber();
        leaf.release();
        leaf = null;
        long new_leaf_pageno = this.start_xact_and_dosplit(false, old_leafpage, this.scratch_template, branchrow.getRow(), 3);
        new_leaf = (LeafControlRow)ControlRow.get(this, new_leaf_pageno);
        if (new_leaf.getrightSiblingPageNumber() != -1L) {
            SanityManager.THROWASSERT("new_leaf.getrightSiblingPageNumber() = " + new_leaf.getrightSiblingPageNumber());
        }
        if (new_leaf.page.recordCount() <= 1) {
            SanityManager.THROWASSERT("new_leaf.page.recordCount() = " + new_leaf.page.recordCount());
        }
        return new_leaf;
    }

    public void init(TransactionManager xact_manager, boolean hold, ContainerHandle container, Transaction rawtran, int open_mode, int lock_level, BTreeLockingPolicy btree_locking_policy, BTree conglomerate, LogicalUndo undo, StaticCompiledOpenConglomInfo static_info, DynamicCompiledOpenConglomInfo dynamic_info) throws StandardException {
        this.get_insert_row_lock = (open_mode & 0x4000) == 0;
        super.init(xact_manager, xact_manager, container, rawtran, hold, open_mode, lock_level, btree_locking_policy, conglomerate, undo, dynamic_info);
    }

    public void close() throws StandardException {
        super.close();
        if (this.getXactMgr() != null) {
            this.getXactMgr().closeMe(this);
        }
    }

    public boolean closeForEndTransaction(boolean closeHeldScan) throws StandardException {
        super.close();
        if (!this.getHold() || closeHeldScan) {
            if (this.getXactMgr() != null) {
                this.getXactMgr().closeMe(this);
            }
            return true;
        }
        return false;
    }

    public int insert(DataValueDescriptor[] row) throws StandardException {
        if (this.isClosed()) {
            if (this.getHold()) {
                this.reopen();
            } else {
                throw StandardException.newException("XSCB8.S", new Long(this.err_containerid));
            }
        }
        SanityManager.ASSERT(this.container != null);
        TemplateRow.checkPartialColumnTypes(this.getConglomerate().format_ids, null, null, row);
        return this.doIns(row);
    }

    public boolean isKeyed() {
        return true;
    }

    public void getTableProperties(Properties prop) throws StandardException {
        if (this.container == null) {
            throw StandardException.newException("XSCB8.S", new Long(this.err_containerid));
        }
        this.container.getContainerProperties(prop);
    }

    public Properties getInternalTablePropertySet(Properties prop) throws StandardException {
        Properties ret_properties = ConglomerateUtil.createRawStorePropertySet(prop);
        this.getTableProperties(ret_properties);
        return ret_properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long load(TransactionManager xact_manager, boolean createConglom, RowLocationRetRowSource rowSource) throws StandardException {
        long num_rows_loaded = 0L;
        SanityManager.ASSERT(createConglom, "Cannot load a btree incrementally - it must either be entirely logged, or entirely not logged.  Doesn't make sense to log only the allocation when one cannot guarantee to not touch any pre-existing pages");
        if (this.scratch_template == null) {
            this.scratch_template = this.runtime_mem.get_template(this.getRawTran());
        }
        LeafControlRow current_leaf = null;
        try {
            DataValueDescriptor[] row;
            current_leaf = (LeafControlRow)ControlRow.get(this, 1L);
            int current_insert_slot = 1;
            SanityManager.ASSERT(current_leaf.page.recordCount() == 1);
            FormatableBitSet validColumns = rowSource.getValidColumns();
            while ((row = rowSource.getNextRowFromRowSource()) != null) {
                ++num_rows_loaded;
                SanityManager.ASSERT(validColumns == null, "Does not support partial row");
                while (!this.do_load_insert(row, current_leaf, current_insert_slot)) {
                    current_leaf = this.do_load_split(row, current_leaf);
                    current_insert_slot = current_leaf.page.recordCount();
                }
                ++current_insert_slot;
            }
            current_leaf.release();
            current_leaf = null;
            if (!this.getConglomerate().isTemporary()) {
                this.container.flushContainer();
            }
        }
        finally {
            this.close();
        }
        return num_rows_loaded;
    }

    public boolean delete(RowLocation loc) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    public boolean fetch(RowLocation loc, DataValueDescriptor[] row, FormatableBitSet validColumns) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    public boolean fetch(RowLocation loc, DataValueDescriptor[] row, FormatableBitSet validColumns, boolean waitForLock) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    public void insertAndFetchLocation(DataValueDescriptor[] row, RowLocation templateRowLocation) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    public RowLocation newRowLocationTemplate() throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    public boolean lockRow(RowLocation loc, int lock_operation, boolean wait, int lock_duration) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    public boolean lockRow(long page_num, int record_id, int lock_operation, boolean wait, int lock_duration) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    public void unlockRowAfterRead(RowLocation loc, boolean forUpdate, boolean row_qualifies) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    public boolean replace(RowLocation loc, DataValueDescriptor[] row, FormatableBitSet validColumns) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }
}

