/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.Storable;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.services.stream.HeaderPrintWriter;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.DatabaseInstant;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.FileResource;
import org.apache.derby.iapi.store.access.GroupFetchScanController;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.RowLocationRetRowSource;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.SortController;
import org.apache.derby.iapi.store.access.SortCostController;
import org.apache.derby.iapi.store.access.SortObserver;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.StoreCostController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.access.XATransactionController;
import org.apache.derby.iapi.store.access.conglomerate.Conglomerate;
import org.apache.derby.iapi.store.access.conglomerate.ConglomerateFactory;
import org.apache.derby.iapi.store.access.conglomerate.MethodFactory;
import org.apache.derby.iapi.store.access.conglomerate.ScanControllerRowSource;
import org.apache.derby.iapi.store.access.conglomerate.ScanManager;
import org.apache.derby.iapi.store.access.conglomerate.Sort;
import org.apache.derby.iapi.store.access.conglomerate.SortFactory;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.Loggable;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.store.access.BackingStoreHashTableFromScan;
import org.apache.derby.impl.store.access.RAMAccessManager;
import org.apache.derby.impl.store.access.RAMTransactionContext;
import org.apache.derby.impl.store.access.conglomerate.ConglomerateUtil;

public class RAMTransaction
implements XATransactionController,
TransactionManager {
    protected Transaction rawtran;
    protected RAMAccessManager accessmanager;
    protected RAMTransactionContext context;
    protected RAMTransaction parent_tran;
    private ArrayList scanControllers;
    private ArrayList conglomerateControllers;
    private ArrayList sorts;
    private ArrayList sortControllers;
    private ArrayList freeSortIds;
    protected HashMap tempCongloms;
    private long nextTempConglomId = -1L;
    private boolean alterTableCallMade = false;
    private int transaction_lock_level;

    private final void init(RAMAccessManager myaccessmanager, Transaction theRawTran, RAMTransaction parent_tran) {
        this.rawtran = theRawTran;
        this.parent_tran = parent_tran;
        this.accessmanager = myaccessmanager;
        this.scanControllers = new ArrayList();
        this.conglomerateControllers = new ArrayList();
        this.sorts = null;
        this.freeSortIds = null;
        this.sortControllers = null;
        this.tempCongloms = parent_tran != null ? parent_tran.tempCongloms : null;
    }

    protected RAMTransaction(RAMAccessManager myaccessmanager, Transaction theRawTran, RAMTransaction parent_transaction) throws StandardException {
        this.init(myaccessmanager, theRawTran, parent_transaction);
    }

    RAMTransaction(RAMAccessManager myaccessmanager, RAMTransaction tc, int format_id, byte[] global_id, byte[] branch_id) throws StandardException {
        this.init(myaccessmanager, tc.getRawStoreXact(), null);
        SanityManager.ASSERT(tc.getRawStoreXact().isIdle());
        this.context = tc.context;
        this.context.setTransaction(this);
        this.rawtran.createXATransactionFromLocalTransaction(format_id, global_id, branch_id);
        tc.rawtran = null;
    }

    RAMTransaction() {
    }

    protected void closeControllers(boolean closeHeldControllers) throws StandardException {
        Object sc;
        int i;
        if (!this.scanControllers.isEmpty()) {
            for (i = this.scanControllers.size() - 1; i >= 0; --i) {
                sc = (ScanManager)this.scanControllers.get(i);
                if (!sc.closeForEndTransaction(closeHeldControllers)) continue;
            }
            if (closeHeldControllers) {
                SanityManager.ASSERT(this.scanControllers.isEmpty());
                this.scanControllers.clear();
            }
        }
        if (!this.conglomerateControllers.isEmpty()) {
            for (i = this.conglomerateControllers.size() - 1; i >= 0; --i) {
                ConglomerateController cc = (ConglomerateController)this.conglomerateControllers.get(i);
                if (!cc.closeForEndTransaction(closeHeldControllers)) continue;
            }
            if (closeHeldControllers) {
                SanityManager.ASSERT(this.scanControllers.isEmpty());
                this.conglomerateControllers.clear();
            }
        }
        if (this.sortControllers != null && !this.sortControllers.isEmpty() && closeHeldControllers) {
            for (i = this.sortControllers.size() - 1; i >= 0; --i) {
                sc = (SortController)this.sortControllers.get(i);
                sc.completedInserts();
            }
            this.sortControllers.clear();
        }
        if (this.sorts != null && !this.sorts.isEmpty() && closeHeldControllers) {
            for (i = this.sorts.size() - 1; i >= 0; --i) {
                Sort sort = (Sort)this.sorts.get(i);
                if (sort == null) continue;
                sort.drop(this);
            }
            this.sorts.clear();
            this.freeSortIds.clear();
        }
    }

    private LockingPolicy determine_locking_policy(int requested_lock_level, int isolation_level) {
        LockingPolicy ret_locking_policy = this.accessmanager.getSystemLockLevel() == 7 || requested_lock_level == 7 ? this.accessmanager.table_level_policy[isolation_level] : this.accessmanager.record_level_policy[isolation_level];
        return ret_locking_policy;
    }

    private int determine_lock_level(int requested_lock_level) {
        int ret_lock_level = this.accessmanager.getSystemLockLevel() == 7 || requested_lock_level == 7 ? 7 : 6;
        return ret_lock_level;
    }

    private Conglomerate findExistingConglomerate(long conglomId) throws StandardException {
        Conglomerate conglom = null;
        if (conglomId < 0L) {
            if (this.tempCongloms != null) {
                conglom = (Conglomerate)this.tempCongloms.get(new Long(conglomId));
            }
        } else {
            conglom = this.accessmanager.conglomCacheFind(this, conglomId);
        }
        if (conglom == null) {
            throw StandardException.newException("XSAI2.S", new Long(conglomId));
        }
        return conglom;
    }

    private Conglomerate findConglomerate(long conglomId) throws StandardException {
        Conglomerate conglom = null;
        if (conglomId >= 0L) {
            conglom = this.accessmanager.conglomCacheFind(this, conglomId);
        } else if (this.tempCongloms != null) {
            conglom = (Conglomerate)this.tempCongloms.get(new Long(conglomId));
        }
        return conglom;
    }

    void setContext(RAMTransactionContext rtc) {
        this.context = rtc;
    }

    public long[] getCacheStats(String cacheName) {
        return this.getRawStoreXact().getCacheStats(cacheName);
    }

    private ConglomerateController openConglomerate(Conglomerate conglom, boolean hold, int open_mode, int lock_level, int isolation_level, StaticCompiledOpenConglomInfo static_info, DynamicCompiledOpenConglomInfo dynamic_info) throws StandardException {
        if ((open_mode & Short.MIN_VALUE) != 0) {
            SanityManager.THROWASSERT("Bad open mode to openConglomerate:" + Integer.toHexString(open_mode));
        }
        SanityManager.ASSERT(conglom != null);
        if (lock_level != 6 && lock_level != 7) {
            SanityManager.THROWASSERT("Bad lock level to openConglomerate:" + lock_level);
        }
        ConglomerateController cc = conglom.open(this, this.rawtran, hold, open_mode, this.determine_lock_level(lock_level), this.determine_locking_policy(lock_level, isolation_level), static_info, dynamic_info);
        this.conglomerateControllers.add(cc);
        return cc;
    }

    private ScanController openScan(Conglomerate conglom, boolean hold, int open_mode, int lock_level, int isolation_level, FormatableBitSet scanColumnList, DataValueDescriptor[] startKeyValue, int startSearchOperator, Qualifier[][] qualifier, DataValueDescriptor[] stopKeyValue, int stopSearchOperator, StaticCompiledOpenConglomInfo static_info, DynamicCompiledOpenConglomInfo dynamic_info) throws StandardException {
        if ((open_mode & 0xFFFFCF3B) != 0) {
            SanityManager.THROWASSERT("Bad open mode to openScan:" + Integer.toHexString(open_mode));
        }
        if (!(lock_level == 6 | lock_level == 7)) {
            SanityManager.THROWASSERT("Bad lock level to openScan:" + lock_level);
        }
        ScanManager sm = conglom.openScan(this, this.rawtran, hold, open_mode, this.determine_lock_level(lock_level), this.determine_locking_policy(lock_level, isolation_level), isolation_level, scanColumnList, startKeyValue, startSearchOperator, qualifier, stopKeyValue, stopSearchOperator, static_info, dynamic_info);
        this.scanControllers.add(sm);
        return sm;
    }

    public void resetCacheStats(String cacheName) {
        this.getRawStoreXact().resetCacheStats(cacheName);
    }

    protected void invalidateConglomerateCache() throws StandardException {
        if (this.alterTableCallMade) {
            this.accessmanager.conglomCacheInvalidate();
            this.alterTableCallMade = false;
        }
    }

    public void addColumnToConglomerate(long conglomId, int column_id, Storable template_column, int collation_id) throws StandardException {
        boolean is_temporary = conglomId < 0L;
        Conglomerate conglom = this.findConglomerate(conglomId);
        if (conglom == null) {
            throw StandardException.newException("XSAM2.S", new Long(conglomId));
        }
        ConglomerateController cc = conglom.open(this, this.rawtran, false, 4, 7, this.accessmanager.table_level_policy[5], null, null);
        conglom.addColumn(this, column_id, template_column, collation_id);
        if (is_temporary) {
            if (this.tempCongloms != null) {
                this.tempCongloms.remove(new Long(conglomId));
            }
            this.tempCongloms.put(new Long(conglomId), conglom);
        } else {
            this.alterTableCallMade = true;
            this.accessmanager.conglomCacheUpdateEntry(conglomId, conglom);
        }
        cc.close();
    }

    public StaticCompiledOpenConglomInfo getStaticCompiledConglomInfo(long conglomId) throws StandardException {
        return this.findExistingConglomerate(conglomId).getStaticCompiledConglomInfo(this, conglomId);
    }

    public DynamicCompiledOpenConglomInfo getDynamicCompiledConglomInfo(long conglomId) throws StandardException {
        return this.findExistingConglomerate(conglomId).getDynamicCompiledConglomInfo(conglomId);
    }

    private final int countCreatedSorts() {
        int ret_val = 0;
        if (this.sorts != null) {
            for (int i = 0; i < this.sorts.size(); ++i) {
                if (this.sorts.get(i) == null) continue;
                ++ret_val;
            }
        }
        return ret_val;
    }

    public int countOpens(int which_to_count) throws StandardException {
        int ret_val = -1;
        switch (which_to_count) {
            case 1: {
                ret_val = this.conglomerateControllers.size();
                break;
            }
            case 2: {
                ret_val = this.scanControllers.size();
                break;
            }
            case 3: {
                ret_val = this.countCreatedSorts();
                break;
            }
            case 4: {
                ret_val = this.sortControllers != null ? this.sortControllers.size() : 0;
                break;
            }
            case 5: {
                ret_val = this.conglomerateControllers.size() + this.scanControllers.size() + (this.sortControllers != null ? this.sortControllers.size() : 0) + this.countCreatedSorts();
            }
        }
        return ret_val;
    }

    public long createConglomerate(String implementation, DataValueDescriptor[] template, ColumnOrdering[] columnOrder, int[] collationIds, Properties properties, int temporaryFlag) throws StandardException {
        long conglomId;
        long conglomid;
        int segment;
        MethodFactory mfactory = this.accessmanager.findMethodFactoryByImpl(implementation);
        if (mfactory == null || !(mfactory instanceof ConglomerateFactory)) {
            throw StandardException.newException("XSAM3.S", implementation);
        }
        ConglomerateFactory cfactory = (ConglomerateFactory)mfactory;
        if ((temporaryFlag & 1) == 1) {
            segment = -1;
            conglomid = 0L;
        } else {
            segment = 0;
            conglomid = this.accessmanager.getNextConglomId(cfactory.getConglomerateFactoryId());
        }
        Conglomerate conglom = cfactory.createConglomerate(this, segment, conglomid, template, columnOrder, collationIds, properties, temporaryFlag);
        if ((temporaryFlag & 1) == 1) {
            conglomId = this.nextTempConglomId--;
            if (this.tempCongloms == null) {
                this.tempCongloms = new HashMap();
            }
            this.tempCongloms.put(new Long(conglomId), conglom);
        } else {
            conglomId = conglom.getContainerid();
            this.accessmanager.conglomCacheAddEntry(conglomId, conglom);
        }
        return conglomId;
    }

    public long createAndLoadConglomerate(String implementation, DataValueDescriptor[] template, ColumnOrdering[] columnOrder, int[] collationIds, Properties properties, int temporaryFlag, RowLocationRetRowSource rowSource, long[] rowCount) throws StandardException {
        return this.recreateAndLoadConglomerate(implementation, true, template, columnOrder, collationIds, properties, temporaryFlag, 0L, rowSource, rowCount);
    }

    public long recreateAndLoadConglomerate(String implementation, boolean recreate_ifempty, DataValueDescriptor[] template, ColumnOrdering[] columnOrder, int[] collationIds, Properties properties, int temporaryFlag, long orig_conglomId, RowLocationRetRowSource rowSource, long[] rowCount) throws StandardException {
        long conglomId = this.createConglomerate(implementation, template, columnOrder, collationIds, properties, temporaryFlag);
        long rows_loaded = this.loadConglomerate(conglomId, true, rowSource);
        if (rowCount != null) {
            rowCount[0] = rows_loaded;
        }
        if (!recreate_ifempty && rows_loaded == 0L) {
            this.dropConglomerate(conglomId);
            conglomId = orig_conglomId;
        }
        return conglomId;
    }

    public String debugOpened() throws StandardException {
        Object sc;
        String str = null;
        str = new String();
        Iterator it = this.scanControllers.iterator();
        while (it.hasNext()) {
            sc = (ScanController)it.next();
            str = str + "open scan controller: " + sc + "\n";
        }
        it = this.conglomerateControllers.iterator();
        while (it.hasNext()) {
            ConglomerateController cc = (ConglomerateController)it.next();
            str = str + "open conglomerate controller: " + cc + "\n";
        }
        if (this.sortControllers != null) {
            it = this.sortControllers.iterator();
            while (it.hasNext()) {
                sc = (SortController)it.next();
                str = str + "open sort controller: " + sc + "\n";
            }
        }
        if (this.sorts != null) {
            for (int i = 0; i < this.sorts.size(); ++i) {
                Sort sort = (Sort)this.sorts.get(i);
                if (sort == null) continue;
                str = str + "sorts created by createSort() in current xact:" + sort + "\n";
            }
        }
        if (this.tempCongloms != null) {
            Iterator it2 = this.tempCongloms.keySet().iterator();
            while (it2.hasNext()) {
                Long conglomId = (Long)it2.next();
                Conglomerate c = (Conglomerate)this.tempCongloms.get(conglomId);
                str = str + "temp conglomerate id = " + conglomId + ": " + c;
            }
        }
        return str;
    }

    public boolean conglomerateExists(long conglomId) throws StandardException {
        Conglomerate conglom = this.findConglomerate(conglomId);
        return conglom != null;
    }

    public void dropConglomerate(long conglomId) throws StandardException {
        Conglomerate conglom = this.findExistingConglomerate(conglomId);
        conglom.drop(this);
        if (conglomId < 0L) {
            if (this.tempCongloms != null) {
                this.tempCongloms.remove(new Long(conglomId));
            }
        } else {
            this.accessmanager.conglomCacheRemoveEntry(conglomId);
        }
    }

    public boolean fetchMaxOnBtree(long conglomId, int open_mode, int lock_level, int isolation_level, FormatableBitSet scanColumnList, DataValueDescriptor[] fetchRow) throws StandardException {
        Conglomerate conglom = this.findExistingConglomerate(conglomId);
        return conglom.fetchMaxOnBTree(this, this.rawtran, conglomId, open_mode, lock_level, this.determine_locking_policy(lock_level, isolation_level), isolation_level, scanColumnList, fetchRow);
    }

    public Properties getUserCreateConglomPropList() {
        Properties ret_properties = ConglomerateUtil.createUserRawStorePropertySet(null);
        return ret_properties;
    }

    public boolean isIdle() {
        return this.rawtran.isIdle();
    }

    public boolean isGlobal() {
        return this.rawtran.getGlobalId() != null;
    }

    public boolean isPristine() {
        return this.rawtran.isPristine();
    }

    public Object createXATransactionFromLocalTransaction(int format_id, byte[] global_id, byte[] branch_id) throws StandardException {
        this.getRawStoreXact().createXATransactionFromLocalTransaction(format_id, global_id, branch_id);
        return this;
    }

    public long loadConglomerate(long conglomId, boolean createConglom, RowLocationRetRowSource rowSource) throws StandardException {
        Conglomerate conglom = this.findExistingConglomerate(conglomId);
        return conglom.load(this, createConglom, rowSource);
    }

    public void loadConglomerate(long conglomId, RowLocationRetRowSource rowSource) throws StandardException {
        this.loadConglomerate(conglomId, false, rowSource);
    }

    public void logAndDo(Loggable operation) throws StandardException {
        this.rawtran.logAndDo(operation);
    }

    public ConglomerateController openCompiledConglomerate(boolean hold, int open_mode, int lock_level, int isolation_level, StaticCompiledOpenConglomInfo static_info, DynamicCompiledOpenConglomInfo dynamic_info) throws StandardException {
        SanityManager.ASSERT(static_info != null);
        SanityManager.ASSERT(dynamic_info != null);
        return this.openConglomerate((Conglomerate)static_info.getConglom(), hold, open_mode, lock_level, isolation_level, static_info, dynamic_info);
    }

    public ConglomerateController openConglomerate(long conglomId, boolean hold, int open_mode, int lock_level, int isolation_level) throws StandardException {
        return this.openConglomerate(this.findExistingConglomerate(conglomId), hold, open_mode, lock_level, isolation_level, null, null);
    }

    public long findConglomid(long container_id) throws StandardException {
        return container_id;
    }

    public long findContainerid(long conglom_id) throws StandardException {
        return conglom_id;
    }

    public BackingStoreHashtable createBackingStoreHashtableFromScan(long conglomId, int open_mode, int lock_level, int isolation_level, FormatableBitSet scanColumnList, DataValueDescriptor[] startKeyValue, int startSearchOperator, Qualifier[][] qualifier, DataValueDescriptor[] stopKeyValue, int stopSearchOperator, long max_rowcnt, int[] key_column_numbers, boolean remove_duplicates, long estimated_rowcnt, long max_inmemory_rowcnt, int initialCapacity, float loadFactor, boolean collect_runtimestats, boolean skipNullKeyColumns, boolean keepAfterCommit) throws StandardException {
        return new BackingStoreHashTableFromScan(this, conglomId, open_mode, lock_level, isolation_level, scanColumnList, startKeyValue, startSearchOperator, qualifier, stopKeyValue, stopSearchOperator, max_rowcnt, key_column_numbers, remove_duplicates, estimated_rowcnt, max_inmemory_rowcnt, initialCapacity, loadFactor, collect_runtimestats, skipNullKeyColumns, keepAfterCommit);
    }

    public GroupFetchScanController openGroupFetchScan(long conglomId, boolean hold, int open_mode, int lock_level, int isolation_level, FormatableBitSet scanColumnList, DataValueDescriptor[] startKeyValue, int startSearchOperator, Qualifier[][] qualifier, DataValueDescriptor[] stopKeyValue, int stopSearchOperator) throws StandardException {
        if ((open_mode & 0xFFFFDFBB) != 0) {
            SanityManager.THROWASSERT("Bad open mode to openScan:" + Integer.toHexString(open_mode));
        }
        if (!(lock_level == 6 | lock_level == 7)) {
            SanityManager.THROWASSERT("Bad lock level to openScan:" + lock_level);
        }
        Conglomerate conglom = this.findExistingConglomerate(conglomId);
        ScanManager sm = conglom.openScan(this, this.rawtran, hold, open_mode, this.determine_lock_level(lock_level), this.determine_locking_policy(lock_level, isolation_level), isolation_level, scanColumnList, startKeyValue, startSearchOperator, qualifier, stopKeyValue, stopSearchOperator, null, null);
        this.scanControllers.add(sm);
        return sm;
    }

    public void purgeConglomerate(long conglomId) throws StandardException {
        this.findExistingConglomerate(conglomId).purgeConglomerate(this, this.rawtran);
    }

    public void compressConglomerate(long conglomId) throws StandardException {
        this.findExistingConglomerate(conglomId).compressConglomerate(this, this.rawtran);
    }

    public GroupFetchScanController defragmentConglomerate(long conglomId, boolean online, boolean hold, int open_mode, int lock_level, int isolation_level) throws StandardException {
        if ((open_mode & 0xFFFFDFBB) != 0) {
            SanityManager.THROWASSERT("Bad open mode to openScan:" + Integer.toHexString(open_mode));
        }
        if (!(lock_level == 6 | lock_level == 7)) {
            SanityManager.THROWASSERT("Bad lock level to openScan:" + lock_level);
        }
        Conglomerate conglom = this.findExistingConglomerate(conglomId);
        ScanManager sm = conglom.defragmentConglomerate(this, this.rawtran, hold, open_mode, this.determine_lock_level(lock_level), this.determine_locking_policy(lock_level, isolation_level), isolation_level);
        this.scanControllers.add(sm);
        return sm;
    }

    public ScanController openScan(long conglomId, boolean hold, int open_mode, int lock_level, int isolation_level, FormatableBitSet scanColumnList, DataValueDescriptor[] startKeyValue, int startSearchOperator, Qualifier[][] qualifier, DataValueDescriptor[] stopKeyValue, int stopSearchOperator) throws StandardException {
        return this.openScan(this.findExistingConglomerate(conglomId), hold, open_mode, lock_level, isolation_level, scanColumnList, startKeyValue, startSearchOperator, qualifier, stopKeyValue, stopSearchOperator, null, null);
    }

    public ScanController openCompiledScan(boolean hold, int open_mode, int lock_level, int isolation_level, FormatableBitSet scanColumnList, DataValueDescriptor[] startKeyValue, int startSearchOperator, Qualifier[][] qualifier, DataValueDescriptor[] stopKeyValue, int stopSearchOperator, StaticCompiledOpenConglomInfo static_info, DynamicCompiledOpenConglomInfo dynamic_info) throws StandardException {
        SanityManager.ASSERT(static_info != null);
        SanityManager.ASSERT(dynamic_info != null);
        SanityManager.ASSERT(static_info instanceof StaticCompiledOpenConglomInfo);
        SanityManager.ASSERT(dynamic_info instanceof DynamicCompiledOpenConglomInfo);
        return this.openScan((Conglomerate)static_info.getConglom(), hold, open_mode, lock_level, isolation_level, scanColumnList, startKeyValue, startSearchOperator, qualifier, stopKeyValue, stopSearchOperator, static_info, dynamic_info);
    }

    public StoreCostController openStoreCost(long conglomId) throws StandardException {
        Conglomerate conglom = this.findExistingConglomerate(conglomId);
        StoreCostController scc = conglom.openStoreCost(this, this.rawtran);
        return scc;
    }

    public long createSort(Properties implParameters, DataValueDescriptor[] template, ColumnOrdering[] columnOrdering, SortObserver sortObserver, boolean alreadyInOrder, long estimatedRows, int estimatedRowSize) throws StandardException {
        int sortid;
        MethodFactory mfactory;
        String implementation = null;
        if (implParameters != null) {
            implementation = implParameters.getProperty("implType");
        }
        if (implementation == null) {
            implementation = "sort external";
        }
        if ((mfactory = this.accessmanager.findMethodFactoryByImpl(implementation)) == null || !(mfactory instanceof SortFactory)) {
            throw StandardException.newException("XSAM0.S", implementation);
        }
        SortFactory sfactory = (SortFactory)mfactory;
        int segment = 0;
        Sort sort = sfactory.createSort(this, segment, implParameters, template, columnOrdering, sortObserver, alreadyInOrder, estimatedRows, estimatedRowSize);
        if (this.sorts == null) {
            this.sorts = new ArrayList();
            this.freeSortIds = new ArrayList();
        }
        if (this.freeSortIds.isEmpty()) {
            sortid = this.sorts.size();
            this.sorts.add(sort);
        } else {
            sortid = (Integer)this.freeSortIds.remove(this.freeSortIds.size() - 1);
            this.sorts.set(sortid, sort);
        }
        return sortid;
    }

    public void dropSort(long sortid) throws StandardException {
        Sort sort = (Sort)this.sorts.get((int)sortid);
        if (sort != null) {
            sort.drop(this);
            this.sorts.set((int)sortid, null);
            this.freeSortIds.add(ReuseFactory.getInteger((int)sortid));
        }
    }

    public Serializable getProperty(String key) throws StandardException {
        return this.accessmanager.getTransactionalProperties().getProperty(this, key);
    }

    public Serializable getPropertyDefault(String key) throws StandardException {
        return this.accessmanager.getTransactionalProperties().getPropertyDefault(this, key);
    }

    public void setProperty(String key, Serializable value, boolean dbOnlyProperty) throws StandardException {
        this.accessmanager.getTransactionalProperties().setProperty(this, key, value, dbOnlyProperty);
    }

    public void setPropertyDefault(String key, Serializable value) throws StandardException {
        this.accessmanager.getTransactionalProperties().setPropertyDefault(this, key, value);
    }

    public boolean propertyDefaultIsVisible(String key) throws StandardException {
        return this.accessmanager.getTransactionalProperties().propertyDefaultIsVisible(this, key);
    }

    public Properties getProperties() throws StandardException {
        return this.accessmanager.getTransactionalProperties().getProperties(this);
    }

    public SortController openSort(long id) throws StandardException {
        Sort sort;
        if (this.sorts == null || id >= (long)this.sorts.size() || (sort = (Sort)this.sorts.get((int)id)) == null) {
            throw StandardException.newException("XSAM4.S", new Long(id));
        }
        SortController sc = sort.open(this);
        if (this.sortControllers == null) {
            this.sortControllers = new ArrayList();
        }
        this.sortControllers.add(sc);
        return sc;
    }

    public SortCostController openSortCostController(Properties implParameters) throws StandardException {
        MethodFactory mfactory;
        String implementation = null;
        if (implementation == null) {
            implementation = "sort external";
        }
        if ((mfactory = this.accessmanager.findMethodFactoryByImpl(implementation)) == null || !(mfactory instanceof SortFactory)) {
            throw StandardException.newException("XSAM0.S", implementation);
        }
        SortFactory sfactory = (SortFactory)mfactory;
        return sfactory.openSortCostController();
    }

    public ScanController openSortScan(long id, boolean hold) throws StandardException {
        Sort sort;
        if (this.sorts == null || id >= (long)this.sorts.size() || (sort = (Sort)this.sorts.get((int)id)) == null) {
            throw StandardException.newException("XSAM4.S", new Long(id));
        }
        ScanController sc = sort.openSortScan(this, hold);
        this.scanControllers.add(sc);
        return sc;
    }

    public RowLocationRetRowSource openSortRowSource(long id) throws StandardException {
        Sort sort;
        if (this.sorts == null || id >= (long)this.sorts.size() || (sort = (Sort)this.sorts.get((int)id)) == null) {
            throw StandardException.newException("XSAM4.S", new Long(id));
        }
        ScanControllerRowSource sc = sort.openSortRowSource(this);
        this.scanControllers.add(sc);
        return sc;
    }

    public void commit() throws StandardException {
        this.closeControllers(false);
        this.rawtran.commit();
        this.alterTableCallMade = false;
    }

    public DatabaseInstant commitNoSync(int commitflag) throws StandardException {
        this.closeControllers(false);
        return this.rawtran.commitNoSync(commitflag);
    }

    public void abort() throws StandardException {
        if (this.alterTableCallMade) {
            this.accessmanager.conglomCacheInvalidate();
            this.alterTableCallMade = false;
        }
        this.closeControllers(true);
        this.rawtran.abort();
        if (this.parent_tran != null) {
            this.parent_tran.abort();
        }
    }

    public ContextManager getContextManager() {
        return this.context.getContextManager();
    }

    public int setSavePoint(String name, Object kindOfSavepoint) throws StandardException {
        return this.rawtran.setSavePoint(name, kindOfSavepoint);
    }

    public int releaseSavePoint(String name, Object kindOfSavepoint) throws StandardException {
        return this.rawtran.releaseSavePoint(name, kindOfSavepoint);
    }

    public int rollbackToSavePoint(String name, boolean close_controllers, Object kindOfSavepoint) throws StandardException {
        if (close_controllers) {
            this.closeControllers(true);
        }
        return this.rawtran.rollbackToSavePoint(name, kindOfSavepoint);
    }

    public void destroy() {
        try {
            this.closeControllers(true);
            if (this.rawtran != null) {
                this.rawtran.destroy();
                this.rawtran = null;
            }
            if (this.context != null) {
                this.context.popMe();
            }
            this.context = null;
            this.accessmanager = null;
            this.tempCongloms = null;
        }
        catch (StandardException e) {
            this.rawtran = null;
            this.context = null;
            this.accessmanager = null;
            this.tempCongloms = null;
        }
    }

    public boolean anyoneBlocked() {
        return this.rawtran.anyoneBlocked();
    }

    public void xa_commit(boolean onePhase) throws StandardException {
        this.rawtran.xa_commit(onePhase);
    }

    public int xa_prepare() throws StandardException {
        return this.rawtran.xa_prepare();
    }

    public void xa_rollback() throws StandardException {
        this.rawtran.xa_rollback();
    }

    public void addPostCommitWork(Serviceable work) {
        this.rawtran.addPostCommitWork(work);
    }

    public boolean checkVersion(int requiredMajorVersion, int requiredMinorVersion, String feature) throws StandardException {
        return this.accessmanager.getRawStore().checkVersion(requiredMajorVersion, requiredMinorVersion, feature);
    }

    public void closeMe(ConglomerateController conglom_control) {
        this.conglomerateControllers.remove(conglom_control);
    }

    public void closeMe(SortController sort_control) {
        this.sortControllers.remove(sort_control);
    }

    public void closeMe(ScanManager scan) {
        this.scanControllers.remove(scan);
    }

    public AccessFactory getAccessManager() {
        return this.accessmanager;
    }

    public TransactionManager getInternalTransaction() throws StandardException {
        ContextManager cm = this.getContextManager();
        Transaction rawtran = this.accessmanager.getRawStore().startInternalTransaction(cm);
        RAMTransaction rt = new RAMTransaction(this.accessmanager, rawtran, null);
        RAMTransactionContext rtc = new RAMTransactionContext(cm, "RAMInternalContext", rt, true);
        rawtran.setDefaultLockingPolicy(this.accessmanager.getDefaultLockingPolicy());
        return rt;
    }

    public TransactionController startNestedUserTransaction(boolean readOnly) throws StandardException {
        ContextManager cm = this.getContextManager();
        Transaction child_rawtran = readOnly ? this.accessmanager.getRawStore().startNestedReadOnlyUserTransaction(this.getLockSpace(), cm, "nestedReadOnlyUserTransaction") : this.accessmanager.getRawStore().startNestedUpdateUserTransaction(cm, "nestedUpdateUserTransaction");
        RAMTransaction rt = new RAMTransaction(this.accessmanager, child_rawtran, this);
        RAMTransactionContext rtc = new RAMTransactionContext(cm, "RAMChildContext", rt, true);
        child_rawtran.setDefaultLockingPolicy(this.accessmanager.getDefaultLockingPolicy());
        return rt;
    }

    public Transaction getRawStoreXact() {
        return this.rawtran;
    }

    public void saveScanPositions(Conglomerate conglom, Page page) throws StandardException {
        Iterator it = this.scanControllers.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof ScanManager)) {
                HeaderPrintWriter istream = Monitor.getStream();
                if (o == null) {
                    istream.println("next element was null\n");
                } else {
                    istream.println("non ScanManager on list: " + o);
                }
                istream.println("Current list of open scans: " + this.debugOpened());
            }
            ScanManager sm = (ScanManager)o;
            sm.savePosition(conglom, page);
        }
    }

    public FileResource getFileHandler() {
        return this.rawtran.getFileHandler();
    }

    public CompatibilitySpace getLockSpace() {
        return this.rawtran.getCompatibilitySpace();
    }

    public String getTransactionIdString() {
        return this.rawtran.toString();
    }

    public String getActiveStateTxIdString() {
        return this.rawtran.getActiveStateTxIdString();
    }

    public String toString() {
        String str = null;
        str = "rawtran = " + this.rawtran;
        return str;
    }
}

