/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.util.Vector;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.impl.sql.execute.rts.RealNoPutResultSetStatistics;
import org.apache.derby.impl.sql.execute.rts.ResultSetStatistics;

public class RealAnyResultSetStatistics
extends RealNoPutResultSetStatistics {
    public int subqueryNumber;
    public int pointOfAttachment;
    public ResultSetStatistics childResultSetStatistics;

    public RealAnyResultSetStatistics(int numOpens, int rowsSeen, int rowsFiltered, long constructorTime, long openTime, long nextTime, long closeTime, int resultSetNumber, int subqueryNumber, int pointOfAttachment, double optimizerEstimatedRowCount, double optimizerEstimatedCost, ResultSetStatistics childResultSetStatistics) {
        super(numOpens, rowsSeen, rowsFiltered, constructorTime, openTime, nextTime, closeTime, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.subqueryNumber = subqueryNumber;
        this.pointOfAttachment = pointOfAttachment;
        this.childResultSetStatistics = childResultSetStatistics;
    }

    public String getStatementExecutionPlanText(int depth) {
        String attachmentString = this.pointOfAttachment == -1 ? ":" : " (" + MessageService.getTextMessage("43X00.U") + " " + this.pointOfAttachment + "):";
        this.initFormatInfo(depth);
        return this.indent + MessageService.getTextMessage("43X01.U") + " " + this.subqueryNumber + "\n" + this.indent + MessageService.getTextMessage("43X02.U") + " " + attachmentString + "\n" + this.indent + MessageService.getTextMessage("43X03.U") + " = " + this.numOpens + "\n" + this.indent + MessageService.getTextMessage("43X04.U") + " = " + this.rowsSeen + "\n" + this.dumpTimeStats(this.indent, this.subIndent) + "\n" + this.dumpEstimatedCosts(this.subIndent) + "\n" + this.indent + MessageService.getTextMessage("43X05.U") + ":\n" + this.childResultSetStatistics.getStatementExecutionPlanText(this.sourceDepth) + "\n" + this.indent + MessageService.getTextMessage("43X06.U") + " " + this.subqueryNumber + "\n";
    }

    public String getScanStatisticsText(String tableName, int depth) {
        return this.childResultSetStatistics.getScanStatisticsText(tableName, depth);
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    public Vector getChildren() {
        Vector<ResultSetStatistics> children = new Vector<ResultSetStatistics>();
        children.addElement(this.childResultSetStatistics);
        return children;
    }

    public String getNodeName() {
        return MessageService.getTextMessage("43X02.U");
    }
}

