/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;

public class ValueRow
implements ExecRow,
Formatable {
    private DataValueDescriptor[] column;
    private int ncols;

    public ValueRow() {
    }

    public ValueRow(int ncols) {
        this.column = new DataValueDescriptor[ncols];
        this.ncols = ncols;
    }

    public int nColumns() {
        return this.ncols;
    }

    public void getNewObjectArray() {
        this.column = new DataValueDescriptor[this.ncols];
    }

    public DataValueDescriptor getColumn(int position) {
        if (position <= this.column.length) {
            return this.column[position - 1];
        }
        return null;
    }

    public void setColumn(int position, DataValueDescriptor col) {
        if (position > this.column.length) {
            this.realloc(position);
        }
        this.column[position - 1] = col;
    }

    public ExecRow getClone() {
        return this.getClone(null);
    }

    public ExecRow getClone(FormatableBitSet clonedCols) {
        int numColumns = this.column.length;
        ExecRow rowClone = this.cloneMe();
        for (int colCtr = 0; colCtr < numColumns; ++colCtr) {
            if (clonedCols != null && !clonedCols.get(colCtr + 1)) {
                rowClone.setColumn(colCtr + 1, this.column[colCtr]);
                continue;
            }
            if (this.column[colCtr] == null) continue;
            rowClone.setColumn(colCtr + 1, this.column[colCtr].getClone());
        }
        return rowClone;
    }

    public ExecRow getNewNullRow() {
        int numColumns = this.column.length;
        ExecRow rowClone = this.cloneMe();
        for (int colCtr = 0; colCtr < numColumns; ++colCtr) {
            if (this.column[colCtr] == null) continue;
            if (this.column[colCtr] instanceof RowLocation) {
                rowClone.setColumn(colCtr + 1, this.column[colCtr].getClone());
                continue;
            }
            rowClone.setColumn(colCtr + 1, this.column[colCtr].getNewNull());
        }
        return rowClone;
    }

    ExecRow cloneMe() {
        return new ValueRow(this.ncols);
    }

    public void resetRowArray() {
        for (int i = 0; i < this.column.length; ++i) {
            if (this.column[i] == null) continue;
            this.column[i] = this.column[i].recycle();
        }
    }

    public final DataValueDescriptor cloneColumn(int columnPosition) {
        return this.column[columnPosition - 1].getClone();
    }

    public String toString() {
        String s = "{ ";
        for (int i = 0; i < this.column.length; ++i) {
            s = this.column[i] == null ? s + "null" : s + this.column[i].toString();
            if (i >= this.column.length - 1) continue;
            s = s + ", ";
        }
        s = s + " }";
        return s;
    }

    public DataValueDescriptor[] getRowArray() {
        return this.column;
    }

    public DataValueDescriptor[] getRowArrayClone() {
        int numColumns = this.column.length;
        DataValueDescriptor[] columnClones = new DataValueDescriptor[numColumns];
        for (int colCtr = 0; colCtr < numColumns; ++colCtr) {
            if (this.column[colCtr] == null) continue;
            columnClones[colCtr] = this.column[colCtr].getClone();
        }
        return columnClones;
    }

    public void setRowArray(DataValueDescriptor[] value) {
        this.column = value;
    }

    protected void realloc(int ncols) {
        DataValueDescriptor[] newcol = new DataValueDescriptor[ncols];
        System.arraycopy(this.column, 0, newcol, 0, this.column.length);
        this.column = newcol;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.column = new DataValueDescriptor[ArrayUtil.readArrayLength(in)];
        ArrayUtil.readArrayItems(in, this.column);
        this.ncols = this.column.length;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        ArrayUtil.writeArrayLength(out, this.column);
        ArrayUtil.writeArrayItems(out, this.column);
    }

    public int getTypeFormatId() {
        return 237;
    }
}

