/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.FormatableHashtable;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionContext;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;
import org.apache.derby.impl.sql.execute.UpdatableVTIConstantAction;
import org.apache.derby.vti.DeferModification;
import org.apache.derby.vti.IFastPath;
import org.apache.derby.vti.IQualifyable;
import org.apache.derby.vti.Pushable;
import org.apache.derby.vti.VTIEnvironment;

class VTIResultSet
extends NoPutResultSetImpl
implements CursorResultSet,
VTIEnvironment {
    public int rowsReturned;
    public String javaClassName;
    private boolean next;
    private ClassInspector classInspector;
    private GeneratedMethod row;
    private GeneratedMethod constructor;
    private PreparedStatement userPS;
    private ResultSet userVTI;
    private ExecRow allocatedRow;
    private FormatableBitSet referencedColumns;
    private boolean version2;
    private boolean reuseablePs;
    private boolean isTarget;
    private FormatableHashtable compileTimeConstants;
    private int ctcNumber;
    private boolean pushedProjection;
    private IFastPath fastPath;
    private Qualifier[][] pushedQualifiers;
    private boolean[] runtimeNullableColumn;
    private int scanIsolationLevel = 0;

    VTIResultSet(Activation activation, GeneratedMethod row, int resultSetNumber, GeneratedMethod constructor, String javaClassName, Qualifier[][] pushedQualifiers, int erdNumber, boolean version2, boolean reuseablePs, int ctcNumber, boolean isTarget, int scanIsolationLevel, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        super(activation, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.row = row;
        this.constructor = constructor;
        this.javaClassName = javaClassName;
        this.version2 = version2;
        this.reuseablePs = reuseablePs;
        this.isTarget = isTarget;
        this.pushedQualifiers = pushedQualifiers;
        this.scanIsolationLevel = scanIsolationLevel;
        if (erdNumber != -1) {
            this.referencedColumns = (FormatableBitSet)activation.getPreparedStatement().getSavedObject(erdNumber);
        }
        this.ctcNumber = ctcNumber;
        this.compileTimeConstants = (FormatableHashtable)activation.getPreparedStatement().getSavedObject(ctcNumber);
        this.constructorTime += this.getElapsedMillis(this.beginTime);
    }

    public void openCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        SanityManager.ASSERT(!this.isOpen, "VTIResultSet already open");
        this.isOpen = true;
        ++this.numOpens;
        try {
            if (this.version2) {
                this.userPS = (PreparedStatement)this.constructor.invoke(this.activation);
                if (this.userPS instanceof Pushable) {
                    Pushable p = (Pushable)((Object)this.userPS);
                    if (this.referencedColumns != null) {
                        this.pushedProjection = p.pushProjection(this, this.getProjectedColList());
                    }
                }
                if (this.userPS instanceof IQualifyable) {
                    IQualifyable q = (IQualifyable)((Object)this.userPS);
                    q.setQualifiers(this, this.pushedQualifiers);
                }
                IFastPath iFastPath = this.fastPath = this.userPS instanceof IFastPath ? (IFastPath)((Object)this.userPS) : null;
                if (this.isTarget && this.userPS instanceof DeferModification && this.activation.getConstantAction() instanceof UpdatableVTIConstantAction) {
                    UpdatableVTIConstantAction constants = (UpdatableVTIConstantAction)this.activation.getConstantAction();
                    ((DeferModification)((Object)this.userPS)).modificationNotify(constants.statementType, constants.deferred);
                }
                if (this.fastPath == null || !this.fastPath.executeAsFastPath()) {
                    this.userVTI = this.userPS.executeQuery();
                }
                if (this.isTarget) {
                    this.activation.setTargetVTI(this.userVTI);
                }
            } else {
                this.userVTI = (ResultSet)this.constructor.invoke(this.activation);
            }
            this.setNullableColumnList();
        }
        catch (Throwable t) {
            throw StandardException.unexpectedUserException(t);
        }
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    private boolean[] setNullableColumnList() throws SQLException {
        if (this.runtimeNullableColumn != null) {
            return this.runtimeNullableColumn;
        }
        if (this.userVTI == null) {
            return null;
        }
        ResultSetMetaData rsmd = this.userVTI.getMetaData();
        boolean[] nullableColumn = new boolean[rsmd.getColumnCount() + 1];
        for (int i = 1; i < nullableColumn.length; ++i) {
            nullableColumn[i] = rsmd.isNullable(i) != 0;
        }
        this.runtimeNullableColumn = nullableColumn;
        return nullableColumn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void reopenCore() throws StandardException {
        if (this.reuseablePs) {
            if (this.userVTI == null) return;
            try {
                this.userVTI.close();
                this.userVTI = this.userPS.executeQuery();
                if (!this.isTarget) return;
                this.activation.setTargetVTI(this.userVTI);
                return;
            }
            catch (SQLException se) {
                throw StandardException.unexpectedUserException(se);
            }
        } else {
            this.close();
            this.openCore();
        }
    }

    public ExecRow getNextRowCore() throws StandardException {
        ExecRow result = null;
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            try {
                int action;
                if (this.userVTI == null && this.fastPath != null && (action = this.fastPath.nextRow((result = this.getAllocatedRow()).getRowArray())) != 0) {
                    if (action == -1) {
                        result = null;
                    } else if (action == 1) {
                        this.userVTI = this.userPS.executeQuery();
                    }
                }
                if (this.userVTI != null) {
                    if (!this.userVTI.next()) {
                        if (null != this.fastPath) {
                            this.fastPath.rowsDone();
                        }
                        result = null;
                    } else {
                        result = this.getAllocatedRow();
                        this.populateFromResultSet(result);
                        if (this.fastPath != null) {
                            this.fastPath.currentRow(this.userVTI, result.getRowArray());
                        }
                    }
                }
            }
            catch (Throwable t) {
                throw StandardException.unexpectedUserException(t);
            }
        }
        this.setCurrentRow(result);
        if (result != null) {
            ++this.rowsReturned;
            ++this.rowsSeen;
        }
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return result;
    }

    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            this.next = false;
            if (this.userVTI != null) {
                try {
                    this.userVTI.close();
                }
                catch (SQLException se) {
                    throw StandardException.unexpectedUserException(se);
                }
                finally {
                    this.userVTI = null;
                }
            }
            if (this.userPS != null && !this.reuseablePs) {
                try {
                    this.userPS.close();
                }
                catch (SQLException se) {
                    throw StandardException.unexpectedUserException(se);
                }
                finally {
                    this.userPS = null;
                }
            }
            super.close();
        } else {
            SanityManager.DEBUG("CloseRepeatInfo", "Close of VTIResultSet repeated");
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    public void finish() throws StandardException {
        if (this.userPS != null && !this.reuseablePs) {
            try {
                this.userPS.close();
                this.userPS = null;
            }
            catch (SQLException se) {
                throw StandardException.unexpectedUserException(se);
            }
        }
        this.finishAndRTS();
    }

    public long getTimeSpent(int type) {
        long totTime = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        return totTime;
    }

    public RowLocation getRowLocation() {
        SanityManager.THROWASSERT("RowResultSet used in positioned update/delete");
        return null;
    }

    public ExecRow getCurrentRow() {
        SanityManager.THROWASSERT("RowResultSet used in positioned update/delete");
        return null;
    }

    GeneratedMethod getVTIConstructor() {
        return this.constructor;
    }

    boolean isReuseablePs() {
        return this.reuseablePs;
    }

    private ExecRow getAllocatedRow() throws StandardException {
        if (this.allocatedRow == null) {
            this.allocatedRow = (ExecRow)this.row.invoke(this.activation);
        }
        return this.allocatedRow;
    }

    private int[] getProjectedColList() {
        FormatableBitSet refs = this.referencedColumns;
        int size = refs.size();
        int arrayLen = 0;
        for (int i = 0; i < size; ++i) {
            if (!refs.isSet(i)) continue;
            ++arrayLen;
        }
        int[] colList = new int[arrayLen];
        int offset = 0;
        for (int i = 0; i < size; ++i) {
            if (!refs.isSet(i)) continue;
            colList[offset++] = i + 1;
        }
        return colList;
    }

    public void populateFromResultSet(ExecRow row) throws StandardException {
        try {
            boolean[] nullableColumn = this.setNullableColumnList();
            DataValueDescriptor[] columns = row.getRowArray();
            int rsColNumber = 1;
            for (int index = 0; index < columns.length; ++index) {
                if (this.referencedColumns != null && !this.referencedColumns.get(index)) {
                    if (this.pushedProjection) continue;
                    ++rsColNumber;
                    continue;
                }
                columns[index].setValueFromResultSet(this.userVTI, rsColNumber, nullableColumn[rsColNumber]);
                ++rsColNumber;
            }
        }
        catch (StandardException se) {
            throw se;
        }
        catch (Throwable t) {
            throw StandardException.unexpectedUserException(t);
        }
    }

    public final int getScanIsolationLevel() {
        return this.scanIsolationLevel;
    }

    public final boolean isCompileTime() {
        return false;
    }

    public final String getOriginalSQL() {
        return this.activation.getPreparedStatement().getSource();
    }

    public final int getStatementIsolationLevel() {
        return ExecutionContext.CS_TO_JDBC_ISOLATION_LEVEL_MAP[this.getScanIsolationLevel()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void setSharedState(String key, Serializable value) {
        if (key == null) {
            return;
        }
        if (this.compileTimeConstants == null) {
            Object[] savedObjects;
            Object[] objectArray = savedObjects = this.activation.getPreparedStatement().getSavedObjects();
            // MONITORENTER : savedObjects
            this.compileTimeConstants = (FormatableHashtable)savedObjects[this.ctcNumber];
            if (this.compileTimeConstants == null) {
                this.compileTimeConstants = new FormatableHashtable();
                savedObjects[this.ctcNumber] = this.compileTimeConstants;
            }
            // MONITOREXIT : objectArray
        }
        if (value == null) {
            this.compileTimeConstants.remove(key);
            return;
        }
        this.compileTimeConstants.put(key, value);
    }

    public Object getSharedState(String key) {
        if (key == null || this.compileTimeConstants == null) {
            return null;
        }
        return this.compileTimeConstants.get(key);
    }
}

