/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;

class UnionResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    public int rowsSeenLeft;
    public int rowsSeenRight;
    public int rowsReturned;
    private int whichSource = 1;
    private int source1FinalRowCount = -1;
    public NoPutResultSet source1;
    public NoPutResultSet source2;

    public UnionResultSet(NoPutResultSet source1, NoPutResultSet source2, Activation activation, int resultSetNumber, double optimizerEstimatedRowCount, double optimizerEstimatedCost) {
        super(activation, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.source1 = source1;
        this.source2 = source2;
        this.constructorTime += this.getElapsedMillis(this.beginTime);
    }

    public ResultDescription getResultDescription() {
        return this.source1.getResultDescription();
    }

    public void openCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        SanityManager.ASSERT(!this.isOpen, "UnionResultSet already open");
        this.isOpen = true;
        this.source1.openCore();
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public ExecRow getNextRowCore() throws StandardException {
        ExecRow result = null;
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            switch (this.whichSource) {
                case 1: {
                    result = this.source1.getNextRowCore();
                    if (result == (ExecRow)null) {
                        this.source1.close();
                        this.whichSource = 2;
                        this.source2.openCore();
                        result = this.source2.getNextRowCore();
                        if (result == null) break;
                        ++this.rowsSeenRight;
                        break;
                    }
                    ++this.rowsSeenLeft;
                    break;
                }
                case 2: {
                    result = this.source2.getNextRowCore();
                    if (result == null) break;
                    ++this.rowsSeenRight;
                    break;
                }
                default: {
                    SanityManager.THROWASSERT("Bad source number in union");
                }
            }
        }
        this.currentRow = result;
        this.setCurrentRow(result);
        if (result != null) {
            ++this.rowsReturned;
        }
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return result;
    }

    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            switch (this.whichSource) {
                case 1: {
                    this.source1.close();
                    break;
                }
                case 2: {
                    this.source2.close();
                    this.source1FinalRowCount = -1;
                    this.whichSource = 1;
                    break;
                }
                default: {
                    SanityManager.THROWASSERT("Bad source number in union");
                }
            }
            super.close();
        } else {
            SanityManager.DEBUG("CloseRepeatInfo", "Close of UnionResultSet repeated");
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    public void finish() throws StandardException {
        this.source1.finish();
        this.source2.finish();
        this.finishAndRTS();
    }

    public long getTimeSpent(int type) {
        long totTime = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (type == 0) {
            return totTime - this.source1.getTimeSpent(1) - this.source2.getTimeSpent(1);
        }
        return totTime;
    }

    public RowLocation getRowLocation() throws StandardException {
        switch (this.whichSource) {
            case 1: {
                SanityManager.ASSERT(this.source1 instanceof CursorResultSet, "source not CursorResultSet");
                return ((CursorResultSet)((Object)this.source1)).getRowLocation();
            }
            case 2: {
                SanityManager.ASSERT(this.source2 instanceof CursorResultSet, "source2 not CursorResultSet");
                return ((CursorResultSet)((Object)this.source2)).getRowLocation();
            }
        }
        SanityManager.THROWASSERT("Bad source number in union");
        return null;
    }

    public ExecRow getCurrentRow() throws StandardException {
        ExecRow result = null;
        SanityManager.ASSERT(this.isOpen, "TSRS expected to be open");
        if (this.whichSource != 1 && this.whichSource != 2) {
            SanityManager.THROWASSERT("whichSource expected to be 1 or 2, not " + this.whichSource);
        }
        switch (this.whichSource) {
            case 1: {
                result = ((CursorResultSet)((Object)this.source1)).getCurrentRow();
                break;
            }
            case 2: {
                result = ((CursorResultSet)((Object)this.source2)).getCurrentRow();
            }
        }
        this.currentRow = result;
        this.setCurrentRow(result);
        return result;
    }
}

