/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.sql.SQLWarning;
import java.sql.Timestamp;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.TargetResultSet;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderImpl;

class TemporaryRowHolderResultSet
implements CursorResultSet,
NoPutResultSet,
Cloneable {
    private ExecRow[] rowArray;
    private int numRowsOut;
    private ScanController scan;
    private TransactionController tc;
    private boolean isOpen;
    private boolean finished;
    private ExecRow currentRow;
    private ResultDescription resultDescription;
    private ExecutionFactory ef;
    private boolean isAppendable = false;
    private long positionIndexConglomId;
    private boolean isVirtualMemHeap;
    private boolean currRowFromMem;
    private TemporaryRowHolderImpl holder;
    ConglomerateController heapCC;
    private RowLocation baseRowLocation;
    DataValueDescriptor[] indexRow;
    ScanController indexsc;

    public TemporaryRowHolderResultSet(TransactionController tc, ExecRow[] rowArray, ResultDescription resultDescription, boolean isVirtualMemHeap, TemporaryRowHolderImpl holder) {
        this(tc, rowArray, resultDescription, isVirtualMemHeap, false, 0L, holder);
    }

    public TemporaryRowHolderResultSet(TransactionController tc, ExecRow[] rowArray, ResultDescription resultDescription, boolean isVirtualMemHeap, boolean isAppendable, long positionIndexConglomId, TemporaryRowHolderImpl holder) {
        this.tc = tc;
        this.rowArray = rowArray;
        this.resultDescription = resultDescription;
        this.numRowsOut = 0;
        this.isOpen = false;
        this.finished = false;
        this.isVirtualMemHeap = isVirtualMemHeap;
        this.isAppendable = isAppendable;
        this.positionIndexConglomId = positionIndexConglomId;
        SanityManager.ASSERT(rowArray != null, "rowArray is null");
        SanityManager.ASSERT(rowArray.length > 0, "rowArray has no elements, need at least one");
        this.holder = holder;
    }

    public void reset(ExecRow[] rowArray) {
        this.rowArray = rowArray;
        this.numRowsOut = 0;
        this.isOpen = false;
        this.finished = false;
        SanityManager.ASSERT(rowArray != null, "rowArray is null");
        SanityManager.ASSERT(rowArray.length > 0, "rowArray has no elements, need at least one");
    }

    public void reStartScan(long currentConglomId, long pconglomId) throws StandardException {
        if (this.isAppendable) {
            this.holder.CID = currentConglomId;
            this.positionIndexConglomId = pconglomId;
            this.setupPositionBasedScan(this.numRowsOut);
        } else {
            --this.numRowsOut;
        }
    }

    public static TemporaryRowHolderResultSet getNewRSOnCurrentRow(Activation activation, CursorResultSet rs) throws StandardException {
        TemporaryRowHolderImpl singleRow = new TemporaryRowHolderImpl(activation, null, rs.getResultDescription());
        singleRow.insert(rs.getCurrentRow());
        return (TemporaryRowHolderResultSet)singleRow.getResultSet();
    }

    public void markAsTopResultSet() {
    }

    public void openCore() throws StandardException {
        this.numRowsOut = 0;
        this.isOpen = true;
        this.currentRow = null;
        if (this.isAppendable) {
            this.setupPositionBasedScan(this.numRowsOut);
        }
    }

    public void reopenCore() throws StandardException {
        this.numRowsOut = 0;
        this.isOpen = true;
        this.currentRow = null;
        if (this.isAppendable) {
            this.setupPositionBasedScan(this.numRowsOut);
            return;
        }
        if (this.scan != null) {
            this.scan.reopenScan(null, 0, null, null, 0);
        }
    }

    public ExecRow getNextRowCore() throws StandardException {
        if (!this.isOpen) {
            return null;
        }
        if (this.isAppendable) {
            return this.getNextAppendedRow();
        }
        if (this.isVirtualMemHeap && this.holder.lastArraySlot >= 0) {
            ++this.numRowsOut;
            this.currentRow = this.rowArray[this.holder.lastArraySlot];
            this.currRowFromMem = true;
            return this.currentRow;
        }
        if (this.numRowsOut++ <= this.holder.lastArraySlot) {
            this.currentRow = this.rowArray[this.numRowsOut - 1];
            return this.currentRow;
        }
        if (this.holder.CID == 0L) {
            return null;
        }
        if (this.scan == null) {
            this.scan = this.tc.openScan(this.holder.CID, false, 0, 7, 5, null, null, 0, null, null, 0);
        } else if (this.isVirtualMemHeap && this.holder.state == 1) {
            this.holder.state = 2;
            this.scan.reopenScan(null, 0, null, null, 0);
        }
        if (this.scan.next()) {
            this.currentRow = this.rowArray[0].getNewNullRow();
            this.scan.fetch(this.currentRow.getRowArray());
            this.currRowFromMem = false;
            return this.currentRow;
        }
        return null;
    }

    public void deleteCurrentRow() throws StandardException {
        SanityManager.ASSERT(this.isVirtualMemHeap, "deleteCurrentRow is not implemented");
        if (this.currRowFromMem) {
            if (this.holder.lastArraySlot > 0) {
                this.rowArray[this.holder.lastArraySlot] = null;
            }
            --this.holder.lastArraySlot;
        } else {
            if (this.baseRowLocation == null) {
                this.baseRowLocation = this.scan.newRowLocationTemplate();
            }
            this.scan.fetchLocation(this.baseRowLocation);
            if (this.heapCC == null) {
                this.heapCC = this.tc.openConglomerate(this.holder.CID, false, 4, 7, 5);
            }
            this.heapCC.delete(this.baseRowLocation);
        }
    }

    private void setupPositionBasedScan(long position) throws StandardException {
        if (this.holder.CID == 0L) {
            return;
        }
        if (this.heapCC == null) {
            this.heapCC = this.tc.openConglomerate(this.holder.CID, false, 0, 7, 5);
        }
        this.currentRow = this.rowArray[0].getNewNullRow();
        this.indexRow = new DataValueDescriptor[2];
        this.indexRow[0] = new SQLLongint(position);
        this.indexRow[1] = this.heapCC.newRowLocationTemplate();
        DataValueDescriptor[] searchRow = new DataValueDescriptor[]{new SQLLongint(position)};
        if (this.indexsc == null) {
            this.indexsc = this.tc.openScan(this.positionIndexConglomId, false, 0, 7, 5, null, searchRow, 1, null, null, -1);
        } else {
            this.indexsc.reopenScan(searchRow, 1, null, null, -1);
        }
    }

    private ExecRow getNextAppendedRow() throws StandardException {
        if (this.indexsc == null) {
            return null;
        }
        if (!this.indexsc.fetchNext(this.indexRow)) {
            return null;
        }
        RowLocation baseRowLocation = (RowLocation)this.indexRow[1];
        boolean base_row_exists = this.heapCC.fetch(baseRowLocation, this.currentRow.getRowArray(), null);
        SanityManager.ASSERT(base_row_exists, "base row disappeared.");
        ++this.numRowsOut;
        return this.currentRow;
    }

    public int getPointOfAttachment() {
        return -1;
    }

    public int getScanIsolationLevel() {
        return 5;
    }

    public void setTargetResultSet(TargetResultSet trs) {
    }

    public void setNeedsRowLocation(boolean needsRowLocation) {
    }

    public double getEstimatedRowCount() {
        return 0.0;
    }

    public int resultSetNumber() {
        return 0;
    }

    public void setCurrentRow(ExecRow row) {
        this.currentRow = row;
    }

    public void clearCurrentRow() {
        this.currentRow = null;
    }

    public ExecRow getCurrentRow() throws StandardException {
        SanityManager.ASSERT(this.isOpen, "resultSet expected to be open");
        return this.currentRow;
    }

    public RowLocation getRowLocation() {
        SanityManager.ASSERT(this.isOpen, "resultSet expected to be open");
        return null;
    }

    public void close() throws StandardException {
        this.isOpen = false;
        this.numRowsOut = 0;
        this.currentRow = null;
        if (this.scan != null) {
            this.scan.close();
            this.scan = null;
        }
    }

    public boolean returnsRows() {
        return true;
    }

    public int modifiedRowCount() {
        return 0;
    }

    public ResultDescription getResultDescription() {
        return this.resultDescription;
    }

    public void open() throws StandardException {
        this.openCore();
    }

    public ExecRow getAbsoluteRow(int row) throws StandardException {
        SanityManager.THROWASSERT("getAbsoluteRow() not expected to be called yet.");
        return null;
    }

    public ExecRow getRelativeRow(int row) throws StandardException {
        SanityManager.THROWASSERT("getRelativeRow() not expected to be called yet.");
        return null;
    }

    public ExecRow setBeforeFirstRow() throws StandardException {
        SanityManager.THROWASSERT("setBeforeFirstRow() not expected to be called yet.");
        return null;
    }

    public ExecRow getFirstRow() throws StandardException {
        SanityManager.THROWASSERT("getFirstRow() not expected to be called yet.");
        return null;
    }

    public ExecRow getNextRow() throws StandardException {
        return this.getNextRowCore();
    }

    public ExecRow getPreviousRow() throws StandardException {
        SanityManager.THROWASSERT("getPreviousRow() not expected to be called yet.");
        return null;
    }

    public ExecRow getLastRow() throws StandardException {
        SanityManager.THROWASSERT("getLastRow() not expected to be called yet.");
        return null;
    }

    public ExecRow setAfterLastRow() throws StandardException {
        SanityManager.THROWASSERT("getLastRow() not expected to be called yet.");
        return null;
    }

    public boolean checkRowPosition(int isType) {
        return false;
    }

    public int getRowNumber() {
        return 0;
    }

    public void cleanUp() throws StandardException {
        this.close();
    }

    public boolean isClosed() {
        return !this.isOpen;
    }

    public void finish() throws StandardException {
        this.finished = true;
        this.close();
    }

    public long getExecuteTime() {
        return 0L;
    }

    public ResultSet getAutoGeneratedKeysResultset() {
        return null;
    }

    public Timestamp getBeginExecutionTimestamp() {
        return null;
    }

    public Timestamp getEndExecutionTimestamp() {
        return null;
    }

    public long getTimeSpent(int type) {
        return 0L;
    }

    public NoPutResultSet[] getSubqueryTrackingArray(int numSubqueries) {
        return null;
    }

    public String getCursorName() {
        return null;
    }

    public boolean requiresRelocking() {
        SanityManager.THROWASSERT("requiresRelocking() not expected to be called for " + this.getClass().getName());
        return false;
    }

    public DataValueDescriptor[] getNextRowFromRowSource() throws StandardException {
        return null;
    }

    public boolean needsToClone() {
        return false;
    }

    public FormatableBitSet getValidColumns() {
        return null;
    }

    public void closeRowSource() {
    }

    public boolean needsRowLocation() {
        return false;
    }

    public void rowLocation(RowLocation rl) throws StandardException {
    }

    public void positionScanAtRowLocation(RowLocation rl) throws StandardException {
    }

    public boolean isForUpdate() {
        return false;
    }

    public Object clone() {
        Object clo = null;
        try {
            clo = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clo;
    }

    public SQLWarning getWarnings() {
        return null;
    }

    public void updateRow(ExecRow row) throws StandardException {
    }

    public void markRowAsDeleted() throws StandardException {
    }

    public final Activation getActivation() {
        return this.holder.activation;
    }
}

