/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Hashtable;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.TemporaryRowHolder;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.ScanResultSet;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderResultSet;
import org.apache.derby.impl.sql.execute.ValueRow;

class TableScanResultSet
extends ScanResultSet
implements CursorResultSet,
Cloneable {
    protected ScanController scanController;
    protected boolean scanControllerOpened;
    protected boolean isKeyed;
    protected boolean firstScan = true;
    protected ExecIndexRow startPosition;
    protected ExecIndexRow stopPosition;
    protected long conglomId;
    protected DynamicCompiledOpenConglomInfo dcoci;
    protected StaticCompiledOpenConglomInfo scoci;
    protected GeneratedMethod resultRowAllocator;
    protected GeneratedMethod startKeyGetter;
    protected int startSearchOperator;
    protected GeneratedMethod stopKeyGetter;
    protected int stopSearchOperator;
    public Qualifier[][] qualifiers;
    public String tableName;
    public String userSuppliedOptimizerOverrides;
    public String indexName;
    protected boolean runTimeStatisticsOn;
    protected FormatableBitSet accessedCols;
    protected int[] indexCols;
    public int rowsPerRead;
    public boolean forUpdate;
    private boolean sameStartStopPosition;
    private boolean nextDone;
    private RowLocation rlTemplate;
    private Properties scanProperties;
    public String startPositionString;
    public String stopPositionString;
    public boolean isConstraint;
    public boolean coarserLock;
    public boolean oneRowScan;
    protected long rowsThisScan;
    private long estimatedRowCount;
    protected Hashtable past2FutureTbl;
    protected TemporaryRowHolder futureForUpdateRows;
    protected TemporaryRowHolderResultSet futureRowResultSet;
    protected boolean skipFutureRowHolder;
    protected boolean sourceDrained;
    protected boolean currentRowPrescanned;
    protected boolean compareToLastKey;
    protected ExecRow lastCursorKey;
    private ExecRow sparseRow;
    private FormatableBitSet sparseRowMap;
    private boolean qualify;
    private boolean currentRowIsValid;
    private boolean scanRepositioned;

    TableScanResultSet(long conglomId, StaticCompiledOpenConglomInfo scoci, Activation activation, GeneratedMethod resultRowAllocator, int resultSetNumber, GeneratedMethod startKeyGetter, int startSearchOperator, GeneratedMethod stopKeyGetter, int stopSearchOperator, boolean sameStartStopPosition, Qualifier[][] qualifiers, String tableName, String userSuppliedOptimizerOverrides, String indexName, boolean isConstraint, boolean forUpdate, int colRefItem, int indexColItem, int lockMode, boolean tableLocked, int isolationLevel, int rowsPerRead, boolean oneRowScan, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        super(activation, resultSetNumber, resultRowAllocator, lockMode, tableLocked, isolationLevel, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.conglomId = conglomId;
        this.scoci = scoci;
        SanityManager.ASSERT(activation != null, "table scan must get activation context");
        SanityManager.ASSERT(resultRowAllocator != null, "table scan must get row allocator");
        if (sameStartStopPosition) {
            SanityManager.ASSERT(stopKeyGetter == null, "stopKeyGetter expected to be null when sameStartStopPosition is true");
        }
        this.resultRowAllocator = resultRowAllocator;
        this.startKeyGetter = startKeyGetter;
        this.startSearchOperator = startSearchOperator;
        this.stopKeyGetter = stopKeyGetter;
        this.stopSearchOperator = stopSearchOperator;
        this.sameStartStopPosition = sameStartStopPosition;
        this.qualifiers = qualifiers;
        this.tableName = tableName;
        this.userSuppliedOptimizerOverrides = userSuppliedOptimizerOverrides;
        this.indexName = indexName;
        this.isConstraint = isConstraint;
        this.forUpdate = forUpdate;
        this.rowsPerRead = rowsPerRead;
        this.oneRowScan = oneRowScan;
        this.accessedCols = null;
        if (colRefItem != -1) {
            this.accessedCols = (FormatableBitSet)activation.getPreparedStatement().getSavedObject(colRefItem);
        }
        if (indexColItem != -1) {
            this.indexCols = (int[])activation.getPreparedStatement().getSavedObject(indexColItem);
        }
        if (this.indexCols != null) {
            activation.setForUpdateIndexScan(this);
        }
        this.runTimeStatisticsOn = activation != null && activation.getLanguageConnectionContext().getRunTimeStatisticsMode();
        this.constructorTime += this.getElapsedMillis(this.beginTime);
        this.qualify = true;
        this.currentRowIsValid = false;
        this.scanRepositioned = false;
    }

    public void openCore() throws StandardException {
        SanityManager.ASSERT(!this.isOpen, "TableScanResultSet already open");
        TransactionController tc = this.activation.getTransactionController();
        this.initIsolationLevel();
        if (this.dcoci == null) {
            this.dcoci = tc.getDynamicCompiledConglomInfo(this.conglomId);
        }
        if (this.startKeyGetter != null) {
            this.startPosition = (ExecIndexRow)this.startKeyGetter.invoke(this.activation);
            if (this.sameStartStopPosition) {
                this.stopPosition = this.startPosition;
            }
        }
        if (this.stopKeyGetter != null) {
            this.stopPosition = (ExecIndexRow)this.stopKeyGetter.invoke(this.activation);
        }
        if (this.firstScan) {
            this.openScanController(tc);
            this.isKeyed = this.scanController.isKeyed();
            if (SanityManager.DEBUG_ON("ScanTrace")) {
                // empty if block
            }
        }
        if (this.skipScan(this.startPosition, this.stopPosition)) {
            this.scanControllerOpened = false;
        } else if (!this.firstScan) {
            this.openScanController(tc);
        }
        if (this.forUpdate && this.isKeyed) {
            this.activation.setIndexScanController(this.scanController);
            this.activation.setIndexConglomerateNumber(this.conglomId);
        }
        this.firstScan = false;
        this.isOpen = true;
        ++this.numOpens;
        this.nextDone = false;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    protected void openScanController(TransactionController tc) throws StandardException {
        this.openScanController(tc, null);
    }

    protected void openScanController(TransactionController tc, DataValueDescriptor probeValue) throws StandardException {
        DataValueDescriptor[] stopPositionRow;
        DataValueDescriptor[] startPositionRow = this.startPosition == null ? null : this.startPosition.getRowArray();
        DataValueDescriptor[] dataValueDescriptorArray = stopPositionRow = this.stopPosition == null ? null : this.stopPosition.getRowArray();
        if (probeValue != null) {
            startPositionRow[0] = probeValue;
            if (!this.sameStartStopPosition) {
                stopPositionRow[0] = probeValue;
            }
        }
        if (this.qualifiers != null) {
            this.clearOrderableCache(this.qualifiers);
        }
        if (tc == null) {
            tc = this.activation.getTransactionController();
        }
        int openMode = 0;
        if (this.forUpdate) {
            openMode = 4;
            if (this.activation.isCursorActivation()) {
                openMode |= 0x1000;
            }
        }
        this.scanController = tc.openCompiledScan(this.activation.getResultSetHoldability(), openMode, this.lockMode, this.isolationLevel, this.accessedCols, startPositionRow, this.startSearchOperator, this.qualifiers, stopPositionRow, this.stopSearchOperator, this.scoci, this.dcoci);
        this.scanControllerOpened = true;
        this.rowsThisScan = 0L;
        this.estimatedRowCount = this.scanController.getEstimatedRowCount();
        this.activation.informOfRowCount(this, this.scanController.getEstimatedRowCount());
    }

    protected void reopenScanController() throws StandardException {
        this.reopenScanController(null);
    }

    protected void reopenScanController(DataValueDescriptor probeValue) throws StandardException {
        DataValueDescriptor[] stopPositionRow;
        DataValueDescriptor[] startPositionRow = this.startPosition == null ? null : this.startPosition.getRowArray();
        DataValueDescriptor[] dataValueDescriptorArray = stopPositionRow = this.stopPosition == null ? null : this.stopPosition.getRowArray();
        if (probeValue != null) {
            startPositionRow[0] = probeValue;
            if (!this.sameStartStopPosition) {
                stopPositionRow[0] = probeValue;
            }
        } else {
            this.rowsThisScan = 0L;
        }
        if (this.qualifiers != null) {
            this.clearOrderableCache(this.qualifiers);
        }
        this.scanController.reopenScan(startPositionRow, this.startSearchOperator, this.qualifiers, stopPositionRow, this.stopSearchOperator);
        this.scanControllerOpened = true;
    }

    public void reopenCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        SanityManager.ASSERT(this.isOpen, "TableScanResultSet not open, cannot reopen");
        if (this.startKeyGetter != null) {
            this.startPosition = (ExecIndexRow)this.startKeyGetter.invoke(this.activation);
            if (this.sameStartStopPosition) {
                this.stopPosition = this.startPosition;
            }
        }
        if (this.stopKeyGetter != null) {
            this.stopPosition = (ExecIndexRow)this.stopKeyGetter.invoke(this.activation);
        }
        if (this.skipScan(this.startPosition, this.stopPosition)) {
            this.scanControllerOpened = false;
        } else if (this.scanController == null) {
            this.openScanController(null);
        } else {
            this.reopenScanController();
        }
        ++this.numOpens;
        this.nextDone = false;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    private void getSparseRowAndMap() throws StandardException {
        int colPos;
        int i;
        int numCols = 1;
        for (i = 0; i < this.indexCols.length; ++i) {
            int n = colPos = this.indexCols[i] > 0 ? this.indexCols[i] : -this.indexCols[i];
            if (colPos <= numCols) continue;
            numCols = colPos;
        }
        this.sparseRow = new ValueRow(numCols);
        this.sparseRowMap = new FormatableBitSet(numCols);
        for (i = 0; i < this.indexCols.length; ++i) {
            if (!this.accessedCols.get(i)) continue;
            colPos = this.indexCols[i] > 0 ? this.indexCols[i] : -this.indexCols[i];
            this.sparseRow.setColumn(colPos, this.candidate.getColumn(i + 1));
            this.sparseRowMap.set(colPos - 1);
        }
    }

    public ExecRow getNextRowCore() throws StandardException {
        this.checkCancellationFlag();
        if (this.currentRow == null || this.scanRepositioned) {
            this.currentRow = this.getCompactRow(this.candidate, this.accessedCols, null, this.isKeyed);
        }
        this.beginTime = this.getCurrentTimeMillis();
        ExecRow result = null;
        if (this.futureForUpdateRows != null) {
            this.currentRowPrescanned = false;
            if (!this.skipFutureRowHolder) {
                ExecRow ridRow;
                if (this.futureRowResultSet == null) {
                    this.futureRowResultSet = (TemporaryRowHolderResultSet)this.futureForUpdateRows.getResultSet();
                    this.futureRowResultSet.openCore();
                }
                if ((ridRow = this.futureRowResultSet.getNextRowCore()) != null) {
                    this.futureRowResultSet.deleteCurrentRow();
                    RowLocation rl = (RowLocation)ridRow.getColumn(1);
                    ConglomerateController baseCC = this.activation.getHeapConglomerateController();
                    if (this.sparseRow == null) {
                        this.getSparseRowAndMap();
                    }
                    baseCC.fetch(rl, this.sparseRow.getRowArray(), this.sparseRowMap);
                    RowLocation rl2 = (RowLocation)rl.getClone();
                    this.currentRow.setColumn(this.currentRow.nColumns(), rl2);
                    this.candidate.setColumn(this.candidate.nColumns(), rl2);
                    result = this.currentRow;
                    this.currentRowPrescanned = true;
                } else if (this.sourceDrained) {
                    this.currentRowPrescanned = true;
                    this.currentRow = null;
                }
                if (this.currentRowPrescanned) {
                    this.setCurrentRow(result);
                    this.nextTime += this.getElapsedMillis(this.beginTime);
                    return result;
                }
            }
        }
        if (this.isOpen && !this.nextDone) {
            this.nextDone = this.oneRowScan;
            if (this.scanControllerOpened) {
                boolean moreRows;
                while (moreRows = this.scanController.fetchNext(this.candidate.getRowArray())) {
                    RowLocation rowLoc;
                    ++this.rowsSeen;
                    ++this.rowsThisScan;
                    if (!this.sameStartStopPosition && this.skipRow(this.candidate)) {
                        ++this.rowsFiltered;
                        continue;
                    }
                    if (this.past2FutureTbl != null && this.past2FutureTbl.get(rowLoc = (RowLocation)this.currentRow.getColumn(this.currentRow.nColumns())) != null) {
                        this.past2FutureTbl.remove(rowLoc);
                        continue;
                    }
                    result = this.currentRow;
                    break;
                }
                if (!moreRows) {
                    this.setRowCountIfPossible(this.rowsThisScan);
                    this.currentRow = null;
                }
            }
        }
        this.setCurrentRow(result);
        this.currentRowIsValid = true;
        this.scanRepositioned = false;
        this.qualify = true;
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return result;
    }

    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            ConglomerateController borrowedBaseCC;
            if (SanityManager.DEBUG_ON("ScanTrace")) {
                // empty if block
            }
            this.clearCurrentRow();
            if (this.scanController != null) {
                if (this.runTimeStatisticsOn) {
                    this.scanProperties = this.getScanProperties();
                    this.startPositionString = this.printStartPosition();
                    this.stopPositionString = this.printStopPosition();
                }
                this.scanController.close();
                this.scanController = null;
                this.activation.clearIndexScanInfo();
            }
            this.scanControllerOpened = false;
            this.startPosition = null;
            this.stopPosition = null;
            super.close();
            if (this.indexCols != null && (borrowedBaseCC = this.activation.getHeapConglomerateController()) != null) {
                borrowedBaseCC.close();
                this.activation.clearHeapConglomerateController();
            }
            if (this.futureRowResultSet != null) {
                this.futureRowResultSet.close();
            }
        } else {
            SanityManager.DEBUG("CloseRepeatInfo", "Close of TableScanResultSet repeated");
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    public long getTimeSpent(int type) {
        long totTime = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (type == 0) {
            return totTime;
        }
        return totTime;
    }

    public RowLocation getRowLocation() throws StandardException {
        RowLocation rl;
        if (!this.isOpen) {
            return null;
        }
        if (!this.scanControllerOpened) {
            return null;
        }
        if (this.isKeyed) {
            SanityManager.ASSERT(this.currentRow != null, "There must be a current row when fetching the row location");
            rl = (RowLocation)this.currentRow.getColumn(this.currentRow.nColumns());
        } else if (this.currentRowIsValid) {
            if (this.rlTemplate == null) {
                this.rlTemplate = this.scanController.newRowLocationTemplate();
            }
            rl = this.rlTemplate;
            try {
                this.scanController.fetchLocation(rl);
            }
            catch (StandardException se) {
                if (se.getMessageId().equals("XSCH7.S")) {
                    throw StandardException.newException("24000");
                }
                throw se;
            }
        } else {
            rl = null;
        }
        return rl;
    }

    public ExecRow getCurrentRow() throws StandardException {
        ExecRow result;
        block7: {
            result = null;
            SanityManager.ASSERT(this.isOpen, "TSRS expected to be open");
            if (this.currentRowPrescanned) {
                return this.currentRow;
            }
            try {
                if (this.currentRow == null || !this.currentRowIsValid || !this.scanControllerOpened || this.qualify && this.scanController.isCurrentPositionDeleted() || this.qualify && !this.scanController.doesCurrentPositionQualify()) {
                    return null;
                }
            }
            catch (StandardException se) {
                if (!se.getMessageId().equals("XSAM5.S")) break block7;
                se = StandardException.newException("24000");
                throw se;
            }
        }
        result = (ExecRow)this.resultRowAllocator.invoke(this.activation);
        this.currentRow = this.getCompactRow(result, this.accessedCols, null, this.isKeyed);
        try {
            this.scanController.fetchWithoutQualify(result.getRowArray());
        }
        catch (StandardException se) {
            if (se.getMessageId().equals("XSAM6.S")) {
                return null;
            }
            throw se;
        }
        this.setCurrentRow(result);
        return this.currentRow;
    }

    public void positionScanAtRowLocation(RowLocation rl) throws StandardException {
        if (!this.isKeyed) {
            this.currentRowIsValid = this.scanController.positionAtRowLocation(rl);
        }
        this.qualify = false;
        this.scanRepositioned = true;
    }

    public String printStartPosition() {
        return this.printPosition(this.startSearchOperator, this.startKeyGetter, this.startPosition);
    }

    public String printStopPosition() {
        if (this.sameStartStopPosition) {
            return this.printPosition(this.stopSearchOperator, this.startKeyGetter, this.startPosition);
        }
        return this.printPosition(this.stopSearchOperator, this.stopKeyGetter, this.stopPosition);
    }

    private String printPosition(int searchOperator, GeneratedMethod positionGetter, ExecIndexRow positioner) {
        String idt = "";
        String output = "";
        if (positionGetter == null) {
            return "\t" + MessageService.getTextMessage("42Z37.U") + "\n";
        }
        if (positioner == null) {
            try {
                positioner = (ExecIndexRow)positionGetter.invoke(this.activation);
            }
            catch (StandardException e) {
                if (e.getSQLState() == "38000") {
                    return "\t" + MessageService.getTextMessage("42Z38.U");
                }
                return "\t" + MessageService.getTextMessage("42Z39.U", e.toString());
            }
        }
        if (positioner == null) {
            return "\t" + MessageService.getTextMessage("42Z37.U") + "\n";
        }
        String searchOp = null;
        switch (searchOperator) {
            case 1: {
                searchOp = ">=";
                break;
            }
            case -1: {
                searchOp = ">";
                break;
            }
            default: {
                SanityManager.THROWASSERT("Unknown search operator " + searchOperator);
                searchOp = "unknown value (" + searchOperator + ")";
            }
        }
        output = output + "\t" + MessageService.getTextMessage("42Z40.U", searchOp, String.valueOf(positioner.nColumns())) + "\n";
        output = output + "\t" + MessageService.getTextMessage("42Z41.U") + "\n";
        for (int position = 0; position < positioner.nColumns(); ++position) {
            if (!positioner.areNullsOrdered(position)) continue;
            output = output + position + " ";
        }
        return output + "\n";
    }

    public Properties getScanProperties() {
        if (this.scanProperties == null) {
            this.scanProperties = new Properties();
        }
        try {
            if (this.scanController != null) {
                this.scanController.getScanInfo().getAllScanInfo(this.scanProperties);
                this.coarserLock = this.scanController.isTableLocked() && this.lockMode == 6;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        return this.scanProperties;
    }

    public boolean requiresRelocking() {
        return this.isolationLevel == 3;
    }

    protected final void setRowCountIfPossible(long rowsThisScan) throws StandardException {
        if (!(this.scanController.isKeyed() || this.qualifiers != null && this.qualifiers.length != 0 || this.forUpdate)) {
            long diff = rowsThisScan - this.estimatedRowCount;
            long tenPerCent = this.estimatedRowCount / 10L;
            if (diff < 0L) {
                diff = -diff;
            }
            if (diff > tenPerCent) {
                this.scanController.setEstimatedRowCount(rowsThisScan);
            }
        }
    }

    protected boolean canGetInstantaneousLocks() {
        return false;
    }

    public boolean isForUpdate() {
        return this.forUpdate;
    }

    public Object clone() {
        Object clo = null;
        try {
            clo = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clo;
    }
}

