/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Iterator;
import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColPermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TablePermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.dictionary.ViewDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.PrivilegeInfo;

public class TablePrivilegeInfo
extends PrivilegeInfo {
    public static final int SELECT_ACTION = 0;
    public static final int DELETE_ACTION = 1;
    public static final int INSERT_ACTION = 2;
    public static final int UPDATE_ACTION = 3;
    public static final int REFERENCES_ACTION = 4;
    public static final int TRIGGER_ACTION = 5;
    public static final int ACTION_COUNT = 6;
    private static final String YES_WITH_GRANT_OPTION = "Y";
    private static final String YES_WITHOUT_GRANT_OPTION = "y";
    private static final String NO = "N";
    private static final String[][] actionString = new String[][]{{"s", "S"}, {"d", "D"}, {"i", "I"}, {"u", "U"}, {"r", "R"}, {"t", "T"}};
    private TableDescriptor td;
    private boolean[] actionAllowed;
    private FormatableBitSet[] columnBitSets;
    private List descriptorList;

    public TablePrivilegeInfo(TableDescriptor td, boolean[] actionAllowed, FormatableBitSet[] columnBitSets, List descriptorList) {
        this.actionAllowed = actionAllowed;
        this.columnBitSets = columnBitSets;
        this.td = td;
        this.descriptorList = descriptorList;
    }

    protected void checkOwnership(String user, TableDescriptor td, SchemaDescriptor sd, DataDictionary dd, LanguageConnectionContext lcc, boolean grant) throws StandardException {
        super.checkOwnership(user, td, sd, dd);
        if (grant) {
            this.checkPrivileges(user, td, sd, dd, lcc);
        }
    }

    private void checkPrivileges(String user, TableDescriptor td, SchemaDescriptor sd, DataDictionary dd, LanguageConnectionContext lcc) throws StandardException {
        if (user.equals(dd.getAuthorizationDatabaseOwner())) {
            return;
        }
        if (td.getTableType() == 2 && this.descriptorList != null) {
            TransactionController tc = lcc.getTransactionExecute();
            int siz = this.descriptorList.size();
            for (int i = 0; i < siz; ++i) {
                SchemaDescriptor s = null;
                TupleDescriptor p = (TupleDescriptor)this.descriptorList.get(i);
                if (p instanceof TableDescriptor) {
                    TableDescriptor t = (TableDescriptor)p;
                    s = t.getSchemaDescriptor();
                } else if (p instanceof ViewDescriptor) {
                    ViewDescriptor v = (ViewDescriptor)p;
                    s = dd.getSchemaDescriptor(v.getCompSchemaId(), tc);
                } else if (p instanceof AliasDescriptor) {
                    AliasDescriptor a = (AliasDescriptor)p;
                    s = dd.getSchemaDescriptor(a.getSchemaUUID(), tc);
                }
                if (s == null || user.equals(s.getAuthorizationId())) continue;
                throw StandardException.newException("4250A", user, (Object)"grant", (Object)sd.getSchemaName(), (Object)td.getName());
            }
        }
    }

    public void executeGrantRevoke(Activation activation, boolean grant, List grantees) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        String currentUser = lcc.getAuthorizationId();
        TransactionController tc = lcc.getTransactionExecute();
        SchemaDescriptor sd = this.td.getSchemaDescriptor();
        this.checkOwnership(currentUser, this.td, sd, dd, lcc, grant);
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        TablePermsDescriptor tablePermsDesc = ddg.newTablePermsDescriptor(this.td, this.getPermString(0, false), this.getPermString(1, false), this.getPermString(2, false), this.getPermString(3, false), this.getPermString(4, false), this.getPermString(5, false), currentUser);
        ColPermsDescriptor[] colPermsDescs = new ColPermsDescriptor[this.columnBitSets.length];
        for (int i = 0; i < this.columnBitSets.length; ++i) {
            if (this.columnBitSets[i] == null && (grant || !this.hasColumnPermissions(i) || !this.actionAllowed[i])) continue;
            colPermsDescs[i] = ddg.newColPermsDescriptor(this.td, this.getActionString(i, false), this.columnBitSets[i], currentUser);
        }
        dd.startWriting(lcc);
        Iterator itr = grantees.iterator();
        while (itr.hasNext()) {
            boolean privileges_revoked = false;
            String grantee = (String)itr.next();
            if (tablePermsDesc != null && dd.addRemovePermissionsDescriptor(grant, tablePermsDesc, grantee, tc)) {
                privileges_revoked = true;
                dd.getDependencyManager().invalidateFor(tablePermsDesc, 44, lcc);
                dd.getDependencyManager().invalidateFor(this.td, 23, lcc);
            }
            for (int i = 0; i < this.columnBitSets.length; ++i) {
                if (colPermsDescs[i] == null || !dd.addRemovePermissionsDescriptor(grant, colPermsDescs[i], grantee, tc)) continue;
                privileges_revoked = true;
                dd.getDependencyManager().invalidateFor(colPermsDescs[i], 44, lcc);
            }
            this.addWarningIfPrivilegeNotRevoked(activation, grant, privileges_revoked, grantee);
        }
    }

    private String getPermString(int action, boolean forGrantOption) {
        if (this.actionAllowed[action] && this.columnBitSets[action] == null) {
            return forGrantOption ? YES_WITH_GRANT_OPTION : YES_WITHOUT_GRANT_OPTION;
        }
        return NO;
    }

    private String getActionString(int action, boolean forGrantOption) {
        return actionString[action][forGrantOption ? 1 : 0];
    }

    private boolean hasColumnPermissions(int action) {
        return action == 0 || action == 3 || action == 4;
    }
}

