/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.impl.sql.execute.CursorActivation;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;
import org.apache.derby.impl.sql.execute.ProjectRestrictResultSet;

public class ScrollInsensitiveResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    public NoPutResultSet source;
    private int sourceRowWidth;
    private BackingStoreHashtable ht;
    private ExecRow resultRow;
    private int positionInSource;
    private int currentPosition;
    private int lastPosition;
    private boolean seenFirst;
    private boolean seenLast;
    private boolean beforeFirst = true;
    private boolean afterLast;
    public int numFromHashTable;
    public int numToHashTable;
    private int maxRows;
    private boolean keepAfterCommit;
    private int extraColumns;
    private SQLInteger positionInHashTable;
    private CursorResultSet target;
    private boolean needsRepositioning;
    private static final int POS_ROWLOCATION = 1;
    private static final int POS_ROWDELETED = 2;
    private static final int POS_ROWUPDATED = 3;
    private static final int LAST_EXTRA_COLUMN = 3;

    public ScrollInsensitiveResultSet(NoPutResultSet source, Activation activation, int resultSetNumber, int sourceRowWidth, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        super(activation, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.source = source;
        this.sourceRowWidth = sourceRowWidth;
        this.keepAfterCommit = activation.getResultSetHoldability();
        this.maxRows = activation.getMaxRows();
        SanityManager.ASSERT(this.maxRows != -1, "maxRows not expected to be -1");
        this.constructorTime += this.getElapsedMillis(this.beginTime);
        this.positionInHashTable = new SQLInteger();
        this.needsRepositioning = false;
        if (this.isForUpdate()) {
            this.target = ((CursorActivation)activation).getTargetResultSet();
            this.extraColumns = 4;
        } else {
            this.target = null;
            this.extraColumns = 1;
        }
    }

    public void openCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        SanityManager.ASSERT(!this.isOpen, "ScrollInsensitiveResultSet already open");
        this.source.openCore();
        this.isOpen = true;
        ++this.numOpens;
        int[] keyCols = new int[]{0};
        this.ht = new BackingStoreHashtable(this.getTransactionController(), null, keyCols, false, -1L, -1L, -1, -1.0f, false, this.keepAfterCommit);
        this.lastPosition = 0;
        this.needsRepositioning = false;
        this.numFromHashTable = 0;
        this.numToHashTable = 0;
        this.positionInSource = 0;
        this.seenFirst = false;
        this.seenLast = false;
        this.openTime += this.getElapsedMillis(this.beginTime);
        this.setBeforeFirstRow();
    }

    public void reopenCore() throws StandardException {
        boolean constantEval = true;
        this.beginTime = this.getCurrentTimeMillis();
        SanityManager.ASSERT(this.isOpen, "ScrollInsensitiveResultSet already open");
        SanityManager.THROWASSERT("reopenCore() not expected to be called");
        this.setBeforeFirstRow();
    }

    public ExecRow getAbsoluteRow(int row) throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "absolute");
        }
        this.attachStatementContext();
        if (!this.isTopResultSet) {
            SanityManager.THROWASSERT(this + "expected to be the top ResultSet");
        }
        if (row == 0) {
            this.setBeforeFirstRow();
            return null;
        }
        if (this.seenLast && row > this.lastPosition) {
            return this.setAfterLastRow();
        }
        if (row > 0) {
            if (row <= this.positionInSource) {
                return this.getRowFromHashTable(row);
            }
            ExecRow result = null;
            for (int diff = row - this.positionInSource; diff > 0 && (result = this.getNextRowFromSource()) != null; --diff) {
            }
            if (result != null) {
                result = this.getRowFromHashTable(row);
            }
            this.currentRow = result;
            return result;
        }
        if (row < 0) {
            int beyondResult;
            if (!this.seenLast) {
                this.getLastRow();
            }
            if ((beyondResult = this.lastPosition + 1) + row > 0) {
                return this.getRowFromHashTable(beyondResult + row);
            }
            return this.setBeforeFirstRow();
        }
        this.currentRow = null;
        return null;
    }

    public ExecRow getRelativeRow(int row) throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "relative");
        }
        this.attachStatementContext();
        if (!this.isTopResultSet) {
            SanityManager.THROWASSERT(this + "expected to be the top ResultSet");
        }
        if (row == 0) {
            if (this.beforeFirst || this.afterLast || this.currentPosition == 0) {
                return null;
            }
            return this.getRowFromHashTable(this.currentPosition);
        }
        if (row > 0) {
            return this.getAbsoluteRow(this.currentPosition + row);
        }
        if (this.currentPosition + row < 0) {
            return this.setBeforeFirstRow();
        }
        return this.getAbsoluteRow(this.currentPosition + row);
    }

    public ExecRow setBeforeFirstRow() {
        this.currentPosition = 0;
        this.beforeFirst = true;
        this.afterLast = false;
        this.currentRow = null;
        return null;
    }

    public ExecRow getFirstRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "first");
        }
        if (this.seenFirst) {
            return this.getRowFromHashTable(1);
        }
        this.attachStatementContext();
        if (!this.isTopResultSet) {
            SanityManager.THROWASSERT(this + "expected to be the top ResultSet");
        }
        return this.getNextRowCore();
    }

    public ExecRow getNextRowCore() throws StandardException {
        ExecRow result = null;
        this.beginTime = this.getCurrentTimeMillis();
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "next");
        }
        if (this.seenLast && this.currentPosition == this.lastPosition) {
            return this.setAfterLastRow();
        }
        if (this.currentPosition == this.positionInSource) {
            result = this.getNextRowFromSource();
            if (result != null) {
                result = this.getRowFromHashTable(this.currentPosition);
            }
        } else {
            result = this.currentPosition < this.positionInSource ? this.getRowFromHashTable(this.currentPosition + 1) : null;
        }
        if (result != null) {
            ++this.rowsSeen;
            this.afterLast = false;
        }
        this.currentRow = result;
        this.setCurrentRow(this.currentRow);
        this.beforeFirst = false;
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return result;
    }

    public ExecRow getPreviousRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "next");
        }
        if (!this.isTopResultSet) {
            SanityManager.THROWASSERT(this + "expected to be the top ResultSet");
        }
        if (this.beforeFirst || this.currentPosition == 0) {
            this.currentRow = null;
            return null;
        }
        if (this.afterLast) {
            if (this.lastPosition == 0) {
                this.afterLast = false;
                this.beforeFirst = false;
                this.currentRow = null;
                return null;
            }
            return this.getRowFromHashTable(this.lastPosition);
        }
        --this.currentPosition;
        if (this.currentPosition == 0) {
            this.setBeforeFirstRow();
            return null;
        }
        return this.getRowFromHashTable(this.currentPosition);
    }

    public ExecRow getLastRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "next");
        }
        if (!this.seenLast) {
            this.attachStatementContext();
            if (!this.isTopResultSet) {
                SanityManager.THROWASSERT(this + "expected to be the top ResultSet");
            }
            ExecRow result = null;
            while ((result = this.getNextRowFromSource()) != null) {
            }
        }
        if (!this.seenLast) {
            SanityManager.THROWASSERT(this + "expected to have seen last");
        }
        this.beforeFirst = false;
        this.afterLast = false;
        if (this.lastPosition == 0) {
            this.currentRow = null;
            return null;
        }
        return this.getRowFromHashTable(this.lastPosition);
    }

    public ExecRow setAfterLastRow() throws StandardException {
        if (!this.seenLast) {
            this.getLastRow();
        }
        if (this.lastPosition == 0) {
            this.currentPosition = 0;
            this.afterLast = false;
        } else {
            this.currentPosition = this.lastPosition + 1;
            this.afterLast = true;
        }
        this.beforeFirst = false;
        this.currentRow = null;
        return null;
    }

    public boolean checkRowPosition(int isType) throws StandardException {
        switch (isType) {
            case 101: {
                if (!this.beforeFirst) {
                    return false;
                }
                if (this.seenFirst) {
                    return true;
                }
                ExecRow firstRow = this.getFirstRow();
                if (firstRow == null) {
                    return false;
                }
                this.getPreviousRow();
                return true;
            }
            case 102: {
                return this.currentPosition == 1;
            }
            case 103: {
                if (this.beforeFirst || this.afterLast || this.currentPosition == 0 || this.currentPosition < this.positionInSource) {
                    return false;
                }
                if (this.seenLast) {
                    return this.currentPosition == this.lastPosition;
                }
                int savePosition = this.currentPosition;
                boolean retval = this.getNextRowFromSource() == null;
                this.getRowFromHashTable(savePosition);
                return retval;
            }
            case 104: {
                return this.afterLast;
            }
        }
        return false;
    }

    public int getRowNumber() {
        return this.currentRow == null ? 0 : this.currentPosition;
    }

    private ExecRow getNextRowFromSource() throws StandardException {
        ExecRow sourceRow = null;
        Object result = null;
        if (this.maxRows > 0 && this.maxRows == this.positionInSource) {
            this.seenLast = true;
            this.lastPosition = this.positionInSource;
            this.afterLast = true;
            return null;
        }
        if (this.needsRepositioning) {
            this.positionInLastFetchedRow();
            this.needsRepositioning = false;
        }
        if ((sourceRow = this.source.getNextRowCore()) != null) {
            this.seenFirst = true;
            this.beforeFirst = false;
            long beginTCTime = this.getCurrentTimeMillis();
            if (this.resultRow == null) {
                this.resultRow = this.activation.getExecutionFactory().getValueRow(this.sourceRowWidth);
            }
            ++this.positionInSource;
            this.currentPosition = this.positionInSource;
            RowLocation rowLoc = null;
            if (this.source.isForUpdate()) {
                rowLoc = ((CursorResultSet)((Object)this.source)).getRowLocation();
            }
            this.addRowToHashTable(sourceRow, this.currentPosition, rowLoc, false);
        } else {
            if (!this.seenLast) {
                this.lastPosition = this.positionInSource;
            }
            this.seenLast = true;
            if (this.positionInSource == 0) {
                this.afterLast = false;
            } else {
                this.afterLast = true;
                this.currentPosition = this.positionInSource + 1;
            }
        }
        return sourceRow;
    }

    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.currentRow = null;
            this.source.close();
            if (this.ht != null) {
                this.ht.close();
                this.ht = null;
            }
            super.close();
        } else {
            SanityManager.DEBUG("CloseRepeatInfo", "Close of ScrollInsensitiveResultSet repeated");
        }
        this.setBeforeFirstRow();
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    public void finish() throws StandardException {
        this.source.finish();
        this.finishAndRTS();
    }

    public long getTimeSpent(int type) {
        long totTime = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (type == 0) {
            return totTime - this.source.getTimeSpent(1);
        }
        return totTime;
    }

    public RowLocation getRowLocation() throws StandardException {
        SanityManager.ASSERT(this.source instanceof CursorResultSet, "source not CursorResultSet");
        return ((CursorResultSet)((Object)this.source)).getRowLocation();
    }

    public ExecRow getCurrentRow() throws StandardException {
        if (this.isForUpdate() && this.isDeleted()) {
            return null;
        }
        return this.currentRow;
    }

    private void addRowToHashTable(ExecRow sourceRow, int position, RowLocation rowLoc, boolean rowUpdated) throws StandardException {
        DataValueDescriptor[] hashRowArray = new DataValueDescriptor[this.sourceRowWidth + this.extraColumns];
        hashRowArray[0] = new SQLInteger(position);
        if (this.isForUpdate()) {
            hashRowArray[1] = rowLoc.getClone();
            hashRowArray[2] = new SQLBoolean(false);
            hashRowArray[3] = new SQLBoolean(rowUpdated);
        }
        DataValueDescriptor[] sourceRowArray = sourceRow.getRowArray();
        System.arraycopy(sourceRowArray, 0, hashRowArray, this.extraColumns, sourceRowArray.length);
        this.ht.putRow(true, hashRowArray);
        ++this.numToHashTable;
    }

    private ExecRow getRowFromHashTable(int position) throws StandardException {
        this.positionInHashTable.setValue(position);
        DataValueDescriptor[] hashRowArray = (DataValueDescriptor[])this.ht.get(this.positionInHashTable);
        SanityManager.ASSERT(hashRowArray != null, "hashRowArray expected to be non-null");
        DataValueDescriptor[] resultRowArray = new DataValueDescriptor[hashRowArray.length - this.extraColumns];
        System.arraycopy(hashRowArray, this.extraColumns, resultRowArray, 0, resultRowArray.length);
        this.resultRow.setRowArray(resultRowArray);
        this.currentPosition = position;
        ++this.numFromHashTable;
        if (this.resultRow != null) {
            this.beforeFirst = false;
            this.afterLast = false;
        }
        if (this.isForUpdate()) {
            RowLocation rowLoc = (RowLocation)hashRowArray[1];
            ((NoPutResultSet)((Object)this.target)).setCurrentRow(this.resultRow);
            ((NoPutResultSet)((Object)this.target)).positionScanAtRowLocation(rowLoc);
            this.needsRepositioning = true;
        }
        this.setCurrentRow(this.resultRow);
        return this.resultRow;
    }

    private DataValueDescriptor[] getRowArrayFromHashTable(int position) throws StandardException {
        this.positionInHashTable.setValue(position);
        DataValueDescriptor[] hashRowArray = (DataValueDescriptor[])this.ht.get(this.positionInHashTable);
        DataValueDescriptor[] resultRowArray = new DataValueDescriptor[hashRowArray.length - this.extraColumns];
        System.arraycopy(hashRowArray, this.extraColumns, resultRowArray, 0, resultRowArray.length);
        return resultRowArray;
    }

    private void positionInLastFetchedRow() throws StandardException {
        if (this.positionInSource > 0) {
            this.positionInHashTable.setValue(this.positionInSource);
            DataValueDescriptor[] hashRowArray = (DataValueDescriptor[])this.ht.get(this.positionInHashTable);
            RowLocation rowLoc = (RowLocation)hashRowArray[1];
            ((NoPutResultSet)((Object)this.target)).positionScanAtRowLocation(rowLoc);
            this.currentPosition = this.positionInSource;
        }
    }

    public void updateRow(ExecRow row) throws StandardException {
        ExecRow newRow = row;
        boolean undoProjection = false;
        if (this.source instanceof ProjectRestrictResultSet) {
            newRow = ((ProjectRestrictResultSet)this.source).doBaseRowProjection(row);
            undoProjection = true;
        }
        this.positionInHashTable.setValue(this.currentPosition);
        DataValueDescriptor[] hashRowArray = (DataValueDescriptor[])this.ht.get(this.positionInHashTable);
        RowLocation rowLoc = (RowLocation)hashRowArray[1];
        this.ht.remove(new SQLInteger(this.currentPosition));
        this.addRowToHashTable(newRow, this.currentPosition, rowLoc, true);
        if (undoProjection) {
            DataValueDescriptor[] newRowData = newRow.getRowArray();
            int[] origPos = ((ProjectRestrictResultSet)this.source).getBaseProjectMapping();
            DataValueDescriptor[] backedData = this.getRowArrayFromHashTable(this.currentPosition);
            for (int i = 0; i < origPos.length; ++i) {
                if (origPos[i] < 0) continue;
                row.setColumn(origPos[i], backedData[i]);
            }
        } else {
            row.setRowArray(this.getRowArrayFromHashTable(this.currentPosition));
        }
    }

    public void markRowAsDeleted() throws StandardException {
        this.positionInHashTable.setValue(this.currentPosition);
        DataValueDescriptor[] hashRowArray = (DataValueDescriptor[])this.ht.get(this.positionInHashTable);
        RowLocation rowLoc = (RowLocation)hashRowArray[1];
        this.ht.remove(new SQLInteger(this.currentPosition));
        ((SQLBoolean)hashRowArray[2]).setValue(true);
        for (int i = this.extraColumns; i < hashRowArray.length; ++i) {
            hashRowArray[i].setToNull();
        }
        this.ht.putRow(true, hashRowArray);
    }

    public boolean isDeleted() throws StandardException {
        if (this.currentPosition <= this.positionInSource && this.currentPosition > 0) {
            this.positionInHashTable.setValue(this.currentPosition);
            DataValueDescriptor[] hashRowArray = (DataValueDescriptor[])this.ht.get(this.positionInHashTable);
            return hashRowArray[2].getBoolean();
        }
        return false;
    }

    public boolean isUpdated() throws StandardException {
        if (this.currentPosition <= this.positionInSource && this.currentPosition > 0) {
            this.positionInHashTable.setValue(this.currentPosition);
            DataValueDescriptor[] hashRowArray = (DataValueDescriptor[])this.ht.get(this.positionInHashTable);
            return hashRowArray[3].getBoolean();
        }
        return false;
    }

    public boolean isForUpdate() {
        return this.source.isForUpdate();
    }
}

