/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Iterator;
import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.RoutinePermsDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.PrivilegeInfo;

public class RoutinePrivilegeInfo
extends PrivilegeInfo {
    private AliasDescriptor aliasDescriptor;

    public RoutinePrivilegeInfo(AliasDescriptor aliasDescriptor) {
        this.aliasDescriptor = aliasDescriptor;
    }

    public void executeGrantRevoke(Activation activation, boolean grant, List grantees) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        String currentUser = lcc.getAuthorizationId();
        TransactionController tc = lcc.getTransactionExecute();
        this.checkOwnership(currentUser, this.aliasDescriptor, dd.getSchemaDescriptor(this.aliasDescriptor.getSchemaUUID(), tc), dd);
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        RoutinePermsDescriptor routinePermsDesc = ddg.newRoutinePermsDescriptor(this.aliasDescriptor, currentUser);
        dd.startWriting(lcc);
        Iterator itr = grantees.iterator();
        while (itr.hasNext()) {
            boolean privileges_revoked = false;
            String grantee = (String)itr.next();
            if (dd.addRemovePermissionsDescriptor(grant, routinePermsDesc, grantee, tc)) {
                privileges_revoked = true;
                dd.getDependencyManager().invalidateFor(routinePermsDesc, 45, lcc);
                dd.getDependencyManager().invalidateFor(this.aliasDescriptor, 23, lcc);
            }
            this.addWarningIfPrivilegeNotRevoked(activation, grant, privileges_revoked, grantee);
        }
    }
}

